/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.smallrye.jwt.runtime.auth.ClaimAttributes;
import io.smallrye.jwt.auth.principal.DefaultJWTCallerPrincipal;
import org.jose4j.jwt.JwtClaims;
import org.wildfly.security.authz.Attributes;

public class ElytronJwtCallerPrincipal
extends DefaultJWTCallerPrincipal {
    private Attributes claims;
    private String customPrincipalName;

    public ElytronJwtCallerPrincipal(String customPrincipalName, Attributes claims) {
        super(ElytronJwtCallerPrincipal.getClaimsSet(claims));
        this.claims = claims;
        this.customPrincipalName = customPrincipalName;
    }

    public ElytronJwtCallerPrincipal(String customPrincipalName, JwtClaims claimsSet) {
        this(customPrincipalName, new ClaimAttributes(claimsSet));
    }

    public ElytronJwtCallerPrincipal(Attributes claims) {
        this(null, claims);
    }

    public Attributes getClaims() {
        return this.claims;
    }

    private static JwtClaims getClaimsSet(Attributes claims) {
        if (!(claims instanceof ClaimAttributes)) {
            throw new IllegalStateException("ElytronJwtCallerPrincipal requires Attributes to be a: " + ClaimAttributes.class.getName());
        }
        return ((ClaimAttributes)claims).getClaimsSet();
    }

    public String getName() {
        return this.customPrincipalName != null ? this.customPrincipalName : super.getName();
    }
}

