/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.smallrye.jwt.runtime.auth.JWTCredential;
import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.undertow.UndertowLogger;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.Headers;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JWTAuthMechanism
implements AuthenticationMechanism {
    private JWTAuthContextInfo authContextInfo;
    private IdentityManager identityManager;

    public JWTAuthMechanism(JWTAuthContextInfo authContextInfo, IdentityManager identityManager) {
        this.authContextInfo = authContextInfo;
        this.identityManager = identityManager;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        String jwtToken = new UndertowBearerTokenExtractor(this.authContextInfo, exchange).getBearerToken();
        if (jwtToken != null) {
            try {
                Account account;
                JWTCredential credential = new JWTCredential(jwtToken, this.authContextInfo);
                if (UndertowLogger.SECURITY_LOGGER.isTraceEnabled()) {
                    UndertowLogger.SECURITY_LOGGER.tracef("Bearer token: %s", (Object)jwtToken);
                }
                if ((account = this.identityManager.verify(credential.getName(), (Credential)credential)) != null) {
                    this.preparePrincipalProducer((JsonWebToken)account.getPrincipal());
                    securityContext.authenticationComplete(account, "MP-JWT", false);
                    UndertowLogger.SECURITY_LOGGER.debugf("Authenticated caller(%s) for path(%s) with roles: %s", (Object)credential.getName(), (Object)exchange.getRequestPath(), (Object)account.getRoles());
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                }
                UndertowLogger.SECURITY_LOGGER.info((Object)"Failed to authenticate JWT bearer token");
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            catch (Exception e) {
                UndertowLogger.SECURITY_LOGGER.infof((Throwable)e, "Failed to validate JWT bearer token", new Object[0]);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    private void preparePrincipalProducer(JsonWebToken jwtPrincipal) {
        PrincipalProducer principalProducer = (PrincipalProducer)CDI.current().select(PrincipalProducer.class, new Annotation[0]).get();
        principalProducer.setJsonWebToken(jwtPrincipal);
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, "Bearer {token}");
        UndertowLogger.SECURITY_LOGGER.debugf("Sending Bearer {token} challenge for %s", (Object)exchange);
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }

    private static class UndertowBearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private HttpServerExchange httpExchange;

        UndertowBearerTokenExtractor(JWTAuthContextInfo authContextInfo, HttpServerExchange exchange) {
            super(authContextInfo);
            this.httpExchange = exchange;
        }

        protected String getHeaderValue(String headerName) {
            return this.httpExchange.getRequestHeaders().getFirst(headerName);
        }

        protected String getCookieValue(String cookieName) {
            Cookie cookie = (Cookie)this.httpExchange.getRequestCookies().get(cookieName);
            return cookie != null ? cookie.getValue() : null;
        }
    }
}

