/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.smallrye.jwt.runtime.auth.ClaimAttributes;
import io.smallrye.jwt.auth.principal.DefaultJWTTokenParser;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.ParseException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtContext;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.evidence.BearerTokenEvidence;

@ApplicationScoped
public class MpJwtValidator
implements TokenValidator {
    @Inject
    JWTAuthContextInfo authContextInfo;
    private DefaultJWTTokenParser parser = new DefaultJWTTokenParser();

    public MpJwtValidator() {
    }

    public MpJwtValidator(JWTAuthContextInfo authContextInfo) {
        this.authContextInfo = authContextInfo;
    }

    public Attributes validate(BearerTokenEvidence evidence) throws RealmUnavailableException {
        JwtClaims claimsSet = this.validateClaimsSet(evidence.getToken());
        return new ClaimAttributes(claimsSet);
    }

    private JwtClaims validateClaimsSet(String token) throws RealmUnavailableException {
        try {
            JwtContext jwtContext = this.parser.parse(token, this.authContextInfo);
            return jwtContext.getJwtClaims();
        }
        catch (ParseException e) {
            throw new RealmUnavailableException("Failed to verify token", (Throwable)e);
        }
    }
}

