/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class JWTAuthMechanism
implements HttpAuthenticationMechanism {
    @Inject
    private JWTAuthContextInfo authContextInfo;

    private void preparePrincipalProducer(JsonWebToken jwtPrincipal) {
        PrincipalProducer principalProducer = (PrincipalProducer)CDI.current().select(PrincipalProducer.class, new Annotation[0]).get();
        principalProducer.setJsonWebToken(jwtPrincipal);
    }

    public CompletionStage<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        String jwtToken = new VertxBearerTokenExtractor(this.authContextInfo, context).getBearerToken();
        if (jwtToken != null) {
            return identityProviderManager.authenticate((AuthenticationRequest)new TokenAuthenticationRequest(new TokenCredential(jwtToken, "bearer")));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
        ChallengeData result = new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), (CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, "Bearer {token}");
        return CompletableFuture.completedFuture(result);
    }

    private static class VertxBearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private RoutingContext httpExchange;

        VertxBearerTokenExtractor(JWTAuthContextInfo authContextInfo, RoutingContext exchange) {
            super(authContextInfo);
            this.httpExchange = exchange;
        }

        protected String getHeaderValue(String headerName) {
            return this.httpExchange.request().headers().get(headerName);
        }

        protected String getCookieValue(String cookieName) {
            io.vertx.ext.web.Cookie cookie;
            String cookieHeader = this.httpExchange.request().headers().get(HttpHeaders.COOKIE);
            if (cookieHeader != null && this.httpExchange.cookieCount() == 0) {
                Set nettyCookies = ServerCookieDecoder.STRICT.decode(cookieHeader);
                for (Cookie cookie2 : nettyCookies) {
                    if (!cookie2.name().equals(cookieName)) continue;
                    return cookie2.value();
                }
            }
            return (cookie = this.httpExchange.getCookie(cookieName)) != null ? cookie.getValue() : null;
        }
    }
}

