/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.smallrye.jwt.runtime.auth.QuarkusJwtCallerPrincipal;
import io.smallrye.jwt.auth.principal.DefaultJWTTokenParser;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.ParseException;
import java.security.Principal;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;

@ApplicationScoped
public class MpJwtValidator
implements IdentityProvider<TokenAuthenticationRequest> {
    private static final Logger log = Logger.getLogger(MpJwtValidator.class);
    final JWTAuthContextInfo authContextInfo;
    private final DefaultJWTTokenParser parser = new DefaultJWTTokenParser();

    public MpJwtValidator() {
        this.authContextInfo = null;
    }

    @Inject
    public MpJwtValidator(JWTAuthContextInfo authContextInfo) {
        this.authContextInfo = authContextInfo;
    }

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public CompletionStage<SecurityIdentity> authenticate(TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        try {
            JwtContext jwtContext = this.parser.parse(request.getToken().getToken(), this.authContextInfo);
            JwtClaims claims = jwtContext.getJwtClaims();
            String name = (String)claims.getClaimValue("upn", String.class);
            if (name == null && (name = (String)claims.getClaimValue("preferred_username", String.class)) == null) {
                name = claims.getSubject();
            }
            QuarkusJwtCallerPrincipal principal = new QuarkusJwtCallerPrincipal(name, claims);
            return CompletableFuture.completedFuture(QuarkusSecurityIdentity.builder().setPrincipal((Principal)((Object)principal)).addRoles(new HashSet(claims.getStringListClaimValue("groups"))).addAttribute("quarkus.user", (Object)principal).build());
        }
        catch (ParseException | MalformedClaimException e) {
            log.debug((Object)"Authentication failed", e);
            CompletableFuture<SecurityIdentity> cf = new CompletableFuture<SecurityIdentity>();
            cf.completeExceptionally((Throwable)new AuthenticationFailedException(e));
            return cf;
        }
    }
}

