/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.smallrye.jwt.runtime.auth.JsonWebTokenCredential;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

@ApplicationScoped
public class JWTAuthMechanism
implements HttpAuthenticationMechanism {
    protected static final String COOKIE_HEADER = "Cookie";
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String BEARER = "Bearer";
    @Inject
    private JWTAuthContextInfo authContextInfo;

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        String jwtToken = new VertxBearerTokenExtractor(this.authContextInfo, context).getBearerToken();
        if (jwtToken != null) {
            context.put(HttpAuthenticationMechanism.class.getName(), (Object)this);
            return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new TokenAuthenticationRequest((TokenCredential)new JsonWebTokenCredential(jwtToken)), (RoutingContext)context));
        }
        return Uni.createFrom().optional(Optional.empty());
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        ChallengeData result = new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), (CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, BEARER);
        return Uni.createFrom().item((Object)result);
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        String tokenHeaderName = this.authContextInfo.getTokenHeader();
        if (COOKIE_HEADER.equals(tokenHeaderName)) {
            String tokenCookieName = this.authContextInfo.getTokenCookie();
            if (tokenCookieName == null) {
                tokenCookieName = BEARER;
            }
            return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.COOKIE, tokenCookieName));
        }
        if (AUTHORIZATION_HEADER.equals(tokenHeaderName)) {
            return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, BEARER));
        }
        return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.OTHER_HEADER, tokenHeaderName));
    }

    private static class VertxBearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private RoutingContext httpExchange;

        VertxBearerTokenExtractor(JWTAuthContextInfo authContextInfo, RoutingContext exchange) {
            super(authContextInfo);
            this.httpExchange = exchange;
        }

        protected String getHeaderValue(String headerName) {
            return this.httpExchange.request().headers().get(headerName);
        }

        protected String getCookieValue(String cookieName) {
            io.vertx.core.http.Cookie cookie;
            String cookieHeader = this.httpExchange.request().headers().get(HttpHeaders.COOKIE);
            if (cookieHeader != null && this.httpExchange.cookieCount() == 0) {
                Set nettyCookies = ServerCookieDecoder.STRICT.decode(cookieHeader);
                for (Cookie cookie2 : nettyCookies) {
                    if (!cookie2.name().equals(cookieName)) continue;
                    return cookie2.value();
                }
            }
            return (cookie = this.httpExchange.getCookie(cookieName)) != null ? cookie.getValue() : null;
        }
    }
}

