/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.jwt.auth.cdi.NullJsonWebToken;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Priority(value=1)
@Alternative
@RequestScoped
public class JwtPrincipalProducer {
    @Inject
    SecurityIdentity identity;

    @Produces
    @RequestScoped
    JsonWebToken currentJWTPrincipalOrNull() {
        if (this.identity.isAnonymous()) {
            return new NullJsonWebToken();
        }
        if (this.identity.getPrincipal() instanceof JsonWebToken) {
            return (JsonWebToken)this.identity.getPrincipal();
        }
        throw new IllegalStateException("Current principal " + String.valueOf(this.identity.getPrincipal()) + " is not a JSON web token");
    }
}

