/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.smallrye.metrics.deployment.SmallRyeMetricsDotNames;
import io.quarkus.smallrye.metrics.deployment.jandex.JandexBeanInfoAdapter;
import io.quarkus.smallrye.metrics.deployment.jandex.JandexMemberInfoAdapter;
import io.quarkus.smallrye.metrics.deployment.spi.MetricBuildItem;
import io.quarkus.smallrye.metrics.runtime.MetadataHolder;
import io.quarkus.smallrye.metrics.runtime.SmallRyeMetricsRecorder;
import io.quarkus.smallrye.metrics.runtime.TagHolder;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.smallrye.metrics.MetricProducer;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRequestHandler;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.interceptors.ConcurrentGaugeInterceptor;
import io.smallrye.metrics.interceptors.CountedInterceptor;
import io.smallrye.metrics.interceptors.MeteredInterceptor;
import io.smallrye.metrics.interceptors.MetricNameFactory;
import io.smallrye.metrics.interceptors.MetricsInterceptor;
import io.smallrye.metrics.interceptors.TimedInterceptor;
import io.vertx.core.Handler;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeMetricsProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"io.quarkus.smallrye.metrics.deployment.SmallRyeMetricsProcessor");
    SmallRyeMetricsConfig metrics;

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createRoute(BuildProducer<RouteBuildItem> routes, SmallRyeMetricsRecorder recorder, HttpRootPathBuildItem httpRoot, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, LaunchModeBuildItem launchModeBuildItem) {
        Function route = recorder.route(this.metrics.path + (this.metrics.path.endsWith("/") ? "*" : "/*"));
        Function slash = recorder.route(this.metrics.path);
        if (launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.metrics.path));
        }
        routes.produce((BuildItem)new RouteBuildItem(route, (Handler)recorder.handler(httpRoot.adjustPath(this.metrics.path)), HandlerType.BLOCKING));
        routes.produce((BuildItem)new RouteBuildItem(slash, (Handler)recorder.handler(httpRoot.adjustPath(this.metrics.path)), HandlerType.BLOCKING));
    }

    @BuildStep
    void beans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{MetricProducer.class, MetricNameFactory.class, MetricRegistries.class, MetricsInterceptor.class, MeteredInterceptor.class, ConcurrentGaugeInterceptor.class, CountedInterceptor.class, TimedInterceptor.class, MetricsRequestHandler.class}));
        unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(MetricsRequestHandler.class.getName())));
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformBeanScope(final BeanArchiveIndexBuildItem index) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public int getPriority() {
                return 900;
            }

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (ctx.isClass()) {
                    if (BuiltinScope.isIn((Iterable)ctx.getAnnotations())) {
                        return;
                    }
                    ClassInfo clazz = ctx.getTarget().asClass();
                    if (!SmallRyeMetricsProcessor.this.isJaxRsEndpoint(clazz) && !SmallRyeMetricsProcessor.this.isJaxRsProvider(clazz)) {
                        while (clazz != null && clazz.superName() != null) {
                            Map annotations = clazz.annotations();
                            if (annotations.containsKey(SmallRyeMetricsDotNames.GAUGE) || annotations.containsKey(SmallRyeMetricsDotNames.CONCURRENT_GAUGE) || annotations.containsKey(SmallRyeMetricsDotNames.COUNTED) || annotations.containsKey(SmallRyeMetricsDotNames.METERED) || annotations.containsKey(SmallRyeMetricsDotNames.TIMED) || annotations.containsKey(SmallRyeMetricsDotNames.METRIC)) {
                                LOGGER.debugf("Found metrics business methods on a class %s with no scope defined - adding @Dependent", (Object)ctx.getTarget());
                                ((Transformation)ctx.transform().add(Dependent.class, new AnnotationValue[0])).done();
                                break;
                            }
                            clazz = index.getIndex().getClassByName(clazz.superName());
                        }
                    }
                }
            }
        });
    }

    @BuildStep
    void annotationTransformers(BuildProducer<AnnotationsTransformerBuildItem> transformers) {
        transformers.produce((BuildItem)new AnnotationsTransformerBuildItem(ctx -> {
            if (ctx.isClass()) {
                ClassInfo clazz = ctx.getTarget().asClass();
                if (clazz.name().toString().startsWith(MetricsInterceptor.class.getPackage().getName())) {
                    return;
                }
                if (clazz.annotations().keySet().contains(SmallRyeMetricsDotNames.GAUGE)) {
                    BuiltinScope beanScope = BuiltinScope.from((ClassInfo)clazz);
                    if (!(this.isJaxRsEndpoint(clazz) || beanScope == null || beanScope.equals((Object)BuiltinScope.APPLICATION) || beanScope.equals((Object)BuiltinScope.SINGLETON))) {
                        LOGGER.warnf("Bean %s declares a org.eclipse.microprofile.metrics.annotation.Gauge but is of a scope that typically creates multiple instances. Gauges are forbidden on beans that create multiple instances, this will cause errors when constructing them. Please use annotated gauges only in beans with @ApplicationScoped or @Singleton scopes, or in JAX-RS endpoints.", (Object)clazz.name().toString());
                    }
                    ((Transformation)ctx.transform().add(AnnotationInstance.create((DotName)SmallRyeMetricsDotNames.METRICS_BINDING, (AnnotationTarget)ctx.getTarget(), (AnnotationValue[])new AnnotationValue[0]))).done();
                }
            }
        }));
    }

    @BuildStep
    AutoInjectAnnotationBuildItem autoInjectMetric() {
        return new AutoInjectAnnotationBuildItem(new DotName[]{SmallRyeMetricsDotNames.METRIC});
    }

    @BuildStep
    public CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.metrics");
    }

    @BuildStep
    public FeatureBuildItem feature() {
        return new FeatureBuildItem("smallrye-metrics");
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(BeanContainerBuildItem beanContainerBuildItem, SmallRyeMetricsRecorder metrics, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        for (DotName metricsAnnotation : SmallRyeMetricsDotNames.METRICS_ANNOTATIONS) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{metricsAnnotation.toString()}));
        }
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{SmallRyeMetricsDotNames.METRICS_BINDING.toString()}));
        metrics.createRegistries(beanContainerBuildItem.getValue());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerBaseAndVendorMetrics(SmallRyeMetricsRecorder metrics, ShutdownContextBuildItem shutdown) {
        metrics.registerBaseMetrics((ShutdownContext)shutdown);
        metrics.registerVendorMetrics((ShutdownContext)shutdown);
    }

    @BuildStep
    public void logCleanup(BuildProducer<LogCleanupFilterBuildItem> logCleanupFilter) {
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("io.smallrye.metrics.MetricsRegistryImpl", new String[]{"Register metric ["}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerMetricsFromAnnotatedMethods(SmallRyeMetricsRecorder metrics, BeanArchiveIndexBuildItem beanArchiveIndex) {
        IndexView index = beanArchiveIndex.getIndex();
        JandexBeanInfoAdapter beanInfoAdapter = new JandexBeanInfoAdapter(index);
        JandexMemberInfoAdapter memberInfoAdapter = new JandexMemberInfoAdapter(index);
        HashSet<MethodInfo> collectedMetricsMethods = new HashSet<MethodInfo>();
        HashMap<DotName, ClassInfo> collectedMetricsClasses = new HashMap<DotName, ClassInfo>();
        for (DotName metricAnnotation : SmallRyeMetricsDotNames.METRICS_ANNOTATIONS) {
            Collection metricAnnotationInstances = index.getAnnotations(metricAnnotation);
            for (AnnotationInstance metricAnnotationInstance : metricAnnotationInstances) {
                AnnotationTarget metricAnnotationTarget = metricAnnotationInstance.target();
                switch (metricAnnotationTarget.kind()) {
                    case METHOD: {
                        MethodInfo method = metricAnnotationTarget.asMethod();
                        if (method.declaringClass().name().toString().startsWith("io.smallrye.metrics")) break;
                        collectedMetricsMethods.add(method);
                        break;
                    }
                    case CLASS: {
                        ClassInfo clazz = metricAnnotationTarget.asClass();
                        if (clazz.name().toString().startsWith("io.smallrye.metrics")) break;
                        this.collectMetricsClassAndSubClasses(index, collectedMetricsClasses, clazz);
                        break;
                    }
                }
            }
        }
        for (ClassInfo clazz : collectedMetricsClasses.values()) {
            BeanInfo beanInfo = beanInfoAdapter.convert(clazz);
            ClassInfo superclass = clazz;
            while (superclass != null && superclass.superName() != null) {
                for (MethodInfo method : superclass.methods()) {
                    if (superclass != clazz && clazz.method(method.name(), method.parameters().toArray(new Type[0])) != null || Modifier.isPrivate(method.flags())) continue;
                    metrics.registerMetrics(beanInfo, memberInfoAdapter.convert((AnnotationTarget)method));
                }
                superclass = index.getClassByName(superclass.superName());
            }
        }
        for (MethodInfo method : collectedMetricsMethods) {
            ClassInfo declaringClazz = method.declaringClass();
            if (collectedMetricsClasses.containsKey(declaringClazz.name())) continue;
            BeanInfo beanInfo = beanInfoAdapter.convert(declaringClazz);
            metrics.registerMetrics(beanInfo, memberInfoAdapter.convert((AnnotationTarget)method));
        }
    }

    @BuildStep
    void unremovableProducers(BuildProducer<UnremovableBeanBuildItem> unremovable) {
        final Type type = Type.create((DotName)SmallRyeMetricsDotNames.METRIC_INTERFACE, (Type.Kind)Type.Kind.CLASS);
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new Predicate<io.quarkus.arc.processor.BeanInfo>(){

            @Override
            public boolean test(io.quarkus.arc.processor.BeanInfo beanInfo) {
                io.quarkus.arc.processor.BeanInfo declaringBean = beanInfo.getDeclaringBean();
                return (beanInfo.isProducerMethod() || beanInfo.isProducerField()) && beanInfo.getTypes().contains(type) && !declaringBean.getBeanClass().toString().startsWith("io.smallrye.metrics");
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerMetricsFromProducers(SmallRyeMetricsRecorder recorder, ValidationPhaseBuildItem validationPhase, BeanArchiveIndexBuildItem beanArchiveIndex) {
        IndexView index = beanArchiveIndex.getIndex();
        for (io.quarkus.arc.processor.BeanInfo bean : validationPhase.getContext().beans().producers()) {
            MetricType metricType = this.getMetricType(bean.getImplClazz());
            if (metricType == null) continue;
            AnnotationTarget target = (AnnotationTarget)bean.getTarget().get();
            AnnotationInstance metricAnnotation = null;
            String memberName = null;
            if (bean.isProducerField()) {
                FieldInfo field = target.asField();
                metricAnnotation = field.annotation(SmallRyeMetricsDotNames.METRIC);
                memberName = field.name();
            }
            if (bean.isProducerMethod()) {
                MethodInfo method = target.asMethod();
                metricAnnotation = method.annotation(SmallRyeMetricsDotNames.METRIC);
                memberName = method.name();
            }
            if (metricAnnotation == null) continue;
            String nameValue = metricAnnotation.valueWithDefault(index, "name").asString();
            boolean absolute = metricAnnotation.valueWithDefault(index, "absolute").asBoolean();
            String metricSimpleName = !nameValue.isEmpty() ? nameValue : memberName;
            String declaringClassName = bean.getDeclaringBean().getImplClazz().name().toString();
            String metricsFinalName = absolute ? metricSimpleName : MetricRegistry.name((String)declaringClassName, (String[])new String[]{metricSimpleName});
            recorder.registerMetricFromProducer(bean.getIdentifier(), metricType, metricsFinalName, metricAnnotation.valueWithDefault(index, "tags").asStringArray(), metricAnnotation.valueWithDefault(index, "description").asString(), metricAnnotation.valueWithDefault(index, "displayName").asString(), metricAnnotation.valueWithDefault(index, "unit").asString());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void extensionMetrics(SmallRyeMetricsRecorder recorder, List<MetricBuildItem> additionalMetrics, ShutdownContextBuildItem shutdown, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        if (this.metrics.extensionsEnabled) {
            if (!additionalMetrics.isEmpty()) {
                unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(MetricRegistry.class.getName())));
                unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(MetricRegistries.class.getName())));
            }
            for (MetricBuildItem additionalMetric : additionalMetrics) {
                if (!additionalMetric.isEnabled()) continue;
                TagHolder[] tags = (TagHolder[])Arrays.stream(additionalMetric.getTags()).map(TagHolder::from).toArray(TagHolder[]::new);
                recorder.registerMetric(MetricRegistry.Type.VENDOR, MetadataHolder.from((Metadata)additionalMetric.getMetadata()), tags, additionalMetric.getImplementor(), (ShutdownContext)shutdown);
            }
        }
    }

    private MetricType getMetricType(ClassInfo clazz) {
        DotName name = clazz.name();
        if (name.equals((Object)SmallRyeMetricsDotNames.GAUGE_INTERFACE)) {
            return MetricType.GAUGE;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.COUNTER_INTERFACE)) {
            return MetricType.COUNTER;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.CONCURRENT_GAUGE_INTERFACE)) {
            return MetricType.CONCURRENT_GAUGE;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.HISTOGRAM_INTERFACE)) {
            return MetricType.HISTOGRAM;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.TIMER_INTERFACE)) {
            return MetricType.TIMER;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.METER_INTERFACE)) {
            return MetricType.METERED;
        }
        return null;
    }

    private void collectMetricsClassAndSubClasses(IndexView index, Map<DotName, ClassInfo> collectedMetricsClasses, ClassInfo clazz) {
        collectedMetricsClasses.put(clazz.name(), clazz);
        for (ClassInfo subClass : index.getAllKnownSubclasses(clazz.name())) {
            collectedMetricsClasses.put(subClass.name(), subClass);
        }
    }

    private boolean isJaxRsEndpoint(ClassInfo clazz) {
        return clazz.annotations().containsKey(SmallRyeMetricsDotNames.JAXRS_PATH) || clazz.annotations().containsKey(SmallRyeMetricsDotNames.REST_CONTROLLER);
    }

    private boolean isJaxRsProvider(ClassInfo clazz) {
        return clazz.annotations().containsKey(SmallRyeMetricsDotNames.JAXRS_PROVIDER);
    }

    @ConfigRoot(name="smallrye-metrics")
    static final class SmallRyeMetricsConfig {
        @ConfigItem(defaultValue="/metrics")
        String path;
        @ConfigItem(name="extensions.enabled", defaultValue="true")
        public boolean extensionsEnabled;

        SmallRyeMetricsConfig() {
        }
    }
}

