/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.deployment.jandex;

import io.quarkus.smallrye.metrics.deployment.SmallRyeMetricsDotNames;
import io.quarkus.smallrye.metrics.deployment.jandex.JandexAnnotationInfoAdapter;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.elementdesc.RawBeanInfo;
import io.smallrye.metrics.elementdesc.adapter.BeanInfoAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class JandexBeanInfoAdapter
implements BeanInfoAdapter<ClassInfo> {
    private static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    private final IndexView indexView;

    public JandexBeanInfoAdapter(IndexView indexView) {
        this.indexView = indexView;
    }

    public BeanInfo convert(ClassInfo input) {
        BeanInfo superClassInfo = null;
        DotName superName = input.superName();
        if (superName != null && this.indexView.getClassByName(superName) != null && !superName.equals((Object)OBJECT)) {
            superClassInfo = this.convert(this.indexView.getClassByName(superName));
        }
        JandexAnnotationInfoAdapter annotationInfoAdapter = new JandexAnnotationInfoAdapter(this.indexView);
        ArrayList annotations = new ArrayList();
        ClassInfo clazz = input;
        while (clazz != null && clazz.superName() != null) {
            List annotationsSuper = clazz.classAnnotations().stream().filter(SmallRyeMetricsDotNames::isMetricAnnotation).map(annotationInfoAdapter::convert).collect(Collectors.toList());
            annotations.addAll(annotationsSuper);
            clazz = this.indexView.getClassByName(clazz.superName());
        }
        return new RawBeanInfo(input.simpleName(), input.name().prefix().toString(), annotations, superClassInfo);
    }
}

