/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerRequestFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerResponseFilterBuildItem;
import io.quarkus.smallrye.metrics.deployment.SmallRyeMetricsProcessor;
import io.quarkus.undertow.deployment.FilterBuildItem;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.servlet.DispatcherType;
import org.eclipse.microprofile.config.ConfigProvider;

@BuildSteps(onlyIf={RestMetricsEnabled.class})
public class JaxRsMetricsProcessor {
    static final String SMALLRYE_JAXRS_FILTER_CLASS_NAME = "io.smallrye.metrics.jaxrs.JaxRsMetricsFilter";
    static final String SMALLRYE_JAXRS_SERVLET_FILTER_CLASS_NAME = "io.smallrye.metrics.jaxrs.JaxRsMetricsServletFilter";
    static final String SMALLRYE_QUARKUS_RESTEASY_FILTER_CLASS_NAME = "io.quarkus.smallrye.metrics.runtime.QuarkusRestEasyMetricsFilter";
    static final String SMALLRYE_QUARKUS_REST_FILTER_CLASS_NAME = "io.quarkus.smallrye.metrics.runtime.QuarkusRestMetricsFilter";
    static final String RESTEASY_CONFIG_PROPERTY = "quarkus.resteasy.metrics.enabled";

    @BuildStep
    void enableMetrics(Optional<MetricsCapabilityBuildItem> metricsCapabilityBuildItem, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxRsProviders, BuildProducer<FilterBuildItem> servletFilters, BuildProducer<ContainerRequestFilterBuildItem> containerRequestFilters, BuildProducer<CustomContainerResponseFilterBuildItem> customContainerResponseFilters, Capabilities capabilities) {
        this.warnIfDeprecatedResteasyPropertiesPresent();
        if (metricsCapabilityBuildItem.isPresent()) {
            if (capabilities.isPresent("io.quarkus.servlet")) {
                jaxRsProviders.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(SMALLRYE_JAXRS_FILTER_CLASS_NAME));
                servletFilters.produce((BuildItem)FilterBuildItem.builder((String)"metricsFilter", (String)SMALLRYE_JAXRS_SERVLET_FILTER_CLASS_NAME).setAsyncSupported(true).addFilterUrlMapping("*", DispatcherType.FORWARD).addFilterUrlMapping("*", DispatcherType.INCLUDE).addFilterUrlMapping("*", DispatcherType.REQUEST).addFilterUrlMapping("*", DispatcherType.ASYNC).addFilterUrlMapping("*", DispatcherType.ERROR).build());
            } else if (capabilities.isPresent("io.quarkus.resteasy")) {
                jaxRsProviders.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(SMALLRYE_QUARKUS_RESTEASY_FILTER_CLASS_NAME));
            } else if (capabilities.isPresent("io.quarkus.resteasy.reactive")) {
                customContainerResponseFilters.produce((BuildItem)new CustomContainerResponseFilterBuildItem(SMALLRYE_QUARKUS_REST_FILTER_CLASS_NAME));
            }
        }
    }

    private void warnIfDeprecatedResteasyPropertiesPresent() {
        if (ConfigProvider.getConfig().getOptionalValue(RESTEASY_CONFIG_PROPERTY, Boolean.class).isPresent()) {
            SmallRyeMetricsProcessor.LOGGER.warn((Object)"`quarkus.resteasy.metrics.enabled` is deprecated and will be removed in a future version. Use `quarkus.smallrye-metrics.jaxrs.enabled` to enable metrics for REST endpoints using the smallrye-metrics extension");
        }
    }

    static class RestMetricsEnabled
    implements BooleanSupplier {
        SmallRyeMetricsProcessor.SmallRyeMetricsConfig smConfig;

        RestMetricsEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            boolean resteasyConfigEnabled = ConfigProvider.getConfig().getOptionalValue(JaxRsMetricsProcessor.RESTEASY_CONFIG_PROPERTY, Boolean.class).orElse(false);
            return this.smConfig.extensionsEnabled && (this.smConfig.jaxrsEnabled || resteasyConfigEnabled);
        }
    }
}

