/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.deployment.spi;

import io.quarkus.builder.item.MultiBuildItem;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public final class MetricBuildItem
extends MultiBuildItem {
    private final Metadata metadata;
    private final Tag[] tags;
    private final Object implementor;
    private final boolean enabled;
    private String configRootName;

    public MetricBuildItem(Metadata metadata, boolean enabled, String configRootName, Tag ... tags) {
        if (metadata.getTypeRaw() == MetricType.GAUGE) {
            throw new IllegalArgumentException("Gauges require a non-null implementation object");
        }
        this.metadata = metadata;
        this.tags = tags;
        this.implementor = null;
        this.enabled = enabled;
        this.configRootName = configRootName;
    }

    public MetricBuildItem(Metadata metadata, Object implementor, boolean enabled, String configRootName, Tag ... tags) {
        if (implementor == null && metadata.getTypeRaw() == MetricType.GAUGE) {
            throw new IllegalArgumentException("Gauges require a non-null implementation object");
        }
        this.metadata = metadata;
        this.tags = tags;
        this.implementor = implementor;
        this.enabled = enabled;
        this.configRootName = configRootName;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getConfigRootName() {
        return this.configRootName;
    }
}

