/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.smallrye.metrics.runtime.SmallRyeMetricsServlet;
import io.quarkus.smallrye.metrics.runtime.SmallRyeMetricsTemplate;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.smallrye.metrics.MetricProducer;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRequestHandler;
import io.smallrye.metrics.interceptors.CountedInterceptor;
import io.smallrye.metrics.interceptors.MeteredInterceptor;
import io.smallrye.metrics.interceptors.MetricNameFactory;
import io.smallrye.metrics.interceptors.MetricsBinding;
import io.smallrye.metrics.interceptors.MetricsInterceptor;
import io.smallrye.metrics.interceptors.TimedInterceptor;
import java.util.Collection;
import javax.interceptor.Interceptor;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.jboss.builder.item.BuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class SmallRyeMetricsProcessor {
    SmallRyeMetricsConfig metrics;

    @BuildStep
    ServletBuildItem createServlet() {
        ServletBuildItem servletBuildItem = ServletBuildItem.builder((String)"metrics", (String)SmallRyeMetricsServlet.class.getName()).addMapping(this.metrics.path + (this.metrics.path.endsWith("/") ? "*" : "/*")).build();
        return servletBuildItem;
    }

    @BuildStep
    void beans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{MetricProducer.class, MetricNameFactory.class, MetricRegistries.class, MetricsInterceptor.class, MeteredInterceptor.class, CountedInterceptor.class, TimedInterceptor.class, MetricsRequestHandler.class, SmallRyeMetricsServlet.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(BeanContainerBuildItem beanContainerBuildItem, SmallRyeMetricsTemplate metrics, ShutdownContextBuildItem shutdown, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<FeatureBuildItem> feature) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("smallrye-metrics"));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{Counted.class.getName()}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{MetricsBinding.class.getName()}));
        metrics.createRegistries(beanContainerBuildItem.getValue());
        IndexView index = beanArchiveIndex.getIndex();
        Collection annos = index.getAnnotations(DotName.createSimple((String)Counted.class.getName()));
        for (AnnotationInstance anno : annos) {
            AnnotationTarget target = anno.target();
            if (AnnotationTarget.Kind.CLASS.equals((Object)target.kind()) && target.asClass().classAnnotations().stream().anyMatch(a -> a.name().equals((Object)DotName.createSimple((String)Interceptor.class.getName())))) continue;
            MethodInfo methodInfo = target.asMethod();
            String name = methodInfo.name();
            if (anno.value("name") != null) {
                name = anno.value("name").asString();
            }
            ClassInfo classInfo = methodInfo.declaringClass();
            metrics.registerCounted(classInfo.name().toString(), name, (ShutdownContext)shutdown);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void register(SmallRyeMetricsTemplate metrics, ShutdownContextBuildItem shutdown) {
        metrics.registerBaseMetrics((ShutdownContext)shutdown);
        metrics.registerVendorMetrics((ShutdownContext)shutdown);
    }

    @ConfigRoot(name="smallrye-metrics")
    static final class SmallRyeMetricsConfig {
        @ConfigItem(defaultValue="/metrics")
        String path;

        SmallRyeMetricsConfig() {
        }
    }
}

