/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.smallrye.metrics.runtime.SmallRyeMetricsServlet;
import io.quarkus.smallrye.metrics.runtime.SmallRyeMetricsTemplate;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.smallrye.metrics.MetricProducer;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRequestHandler;
import io.smallrye.metrics.interceptors.CountedInterceptor;
import io.smallrye.metrics.interceptors.MeteredInterceptor;
import io.smallrye.metrics.interceptors.MetricNameFactory;
import io.smallrye.metrics.interceptors.MetricsBinding;
import io.smallrye.metrics.interceptors.MetricsInterceptor;
import io.smallrye.metrics.interceptors.TimedInterceptor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.jboss.builder.item.BuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class SmallRyeMetricsProcessor {
    private static final Set<DotName> metricsAnnotations = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)Gauge.class.getName()), DotName.createSimple((String)Counted.class.getName()), DotName.createSimple((String)Timed.class.getName()), DotName.createSimple((String)Metered.class.getName())));
    SmallRyeMetricsConfig metrics;

    @BuildStep
    ServletBuildItem createServlet() {
        ServletBuildItem servletBuildItem = ServletBuildItem.builder((String)"metrics", (String)SmallRyeMetricsServlet.class.getName()).addMapping(this.metrics.path + (this.metrics.path.endsWith("/") ? "*" : "/*")).build();
        return servletBuildItem;
    }

    @BuildStep
    void beans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{MetricProducer.class, MetricNameFactory.class, MetricRegistries.class, MetricsInterceptor.class, MeteredInterceptor.class, CountedInterceptor.class, TimedInterceptor.class, MetricsRequestHandler.class, SmallRyeMetricsServlet.class}));
    }

    @BuildStep
    void annotationTransformers(BuildProducer<AnnotationsTransformerBuildItem> transformers) {
        transformers.produce((BuildItem)new AnnotationsTransformerBuildItem(ctx -> {
            if (ctx.isClass()) {
                if (ctx.getTarget().asClass().name().toString().startsWith(MetricsInterceptor.class.getPackage().getName())) {
                    return;
                }
                for (DotName annotationName : ctx.getTarget().asClass().annotations().keySet()) {
                    if (!metricsAnnotations.contains(annotationName)) continue;
                    ctx.transform().add(AnnotationInstance.create((DotName)DotName.createSimple((String)MetricsBinding.class.getName()), (AnnotationTarget)ctx.getTarget(), (AnnotationValue[])new AnnotationValue[0])).done();
                    return;
                }
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(BeanContainerBuildItem beanContainerBuildItem, SmallRyeMetricsTemplate metrics, ShutdownContextBuildItem shutdown, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem("smallrye-metrics"));
        for (DotName metricsAnnotation : metricsAnnotations) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{metricsAnnotation.toString()}));
        }
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{MetricsBinding.class.getName()}));
        metrics.createRegistries(beanContainerBuildItem.getValue());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerBaseAndVendorMetrics(SmallRyeMetricsTemplate metrics, ShutdownContextBuildItem shutdown) {
        metrics.registerBaseMetrics((ShutdownContext)shutdown);
        metrics.registerVendorMetrics((ShutdownContext)shutdown);
    }

    @ConfigRoot(name="smallrye-metrics")
    static final class SmallRyeMetricsConfig {
        @ConfigItem(defaultValue="/metrics")
        String path;

        SmallRyeMetricsConfig() {
        }
    }
}

