/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import io.smallrye.metrics.MetricsRequestHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@WebServlet
public class SmallRyeMetricsServlet
extends HttpServlet {
    @Inject
    MetricsRequestHandler metricsHandler;
    @ConfigProperty(name="quarkus.servlet.context-path", defaultValue="/")
    String appContextPath;
    private String contextPath;

    public void init() {
        String metricsPath = this.getInitParameter("metrics.path");
        String metricPathSanitized = metricsPath.startsWith("/") ? metricsPath : "/" + metricsPath;
        String appContextPathSanitized = this.appContextPath.endsWith("/") ? this.appContextPath.substring(0, this.appContextPath.length() - 1) : this.appContextPath;
        this.contextPath = appContextPathSanitized + metricPathSanitized;
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestPath = request.getRequestURI();
        String method = request.getMethod();
        Stream acceptHeaders = Collections.list(request.getHeaders("Accept")).stream();
        this.metricsHandler.handleRequest(requestPath, this.contextPath, method, acceptHeaders, (status, message, headers) -> {
            headers.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
            response.setStatus(status);
            int stepSize = 5000;
            if (message.length() < 5000) {
                response.getWriter().write(message);
            } else {
                for (int i = 0; i < message.length() / 5000 + 1; ++i) {
                    int start = 5000 * i;
                    int chars = Math.min(5000, message.length() - 5000 * i);
                    response.getWriter().write(message.substring(start, start + chars));
                    response.getWriter().flush();
                }
            }
        });
    }
}

