/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.quarkus.smallrye.metrics.runtime.LambdaGauge;
import io.smallrye.metrics.ExtendedMetadata;
import io.smallrye.metrics.ExtendedMetadataBuilder;
import io.smallrye.metrics.MetricRegistries;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

class MicrometerGCMetrics {
    private String youngGenPoolName;
    private String oldGenPoolName;
    private AtomicLong liveDataSize = new AtomicLong(0L);
    private AtomicLong maxDataSize = new AtomicLong(0L);
    private AtomicLong promotedBytes = new AtomicLong(0L);
    private AtomicLong allocatedBytes = new AtomicLong(0L);
    private Map<CauseAndActionWrapper, AtomicLong> gcPauseMax = new HashMap<CauseAndActionWrapper, AtomicLong>();
    private Map<CauseAndActionWrapper, AtomicLong> gcPauseMaxConcurrent = new HashMap<CauseAndActionWrapper, AtomicLong>();
    private Map<NotificationEmitter, NotificationListener> notificationEmitters = new HashMap<NotificationEmitter, NotificationListener>();

    MicrometerGCMetrics() {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = mbean.getName();
            if (this.isYoungGenPool(name)) {
                this.youngGenPoolName = name;
                continue;
            }
            if (!this.isOldGenPool(name)) continue;
            this.oldGenPoolName = name;
        }
    }

    public Long getLiveDataSize() {
        return this.liveDataSize.get();
    }

    public Long getMaxDataSize() {
        return this.maxDataSize.get();
    }

    public Long getPromotedBytes() {
        return this.promotedBytes.get();
    }

    public Long getAllocatedBytes() {
        return this.allocatedBytes.get();
    }

    public void startWatchingNotifications() {
        AtomicLong youngGenSizeAfter = new AtomicLong(0L);
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                long delta;
                if (!notification.getType().equals("com.sun.management.gc.notification")) {
                    return;
                }
                CompositeData cd = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                String gcCause = notificationInfo.getGcCause();
                String gcAction = notificationInfo.getGcAction();
                GcInfo gcInfo = notificationInfo.getGcInfo();
                long duration = gcInfo.getDuration();
                MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE);
                String metricName = this.isConcurrentPhase(gcCause) ? "jvm.gc.concurrent.phase.time" : "jvm.gc.pause";
                Map<CauseAndActionWrapper, AtomicLong> mapForStoringMax = this.isConcurrentPhase(gcCause) ? this.gcPauseMax : this.gcPauseMaxConcurrent;
                Tag[] tags = new Tag[]{new Tag("action", gcAction), new Tag("cause", gcCause)};
                CauseAndActionWrapper causeAndAction = new CauseAndActionWrapper(gcCause, gcAction);
                MetricID pauseSecondsMaxMetricID = new MetricID(metricName + ".seconds.max", tags);
                AtomicLong gcPauseMaxValue = mapForStoringMax.computeIfAbsent(causeAndAction, k -> new AtomicLong(0L));
                if (duration > gcPauseMaxValue.get()) {
                    gcPauseMaxValue.set(duration);
                }
                if (!registry.getGauges().containsKey(pauseSecondsMaxMetricID)) {
                    registry.register((Metadata)new ExtendedMetadataBuilder().withName(metricName + ".seconds.max").withType(MetricType.GAUGE).withUnit("none").withDescription("Time spent in GC pause").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new LambdaGauge(() -> ((AtomicLong)mapForStoringMax.get(causeAndAction)).doubleValue() / 1000.0), tags);
                }
                ExtendedMetadata countMetadata = new ExtendedMetadataBuilder().withName(metricName + ".seconds.count").withType(MetricType.COUNTER).withUnit("none").withDescription("Time spent in GC pause").skipsScopeInOpenMetricsExportCompletely(true).withOpenMetricsKeyOverride(metricName.replace(".", "_") + "_seconds_count").build();
                registry.counter((Metadata)countMetadata, tags).inc();
                registry.counter((Metadata)new ExtendedMetadataBuilder().withName(metricName + ".seconds.sum").withType(MetricType.COUNTER).withUnit("milliseconds").withDescription("Time spent in GC pause").skipsScopeInOpenMetricsExportCompletely(true).withOpenMetricsKeyOverride(metricName.replace(".", "_") + "_seconds_sum").build(), tags).inc(duration);
                Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                if (this.oldGenPoolName != null) {
                    long oldBefore = before.get(this.oldGenPoolName).getUsed();
                    long oldAfter = after.get(this.oldGenPoolName).getUsed();
                    delta = oldAfter - oldBefore;
                    if (delta > 0L) {
                        this.promotedBytes.addAndGet(delta);
                    }
                    if (oldAfter < oldBefore || GcGenerationAge.fromName(notificationInfo.getGcName()) == GcGenerationAge.OLD) {
                        this.liveDataSize.set(oldAfter);
                        long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                        this.maxDataSize.set(oldMaxAfter);
                    }
                }
                if (this.youngGenPoolName != null) {
                    long youngBefore = before.get(this.youngGenPoolName).getUsed();
                    long youngAfter = after.get(this.youngGenPoolName).getUsed();
                    delta = youngBefore - youngGenSizeAfter.get();
                    youngGenSizeAfter.set(youngAfter);
                    if (delta > 0L) {
                        this.allocatedBytes.addAndGet(delta);
                    }
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, null, null);
            this.notificationEmitters.put(notificationEmitter, notificationListener);
        }
    }

    public void cleanUp() {
        this.notificationEmitters.forEach((emitter, listener) -> {
            try {
                emitter.removeNotificationListener((NotificationListener)listener);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {
                // empty catch block
            }
        });
    }

    private boolean isYoungGenPool(String name) {
        return name.endsWith("Eden Space");
    }

    private boolean isOldGenPool(String name) {
        return name.endsWith("Old Gen") || name.endsWith("Tenured Gen");
    }

    private boolean isConcurrentPhase(String cause) {
        return "No GC".equals(cause);
    }

    static enum GcGenerationAge {
        OLD,
        YOUNG,
        UNKNOWN;

        private static Map<String, GcGenerationAge> knownCollectors;

        static GcGenerationAge fromName(String name) {
            return knownCollectors.getOrDefault(name, UNKNOWN);
        }

        static {
            knownCollectors = new HashMap<String, GcGenerationAge>(){
                {
                    this.put("ConcurrentMarkSweep", OLD);
                    this.put("Copy", YOUNG);
                    this.put("G1 Old Generation", OLD);
                    this.put("G1 Young Generation", YOUNG);
                    this.put("MarkSweepCompact", OLD);
                    this.put("PS MarkSweep", OLD);
                    this.put("PS Scavenge", YOUNG);
                    this.put("ParNew", YOUNG);
                }
            };
        }
    }

    static class CauseAndActionWrapper {
        private String cause;
        private String action;

        public CauseAndActionWrapper(String cause, String action) {
            this.cause = cause;
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CauseAndActionWrapper that = (CauseAndActionWrapper)o;
            return Objects.equals(this.cause, that.cause) && Objects.equals(this.action, that.action);
        }

        public int hashCode() {
            return Objects.hash(this.cause, this.action);
        }
    }
}

