/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.metrics.runtime.GetCountOnlyCounter;
import io.quarkus.smallrye.metrics.runtime.MetadataHolder;
import io.quarkus.smallrye.metrics.runtime.MicrometerGCMetrics;
import io.quarkus.smallrye.metrics.runtime.SmallRyeMetricsHandler;
import io.quarkus.smallrye.metrics.runtime.TagHolder;
import io.smallrye.metrics.ExtendedMetadata;
import io.smallrye.metrics.ExtendedMetadataBuilder;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.TagsUtils;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.elementdesc.MemberInfo;
import io.smallrye.metrics.interceptors.MetricResolver;
import io.smallrye.metrics.setup.MetricsMetadata;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import java.lang.annotation.Annotation;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;

@Recorder
public class SmallRyeMetricsRecorder {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.metrics");
    private static final String THREAD_COUNT = "thread.count";
    private static final String THREAD_DAEMON_COUNT = "thread.daemon.count";
    private static final String THREAD_MAX_COUNT = "thread.max.count";
    private static final String CURRENT_LOADED_CLASS_COUNT = "classloader.loadedClasses.count";
    private static final String TOTAL_LOADED_CLASS_COUNT = "classloader.loadedClasses.total";
    private static final String TOTAL_UNLOADED_CLASS_COUNT = "classloader.unloadedClasses.total";
    private static final String JVM_UPTIME = "jvm.uptime";
    private static final String SYSTEM_LOAD_AVERAGE = "cpu.systemLoadAverage";
    private static final String CPU_AVAILABLE_PROCESSORS = "cpu.availableProcessors";
    private static final String SYSTEM_CPU_LOAD = "cpu.systemCpuLoad";
    private static final String PROCESS_CPU_LOAD = "cpu.processCpuLoad";
    private static final String PROCESS_CPU_TIME = "cpu.processCpuTime";
    private static final String FREE_PHYSICAL_MEM_SIZE = "memory.freePhysicalSize";
    private static final String FREE_SWAP_SIZE = "memory.freeSwapSize";
    private static final String MEMORY_COMMITTED_NON_HEAP = "memory.committedNonHeap";
    private static final String MEMORY_COMMITTED_HEAP = "memory.committedHeap";
    private static final String MEMORY_MAX_HEAP = "memory.maxHeap";
    private static final String MEMORY_MAX_NON_HEAP = "memory.maxNonHeap";
    private static final String MEMORY_USED_HEAP = "memory.usedHeap";
    private static final String MEMORY_USED_NON_HEAP = "memory.usedNonHeap";

    public Function<Router, Route> route(final String name) {
        return new Function<Router, Route>(){

            @Override
            public Route apply(Router router) {
                return router.route(name);
            }
        };
    }

    public SmallRyeMetricsHandler handler(String metricsPath) {
        SmallRyeMetricsHandler handler = new SmallRyeMetricsHandler();
        handler.setMetricsPath(metricsPath);
        return handler;
    }

    public void registerVendorMetrics() {
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
        this.memoryPoolMetrics(registry);
        this.vendorSpecificMemoryMetrics(registry);
        this.vendorOperatingSystemMetrics(registry);
    }

    public void registerBaseMetrics() {
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE);
        this.garbageCollectionMetrics(registry);
        this.classLoadingMetrics(registry);
        this.baseOperatingSystemMetrics(registry);
        this.threadingMetrics(registry);
        this.runtimeMetrics(registry);
        this.baseMemoryMetrics(registry);
    }

    public void registerMicrometerJvmMetrics(ShutdownContext shutdown) {
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE);
        this.micrometerJvmGcMetrics(registry, shutdown);
        this.micrometerJvmThreadMetrics(registry);
        this.micrometerJvmMemoryMetrics(registry);
        this.micrometerJvmClassLoaderMetrics(registry);
        this.micrometerRuntimeMetrics(registry);
    }

    public void registerMetrics(BeanInfo beanInfo, MemberInfo memberInfo) {
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION);
        MetricsMetadata.registerMetrics((MetricRegistry)registry, (MetricResolver)new MetricResolver(), (BeanInfo)beanInfo, (MemberInfo)memberInfo);
    }

    public void registerMetricFromProducer(String beanId, MetricType metricType, String metricName, String[] tags, String description, String displayName, String unit) {
        ArcContainer container = Arc.container();
        InjectableBean injectableBean = container.bean(beanId);
        BeanManager beanManager = container.beanManager();
        Metric reference = (Metric)beanManager.getReference((Bean)injectableBean, Metric.class, beanManager.createCreationalContext((Contextual)injectableBean));
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION);
        Metadata metadata = Metadata.builder().withType(metricType).withName(metricName).withDescription(description).withDisplayName(displayName).withUnit(unit).notReusable().build();
        registry.register(metadata, reference, TagsUtils.parseTagsAsArray((String[])tags));
    }

    public void registerMetric(MetricRegistry.Type scope, MetadataHolder metadataHolder, TagHolder[] tagHolders, Object implementor) {
        Metadata metadata = metadataHolder.toMetadata();
        Tag[] tags = (Tag[])Arrays.stream(tagHolders).map(TagHolder::toTag).toArray(Tag[]::new);
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)scope);
        switch (metadata.getTypeRaw()) {
            case GAUGE: {
                registry.register(metadata, (Metric)((Gauge)implementor), tags);
                break;
            }
            case TIMER: {
                if (implementor == null) {
                    registry.timer(metadata, tags);
                    break;
                }
                registry.register(metadata, (Metric)((Timer)implementor));
                break;
            }
            case COUNTER: {
                if (implementor == null) {
                    registry.counter(metadata, tags);
                    break;
                }
                registry.register(metadata, (Metric)((Counter)implementor), tags);
                break;
            }
            case HISTOGRAM: {
                if (implementor == null) {
                    registry.histogram(metadata, tags);
                    break;
                }
                registry.register(metadata, (Metric)((Histogram)implementor), tags);
                break;
            }
            case CONCURRENT_GAUGE: {
                if (implementor == null) {
                    registry.concurrentGauge(metadata, tags);
                    break;
                }
                registry.register(metadata, (Metric)((ConcurrentGauge)implementor), tags);
                break;
            }
            case METERED: {
                if (implementor == null) {
                    registry.meter(metadata, tags);
                    break;
                }
                registry.register(metadata, (Metric)((Metered)implementor), tags);
                break;
            }
            case INVALID: {
                break;
            }
        }
    }

    public void createRegistries(BeanContainer container) {
        MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION);
        MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE);
        MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
        ((MetricRegistries)container.instance(MetricRegistries.class, new Annotation[0])).getApplicationRegistry();
    }

    public void dropRegistriesAtShutdown(ShutdownContext shutdownContext) {
        shutdownContext.addShutdownTask(MetricRegistries::dropAll);
    }

    private void garbageCollectionMetrics(MetricRegistry registry) {
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        if (gcs.isEmpty()) {
            return;
        }
        Metadata countMetadata = Metadata.builder().withName("gc.total").withType(MetricType.COUNTER).withDisplayName("Garbage Collection Count").withUnit("none").withDescription("Displays the total number of collections that have occurred. This attribute lists -1 if the collection count is undefined for this collector.").build();
        Metadata timeMetadata = Metadata.builder().withName("gc.time").withType(MetricType.COUNTER).withDisplayName("Garbage Collection Time").withUnit("milliseconds").withDescription("Displays the approximate accumulated collection elapsed time in milliseconds. This attribute displays -1 if the collection elapsed time is undefined for this collector. The Java virtual machine implementation may use a high resolution timer to measure the elapsed time. This attribute may display the same value even if the collection count has been incremented if the collection elapsed time is very short.").build();
        for (final GarbageCollectorMXBean gc : gcs) {
            registry.register(countMetadata, (Metric)new GetCountOnlyCounter(){

                @Override
                public long getCount() {
                    return gc.getCollectionCount();
                }
            }, new Tag[]{new Tag("name", gc.getName())});
            registry.register(timeMetadata, (Metric)new GetCountOnlyCounter(){

                @Override
                public long getCount() {
                    return gc.getCollectionTime();
                }
            }, new Tag[]{new Tag("name", gc.getName())});
        }
    }

    private void classLoadingMetrics(MetricRegistry registry) {
        final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        Metadata meta = Metadata.builder().withName(TOTAL_LOADED_CLASS_COUNT).withType(MetricType.COUNTER).withDisplayName("Total Loaded Class Count").withDescription("Displays the total number of classes that have been loaded since the Java virtual machine has started execution.").build();
        registry.register(meta, (Metric)new GetCountOnlyCounter(){

            @Override
            public long getCount() {
                return classLoadingMXBean.getTotalLoadedClassCount();
            }
        });
        meta = Metadata.builder().withName(TOTAL_UNLOADED_CLASS_COUNT).withType(MetricType.COUNTER).withDisplayName("Total Unloaded Class Count").withDescription("Displays the total number of classes unloaded since the Java virtual machine has started execution.").build();
        registry.register(meta, (Metric)new GetCountOnlyCounter(){

            @Override
            public long getCount() {
                return classLoadingMXBean.getUnloadedClassCount();
            }
        });
        meta = Metadata.builder().withName(CURRENT_LOADED_CLASS_COUNT).withType(MetricType.GAUGE).withDisplayName("Current Loaded Class Count").withDescription("Displays the number of classes that are currently loaded in the Java virtual machine.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return classLoadingMXBean.getLoadedClassCount();
            }
        });
    }

    private void baseOperatingSystemMetrics(MetricRegistry registry) {
        final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        Metadata meta = Metadata.builder().withName(SYSTEM_LOAD_AVERAGE).withType(MetricType.GAUGE).withDisplayName("System Load Average").withDescription("Displays the system load average for the last minute. The system load average is the sum of the number of runnable entities queued to the available processors and the number of runnable entities running on the available processors averaged over a period of time. The way in which the load average is calculated is operating system specific but is typically a damped time-dependent average. If the load average is not available, a negative value is displayed. This attribute is designed to provide a hint about the system load and may be queried frequently. The load average may be unavailable on some platforms where it is expensive to implement this method.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return operatingSystemMXBean.getSystemLoadAverage();
            }
        });
        meta = Metadata.builder().withName(CPU_AVAILABLE_PROCESSORS).withType(MetricType.GAUGE).withDisplayName("Available Processors").withDescription("Displays the number of processors available to the Java virtual machine. This value may change during a particular invocation of the virtual machine.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return operatingSystemMXBean.getAvailableProcessors();
            }
        });
        if (!ImageInfo.inImageCode() && com.sun.management.OperatingSystemMXBean.class.isAssignableFrom(operatingSystemMXBean.getClass())) {
            try {
                final com.sun.management.OperatingSystemMXBean internalOperatingSystemMXBean = (com.sun.management.OperatingSystemMXBean)operatingSystemMXBean;
                meta = Metadata.builder().withName(PROCESS_CPU_LOAD).withType(MetricType.GAUGE).withUnit("percent").withDisplayName("Process CPU load").withDescription("Displays  the \"recent cpu usage\" for the Java Virtual Machine process. This value is a double in the [0.0,1.0] interval. A value of 0.0 means that none of the CPUs were running threads from the JVM process during the recent period of time observed, while a value of 1.0 means that all CPUs were actively running threads from the JVM 100% of the time during the recent period being observed. Threads from the JVM include the application threads as well as the JVM internal threads. All values betweens 0.0 and 1.0 are possible depending of the activities going on in the JVM process and the whole system. If the Java Virtual Machine recent CPU usage is not available, the method returns a negative value.").build();
                registry.register(meta, (Metric)new Gauge(){

                    public Number getValue() {
                        return internalOperatingSystemMXBean.getProcessCpuLoad();
                    }
                });
            }
            catch (ClassCastException cce) {
                log.debug((Object)"Unable to cast the OperatingSystemMXBean to com.sun.management.OperatingSystemMXBean, not registering extended operating system metrics", (Throwable)cce);
            }
        }
    }

    private void vendorOperatingSystemMetrics(MetricRegistry registry) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (!ImageInfo.inImageCode() && com.sun.management.OperatingSystemMXBean.class.isAssignableFrom(operatingSystemMXBean.getClass())) {
            try {
                final com.sun.management.OperatingSystemMXBean internalOperatingSystemMXBean = (com.sun.management.OperatingSystemMXBean)operatingSystemMXBean;
                Metadata meta = Metadata.builder().withName(SYSTEM_CPU_LOAD).withType(MetricType.GAUGE).withUnit("percent").withDisplayName("System CPU load").withDescription("Displays the \"recent cpu usage\" for the whole system. This value is a double in the [0.0,1.0] interval. A value of 0.0 means that all CPUs were idle during the recent period of time observed, while a value of 1.0 means that all CPUs were actively running 100% of the time during the recent period being observed. All values betweens 0.0 and 1.0 are possible depending of the activities going on in the system. If the system recent cpu usage is not available, the method returns a negative value.").build();
                registry.register(meta, (Metric)new Gauge(){

                    public Number getValue() {
                        return internalOperatingSystemMXBean.getSystemCpuLoad();
                    }
                });
                meta = Metadata.builder().withName(PROCESS_CPU_TIME).withType(MetricType.GAUGE).withUnit("nanoseconds").withDisplayName("Process CPU time").withDescription("Displays the CPU time used by the process on which the Java virtual machine is running in nanoseconds. The returned value is of nanoseconds precision but not necessarily nanoseconds accuracy. This method returns -1 if the the platform does not support this operation.").build();
                registry.register(meta, (Metric)new Gauge(){

                    public Number getValue() {
                        return internalOperatingSystemMXBean.getProcessCpuTime();
                    }
                });
                meta = Metadata.builder().withName(FREE_PHYSICAL_MEM_SIZE).withType(MetricType.GAUGE).withUnit("bytes").withDisplayName("Free physical memory size").withDescription("Displays the amount of free physical memory in bytes.").build();
                registry.register(meta, (Metric)new Gauge(){

                    public Number getValue() {
                        return internalOperatingSystemMXBean.getFreePhysicalMemorySize();
                    }
                });
                meta = Metadata.builder().withName(FREE_SWAP_SIZE).withType(MetricType.GAUGE).withUnit("bytes").withDisplayName("Free swap size").withDescription("Displays the amount of free swap space in bytes.").build();
                registry.register(meta, (Metric)new Gauge(){

                    public Number getValue() {
                        return internalOperatingSystemMXBean.getFreeSwapSpaceSize();
                    }
                });
            }
            catch (ClassCastException cce) {
                log.debug((Object)"Unable to cast the OperatingSystemMXBean to com.sun.management.OperatingSystemMXBean, not registering extended operating system metrics", (Throwable)cce);
            }
        }
    }

    private void threadingMetrics(MetricRegistry registry) {
        final ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        Metadata meta = Metadata.builder().withName(THREAD_COUNT).withType(MetricType.GAUGE).withDisplayName("Thread Count").withDescription("Displays the current number of live threads including both daemon and non-daemon threads").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return thread.getThreadCount();
            }
        });
        meta = Metadata.builder().withName(THREAD_DAEMON_COUNT).withType(MetricType.GAUGE).withDisplayName("Daemon Thread Count").withDescription("Displays the current number of live daemon threads.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return thread.getDaemonThreadCount();
            }
        });
        meta = Metadata.builder().withName(THREAD_MAX_COUNT).withType(MetricType.GAUGE).withDisplayName("Peak Thread Count").withDescription("Displays the peak live thread count since the Java virtual machine started or peak was reset. This includes daemon and non-daemon threads.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return thread.getPeakThreadCount();
            }
        });
    }

    private void runtimeMetrics(MetricRegistry registry) {
        final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Metadata meta = Metadata.builder().withName(JVM_UPTIME).withType(MetricType.GAUGE).withUnit("milliseconds").withDisplayName("JVM Uptime").withDescription("Displays the time from the start of the Java virtual machine in milliseconds.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return runtimeMXBean.getUptime();
            }
        });
    }

    private void baseMemoryMetrics(MetricRegistry registry) {
        final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        Metadata meta = Metadata.builder().withName(MEMORY_COMMITTED_HEAP).withType(MetricType.GAUGE).withUnit("bytes").withDisplayName("Committed Heap Memory").withDescription("Displays the amount of memory in bytes that is committed for the Java virtual machine to use. This amount of memory is guaranteed for the Java virtual machine to use.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return memoryMXBean.getHeapMemoryUsage().getCommitted();
            }
        });
        meta = Metadata.builder().withName(MEMORY_MAX_HEAP).withType(MetricType.GAUGE).withUnit("bytes").withDisplayName("Max Heap Memory").withDescription("Displays the maximum amount of heap memory in bytes that can be used for memory management. This attribute displays -1 if the maximum heap memory size is undefined. This amount of memory is not guaranteed to be available for memory management if it is greater than the amount of committed memory. The Java virtual machine may fail to allocate memory even if the amount of used memory does not exceed this maximum size.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return memoryMXBean.getHeapMemoryUsage().getMax();
            }
        });
        meta = Metadata.builder().withName(MEMORY_USED_HEAP).withType(MetricType.GAUGE).withUnit("bytes").withDisplayName("Used Heap Memory").withDescription("Displays the amount of used heap memory in bytes.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return memoryMXBean.getHeapMemoryUsage().getUsed();
            }
        });
    }

    private void vendorSpecificMemoryMetrics(MetricRegistry registry) {
        final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        Metadata meta = Metadata.builder().withName(MEMORY_COMMITTED_NON_HEAP).withType(MetricType.GAUGE).withUnit("bytes").withDisplayName("Committed Non Heap Memory").withDescription("Displays the amount of non heap memory in bytes that is committed for the Java virtual machine to use.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return memoryMXBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        meta = Metadata.builder().withName(MEMORY_MAX_NON_HEAP).withType(MetricType.GAUGE).withUnit("bytes").withDisplayName("Max Non Heap Memory").withDescription("Displays the maximum amount of used non-heap memory in bytes.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return memoryMXBean.getNonHeapMemoryUsage().getMax();
            }
        });
        meta = Metadata.builder().withName(MEMORY_USED_NON_HEAP).withType(MetricType.GAUGE).withUnit("bytes").withDisplayName("Used Non Heap Memory").withDescription("Displays the amount of used non-heap memory in bytes.").build();
        registry.register(meta, (Metric)new Gauge(){

            public Number getValue() {
                return memoryMXBean.getNonHeapMemoryUsage().getUsed();
            }
        });
    }

    private void memoryPoolMetrics(MetricRegistry registry) {
        if (!ImageInfo.inImageCode()) {
            List<MemoryPoolMXBean> mps = ManagementFactory.getMemoryPoolMXBeans();
            Metadata usageMetadata = Metadata.builder().withName("memoryPool.usage").withType(MetricType.GAUGE).withDisplayName("Current usage of the memory pool denoted by the 'name' tag").withDescription("Current usage of the memory pool denoted by the 'name' tag").withUnit("bytes").build();
            Metadata maxMetadata = Metadata.builder().withName("memoryPool.usage.max").withType(MetricType.GAUGE).withDisplayName("Peak usage of the memory pool denoted by the 'name' tag").withDescription("Peak usage of the memory pool denoted by the 'name' tag").withUnit("bytes").build();
            for (final MemoryPoolMXBean mp : mps) {
                if (mp.getCollectionUsage() != null && mp.getPeakUsage() != null) {
                    registry.register(usageMetadata, (Metric)new Gauge(){

                        public Number getValue() {
                            return mp.getCollectionUsage().getUsed();
                        }
                    }, new Tag[]{new Tag("name", mp.getName())});
                    registry.register(maxMetadata, (Metric)new Gauge(){

                        public Number getValue() {
                            return mp.getPeakUsage().getUsed();
                        }
                    }, new Tag[]{new Tag("name", mp.getName())});
                    continue;
                }
                if (mp.getUsage() == null || mp.getPeakUsage() == null) continue;
                registry.register(usageMetadata, (Metric)new Gauge(){

                    public Number getValue() {
                        return mp.getUsage().getUsed();
                    }
                }, new Tag[]{new Tag("name", mp.getName())});
                registry.register(maxMetadata, (Metric)new Gauge(){

                    public Number getValue() {
                        return mp.getPeakUsage().getUsed();
                    }
                }, new Tag[]{new Tag("name", mp.getName())});
            }
        }
    }

    private void micrometerJvmGcMetrics(MetricRegistry registry, ShutdownContext shutdownContext) {
        if (!ImageInfo.inImageCode()) {
            final MicrometerGCMetrics gcMetrics = new MicrometerGCMetrics();
            registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.gc.max.data.size").withType(MetricType.GAUGE).withUnit("bytes").withDescription("Max size of old generation memory pool").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

                public Number getValue() {
                    return gcMetrics.getMaxDataSize();
                }
            });
            registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.gc.live.data.size").withType(MetricType.GAUGE).withUnit("bytes").withDescription("Size of old generation memory pool after a full GC").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

                public Number getValue() {
                    return gcMetrics.getLiveDataSize();
                }
            });
            registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.gc.memory.promoted").withType(MetricType.COUNTER).withUnit("bytes").withDescription("Count of positive increases in the size of the old generation memory pool before GC to after GC").skipsScopeInOpenMetricsExportCompletely(true).withOpenMetricsKeyOverride("jvm_gc_memory_promoted_bytes_total").build(), (Metric)new GetCountOnlyCounter(){

                @Override
                public long getCount() {
                    return gcMetrics.getPromotedBytes();
                }
            });
            registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.gc.memory.allocated").withType(MetricType.COUNTER).withUnit("bytes").withDescription("Incremented for an increase in the size of the young generation memory pool after one GC to before the next").skipsScopeInOpenMetricsExportCompletely(true).withOpenMetricsKeyOverride("jvm_gc_memory_allocated_bytes_total").build(), (Metric)new GetCountOnlyCounter(){

                @Override
                public long getCount() {
                    return gcMetrics.getAllocatedBytes();
                }
            });
            gcMetrics.startWatchingNotifications();
            shutdownContext.addShutdownTask(gcMetrics::cleanUp);
        }
    }

    private void micrometerRuntimeMetrics(MetricRegistry registry) {
        final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        registry.register((Metadata)new ExtendedMetadataBuilder().withName("process.runtime").withType(MetricType.GAUGE).withUnit("milliseconds").withDescription("The uptime of the Java virtual machine").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

            public Number getValue() {
                return runtimeMXBean.getUptime();
            }
        });
        registry.register((Metadata)new ExtendedMetadataBuilder().withName("process.start.time").withType(MetricType.GAUGE).withUnit("milliseconds").withDescription("Start time of the process since unix epoch.").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

            public Number getValue() {
                return runtimeMXBean.getStartTime();
            }
        });
    }

    private void micrometerJvmThreadMetrics(MetricRegistry registry) {
        final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.threads.peak").withType(MetricType.GAUGE).withUnit("threads").withDescription("The peak live thread count since the Java virtual machine started or peak was reset").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

            public Number getValue() {
                return threadBean.getPeakThreadCount();
            }
        });
        registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.threads.daemon").withType(MetricType.GAUGE).withUnit("threads").withDescription("The current number of live daemon threads").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

            public Number getValue() {
                return threadBean.getDaemonThreadCount();
            }
        });
        registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.threads.live").withType(MetricType.GAUGE).withUnit("threads").withDescription("The current number of live threads including both daemon and non-daemon threads").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

            public Number getValue() {
                return threadBean.getThreadCount();
            }
        });
        if (!ImageInfo.inImageCode()) {
            ExtendedMetadata threadStatesMetadata = new ExtendedMetadataBuilder().withName("jvm.threads.states").withType(MetricType.GAUGE).withUnit("threads").withDescription("The current number of threads having a particular state").skipsScopeInOpenMetricsExportCompletely(true).build();
            for (final Thread.State state : Thread.State.values()) {
                registry.register((Metadata)threadStatesMetadata, (Metric)new Gauge(){

                    public Number getValue() {
                        return SmallRyeMetricsRecorder.this.getThreadStateCount(threadBean, state);
                    }
                }, new Tag[]{new Tag("state", state.name().toLowerCase().replace("_", "-"))});
            }
        }
    }

    private void micrometerJvmMemoryMetrics(MetricRegistry registry) {
        if (!ImageInfo.inImageCode()) {
            for (final MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
                String area = MemoryType.HEAP.equals((Object)memoryPoolMXBean.getType()) ? "heap" : "nonheap";
                Tag[] tags = new Tag[]{new Tag("id", memoryPoolMXBean.getName()), new Tag("area", area)};
                registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.memory.used").withType(MetricType.GAUGE).withUnit("bytes").withDescription("The amount of used memory").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

                    public Number getValue() {
                        return memoryPoolMXBean.getUsage().getUsed();
                    }
                }, tags);
                registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.memory.committed").withType(MetricType.GAUGE).withUnit("bytes").withDescription("The amount of memory in bytes that is committed for the Java virtual machine to use").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

                    public Number getValue() {
                        return memoryPoolMXBean.getUsage().getCommitted();
                    }
                }, tags);
                registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.memory.max").withType(MetricType.GAUGE).withUnit("bytes").withDescription("The maximum amount of memory in bytes that can be used for memory management").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

                    public Number getValue() {
                        return memoryPoolMXBean.getUsage().getMax();
                    }
                }, tags);
            }
            for (final BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
                Tag tag = new Tag("id", bufferPoolBean.getName());
                registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.buffer.count").withType(MetricType.GAUGE).withUnit("buffers").withDescription("An estimate of the number of buffers in the pool").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

                    public Number getValue() {
                        return bufferPoolBean.getCount();
                    }
                }, new Tag[]{tag});
                registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.buffer.memory.used").withType(MetricType.GAUGE).withUnit("bytes").withDescription("An estimate of the memory that the Java virtual machine is using for this buffer pool").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

                    public Number getValue() {
                        return bufferPoolBean.getMemoryUsed();
                    }
                }, new Tag[]{tag});
                registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.buffer.total.capacity").withType(MetricType.GAUGE).withUnit("bytes").withDescription("An estimate of the total capacity of the buffers in this pool").skipsScopeInOpenMetricsExportCompletely(true).build(), (Metric)new Gauge(){

                    public Number getValue() {
                        return bufferPoolBean.getTotalCapacity();
                    }
                }, new Tag[]{tag});
            }
        }
    }

    private void micrometerJvmClassLoaderMetrics(MetricRegistry registry) {
        if (!ImageInfo.inImageCode()) {
            final ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
            registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.classes.loaded").withType(MetricType.GAUGE).withUnit("classes").withDescription("The number of classes that are currently loaded in the Java virtual machine").withOpenMetricsKeyOverride("jvm_classes_loaded_classes").build(), (Metric)new Gauge(){

                public Number getValue() {
                    return classLoadingBean.getLoadedClassCount();
                }
            });
            registry.register((Metadata)new ExtendedMetadataBuilder().withName("jvm.classes.unloaded").withType(MetricType.COUNTER).withUnit("classes").withDescription("The total number of classes unloaded since the Java virtual machine has started execution").withOpenMetricsKeyOverride("jvm_classes_unloaded_classes_total").build(), (Metric)new GetCountOnlyCounter(){

                @Override
                public long getCount() {
                    return classLoadingBean.getUnloadedClassCount();
                }
            });
        }
    }

    private long getThreadStateCount(ThreadMXBean threadBean, Thread.State state) {
        int count = 0;
        for (ThreadInfo threadInfo : threadBean.getThreadInfo(threadBean.getAllThreadIds())) {
            if (threadInfo == null || threadInfo.getThreadState() != state) continue;
            ++count;
        }
        return count;
    }
}

