/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import io.smallrye.metrics.MetricRegistries;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

final class FilterUtil {
    private FilterUtil() {
    }

    static void finishRequest(Long start, Class<?> resourceClass, String methodName, Class<?>[] parameterTypes, Supplier<Boolean> wasSuccessful) {
        long value = System.nanoTime() - start;
        boolean success = wasSuccessful.get();
        MetricID metricID = FilterUtil.getMetricID(resourceClass, methodName, parameterTypes, success);
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE);
        if (success) {
            registry.simpleTimer(metricID).update(Duration.ofNanos(value));
        } else {
            registry.counter(metricID).inc();
        }
    }

    static void maybeCreateMetrics(Class<?> resourceClass, Method resourceMethod) {
        MetricID failure;
        MetricID success;
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE);
        if (registry.getSimpleTimer(success = FilterUtil.getMetricID(resourceClass, resourceMethod.getName(), resourceMethod.getParameterTypes(), true)) == null) {
            Metadata successMetadata = Metadata.builder().withName(success.getName()).withDescription("The number of invocations and total response time of this RESTful resource method since the start of the server.").withUnit("nanoseconds").build();
            registry.simpleTimer(successMetadata, success.getTagsAsArray());
        }
        if (registry.getCounter(failure = FilterUtil.getMetricID(resourceClass, resourceMethod.getName(), resourceMethod.getParameterTypes(), false)) == null) {
            Metadata failureMetadata = Metadata.builder().withName(failure.getName()).withDisplayName("Total Unmapped Exceptions count").withDescription("The total number of unmapped exceptions that occurred from this RESTful resource method since the start of the server.").build();
            registry.counter(failureMetadata, failure.getTagsAsArray());
        }
    }

    static MetricID getMetricID(Class<?> resourceClass, String methodName, Class<?>[] parameterTypes, boolean requestWasSuccessful) {
        Tag classTag = new Tag("class", resourceClass.getName());
        StringBuilder sb = new StringBuilder();
        for (Class<?> parameterType : parameterTypes) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            if (parameterType.isArray()) {
                sb.append(parameterType.getComponentType().getName()).append("[]");
                continue;
            }
            sb.append(parameterType.getName());
        }
        String encodedParameterNames = sb.toString();
        String methodTagValue = encodedParameterNames.isEmpty() ? methodName : methodName + "_" + encodedParameterNames;
        Tag methodTag = new Tag("method", methodTagValue);
        String name = requestWasSuccessful ? "REST.request" : "REST.request.unmappedException.total";
        return new MetricID(name, new Tag[]{classTag, methodTag});
    }
}

