/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment;

import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.resteasy.deployment.ResteasyJaxrsConfigBuildItem;
import io.smallrye.openapi.runtime.scanner.DefaultAnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class RESTEasyExtension
extends DefaultAnnotationScannerExtension {
    public static final DotName DOTNAME_QUERY_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.QueryParam");
    public static final DotName DOTNAME_FORM_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.FormParam");
    public static final DotName DOTNAME_COOKIE_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.CookieParam");
    public static final DotName DOTNAME_PATH_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.PathParam");
    public static final DotName DOTNAME_HEADER_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.HeaderParam");
    public static final DotName DOTNAME_MATRIX_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.MatrixParam");
    private static final DotName DOTNAME_PROVIDER = DotName.createSimple((String)"javax.ws.rs.ext.Provider");
    private static final DotName DOTNAME_ASYNC_RESPONSE_PROVIDER = DotName.createSimple((String)"org.jboss.resteasy.spi.AsyncResponseProvider");
    private List<DotName> asyncTypes = new ArrayList<DotName>();
    private String defaultPath;

    public RESTEasyExtension(ResteasyJaxrsConfigBuildItem jaxrsConfig, IndexView index) {
        this.defaultPath = jaxrsConfig.defaultPath;
        this.scanAsyncResponseProvidersFromServices();
        this.scanAsyncResponseProviders(index);
    }

    private void scanAsyncResponseProvidersFromServices() {
        try {
            Class<?> asyncResponseProvider = Class.forName("org.jboss.resteasy.spi.AsyncResponseProvider");
            for (String provider : ServiceUtil.classNamesNamedIn((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"META-INF/services/javax.ws.rs.ext.Providers")) {
                this.scanAsyncResponseProvidersFromClassName(asyncResponseProvider, provider);
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void scanAsyncResponseProvidersFromClassName(Class<?> asyncResponseProviderClass, String name) {
        try {
            Class<?> klass = Class.forName(name);
            if (asyncResponseProviderClass.isAssignableFrom(klass)) {
                for (Type type : klass.getGenericInterfaces()) {
                    ParameterizedType pType;
                    if (!(type instanceof ParameterizedType) || !(pType = (ParameterizedType)type).getRawType().equals(asyncResponseProviderClass) || pType.getActualTypeArguments().length != 1) continue;
                    Type asyncType = pType.getActualTypeArguments()[0];
                    String asyncTypeName = asyncType instanceof ParameterizedType ? ((ParameterizedType)asyncType).getRawType().getTypeName() : asyncType.getTypeName();
                    this.asyncTypes.add(DotName.createSimple((String)asyncTypeName));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void scanAsyncResponseProviders(IndexView index) {
        for (ClassInfo providerClass : index.getAllKnownImplementors(DOTNAME_ASYNC_RESPONSE_PROVIDER)) {
            for (AnnotationInstance annotation : providerClass.classAnnotations()) {
                if (!annotation.name().equals((Object)DOTNAME_PROVIDER)) continue;
                for (org.jboss.jandex.Type interf : providerClass.interfaceTypes()) {
                    org.jboss.jandex.ParameterizedType pType;
                    if (interf.kind() != Type.Kind.PARAMETERIZED_TYPE || !interf.name().equals((Object)DOTNAME_ASYNC_RESPONSE_PROVIDER) || (pType = interf.asParameterizedType()).arguments().size() != 1) continue;
                    org.jboss.jandex.Type asyncType = (org.jboss.jandex.Type)pType.arguments().get(0);
                    this.asyncTypes.add(asyncType.name());
                }
            }
        }
    }

    public JandexUtil.JaxRsParameterInfo getMethodParameterJaxRsInfo(MethodInfo method, int idx) {
        AnnotationInstance jaxRsAnno = JandexUtil.getMethodParameterAnnotation((MethodInfo)method, (int)idx, (DotName)DOTNAME_PATH_PARAM);
        if (jaxRsAnno != null) {
            JandexUtil.JaxRsParameterInfo info = new JandexUtil.JaxRsParameterInfo();
            info.in = Parameter.In.PATH;
            info.name = JandexUtil.stringValue((AnnotationInstance)jaxRsAnno, (String)"value");
            if (info.name == null) {
                info.name = method.parameterName(idx);
            }
            return info;
        }
        jaxRsAnno = JandexUtil.getMethodParameterAnnotation((MethodInfo)method, (int)idx, (DotName)DOTNAME_QUERY_PARAM);
        if (jaxRsAnno != null) {
            JandexUtil.JaxRsParameterInfo info = new JandexUtil.JaxRsParameterInfo();
            info.in = Parameter.In.QUERY;
            info.name = JandexUtil.stringValue((AnnotationInstance)jaxRsAnno, (String)"value");
            if (info.name == null) {
                info.name = method.parameterName(idx);
            }
            return info;
        }
        jaxRsAnno = JandexUtil.getMethodParameterAnnotation((MethodInfo)method, (int)idx, (DotName)DOTNAME_COOKIE_PARAM);
        if (jaxRsAnno != null) {
            JandexUtil.JaxRsParameterInfo info = new JandexUtil.JaxRsParameterInfo();
            info.in = Parameter.In.COOKIE;
            info.name = JandexUtil.stringValue((AnnotationInstance)jaxRsAnno, (String)"value");
            if (info.name == null) {
                info.name = method.parameterName(idx);
            }
            return info;
        }
        jaxRsAnno = JandexUtil.getMethodParameterAnnotation((MethodInfo)method, (int)idx, (DotName)DOTNAME_HEADER_PARAM);
        if (jaxRsAnno != null) {
            JandexUtil.JaxRsParameterInfo info = new JandexUtil.JaxRsParameterInfo();
            info.in = Parameter.In.HEADER;
            info.name = JandexUtil.stringValue((AnnotationInstance)jaxRsAnno, (String)"value");
            if (info.name == null) {
                info.name = method.parameterName(idx);
            }
            return info;
        }
        return null;
    }

    public Parameter.In parameterIn(MethodParameterInfo paramInfo) {
        MethodInfo method = paramInfo.method();
        short paramPosition = paramInfo.position();
        List annotations = JandexUtil.getParameterAnnotations((MethodInfo)method, (short)paramPosition);
        for (AnnotationInstance annotation : annotations) {
            if (annotation.name().equals((Object)DOTNAME_QUERY_PARAM)) {
                return Parameter.In.QUERY;
            }
            if (annotation.name().equals((Object)DOTNAME_PATH_PARAM)) {
                return Parameter.In.PATH;
            }
            if (annotation.name().equals((Object)DOTNAME_HEADER_PARAM)) {
                return Parameter.In.HEADER;
            }
            if (!annotation.name().equals((Object)DOTNAME_COOKIE_PARAM)) continue;
            return Parameter.In.COOKIE;
        }
        return null;
    }

    public org.jboss.jandex.Type resolveAsyncType(org.jboss.jandex.Type type) {
        org.jboss.jandex.ParameterizedType pType;
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && this.asyncTypes.contains(type.name()) && (pType = type.asParameterizedType()).arguments().size() == 1) {
            return (org.jboss.jandex.Type)pType.arguments().get(0);
        }
        return super.resolveAsyncType(type);
    }

    public void processJaxRsApplications(OpenApiAnnotationScanner scanner, Collection<ClassInfo> applications) {
        if (applications.isEmpty()) {
            scanner.setCurrentAppPath(this.defaultPath);
        }
    }
}

