/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.resteasy.deployment.ResteasyJaxrsConfigBuildItem;
import io.quarkus.smallrye.openapi.common.deployment.SmallRyeOpenApiConfig;
import io.quarkus.smallrye.openapi.deployment.OpenApiFilteredIndexViewBuildItem;
import io.quarkus.smallrye.openapi.deployment.RESTEasyExtension;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentProducer;
import io.quarkus.smallrye.openapi.runtime.OpenApiServlet;
import io.quarkus.undertow.deployment.GeneratedWebResourceBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.Type;

public class SmallRyeOpenApiProcessor {
    private static final String META_INF_OPENAPI_YAML = "META-INF/openapi.yaml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YAML = "WEB-INF/classes/META-INF/openapi.yaml";
    private static final String META_INF_OPENAPI_YML = "META-INF/openapi.yml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YML = "WEB-INF/classes/META-INF/openapi.yml";
    private static final String META_INF_OPENAPI_JSON = "META-INF/openapi.json";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_JSON = "WEB-INF/classes/META-INF/openapi.json";
    private static final DotName OPENAPI_SCHEMA = DotName.createSimple((String)Schema.class.getName());
    private static final DotName OPENAPI_RESPONSE = DotName.createSimple((String)APIResponse.class.getName());
    private static final DotName OPENAPI_RESPONSES = DotName.createSimple((String)APIResponses.class.getName());
    private static final String OPENAPI_RESPONSE_CONTENT = "content";
    private static final String OPENAPI_RESPONSE_SCHEMA = "schema";
    private static final String OPENAPI_SCHEMA_NOT = "not";
    private static final String OPENAPI_SCHEMA_ONE_OF = "oneOf";
    private static final String OPENAPI_SCHEMA_ANY_OF = "anyOf";
    private static final String OPENAPI_SCHEMA_ALL_OF = "allOf";
    private static final String OPENAPI_SCHEMA_IMPLEMENTATION = "implementation";
    SmallRyeOpenApiConfig openapi;

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> configFiles() {
        return Stream.of(META_INF_OPENAPI_YAML, WEB_INF_CLASSES_META_INF_OPENAPI_YAML, META_INF_OPENAPI_YML, WEB_INF_CLASSES_META_INF_OPENAPI_YML, META_INF_OPENAPI_JSON, WEB_INF_CLASSES_META_INF_OPENAPI_JSON).map(HotDeploymentWatchedFileBuildItem::new).collect(Collectors.toList());
    }

    @BuildStep
    ServletBuildItem servlet() {
        return ServletBuildItem.builder((String)"openapi", (String)OpenApiServlet.class.getName()).addMapping(this.openapi.path).build();
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return new AdditionalBeanBuildItem(new Class[]{OpenApiServlet.class, OpenApiDocumentProducer.class});
    }

    @BuildStep
    OpenApiFilteredIndexViewBuildItem smallryeOpenApiIndex(CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem) {
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{combinedIndexBuildItem.getIndex(), beanArchiveIndexBuildItem.getIndex()});
        return new OpenApiFilteredIndexViewBuildItem(new FilteredIndexView((IndexView)compositeIndex, (OpenApiConfig)new OpenApiConfigImpl(ConfigProvider.getConfig())));
    }

    @BuildStep
    public void registerOpenApiSchemaClassesForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, OpenApiFilteredIndexViewBuildItem openApiFilteredIndexViewBuildItem) {
        FilteredIndexView index = openApiFilteredIndexViewBuildItem.getIndex();
        Collection schemaAnnotationInstances = index.getAnnotations(OPENAPI_SCHEMA);
        for (AnnotationInstance schemaAnnotationInstance : schemaAnnotationInstances) {
            AnnotationTarget typeTarget = schemaAnnotationInstance.target();
            if (typeTarget.kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(Type.create((DotName)typeTarget.asClass().name(), (Type.Kind)Type.Kind.CLASS)));
        }
        Collection apiResponseAnnotationInstances = index.getAnnotations(OPENAPI_RESPONSE);
        this.registerReflectionForApiResponseSchemaSerialization(reflectiveClass, reflectiveHierarchy, apiResponseAnnotationInstances);
        Collection apiResponsesAnnotationInstances = index.getAnnotations(OPENAPI_RESPONSES);
        for (AnnotationInstance apiResponsesAnnotationInstance : apiResponsesAnnotationInstances) {
            AnnotationValue apiResponsesAnnotationValue = apiResponsesAnnotationInstance.value();
            if (apiResponsesAnnotationValue == null) continue;
            this.registerReflectionForApiResponseSchemaSerialization(reflectiveClass, reflectiveHierarchy, Arrays.asList(apiResponsesAnnotationValue.asNestedArray()));
        }
    }

    private void registerReflectionForApiResponseSchemaSerialization(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, Collection<AnnotationInstance> apiResponseAnnotationInstances) {
        for (AnnotationInstance apiResponseAnnotationInstance : apiResponseAnnotationInstances) {
            AnnotationInstance[] contents;
            AnnotationValue contentAnnotationValue = apiResponseAnnotationInstance.value(OPENAPI_RESPONSE_CONTENT);
            if (contentAnnotationValue == null) continue;
            for (AnnotationInstance content : contents = contentAnnotationValue.asNestedArray()) {
                AnnotationValue schemaAllOfClasses;
                AnnotationValue schemaAnyOfClasses;
                AnnotationValue schemaOneOfClasses;
                AnnotationValue schemaNotClass;
                AnnotationValue annotationValue = content.value(OPENAPI_RESPONSE_SCHEMA);
                if (annotationValue == null) continue;
                AnnotationInstance schema = annotationValue.asNested();
                AnnotationValue schemaImplementationClass = schema.value(OPENAPI_SCHEMA_IMPLEMENTATION);
                if (schemaImplementationClass != null) {
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(schemaImplementationClass.asClass()));
                }
                if ((schemaNotClass = schema.value(OPENAPI_SCHEMA_NOT)) != null) {
                    reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{schemaNotClass.asString()}));
                }
                if ((schemaOneOfClasses = schema.value(OPENAPI_SCHEMA_ONE_OF)) != null) {
                    for (Type schemaOneOfClass : schemaOneOfClasses.asClassArray()) {
                        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(schemaOneOfClass));
                    }
                }
                if ((schemaAnyOfClasses = schema.value(OPENAPI_SCHEMA_ANY_OF)) != null) {
                    for (Type schemaAnyOfClass : schemaAnyOfClasses.asClassArray()) {
                        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(schemaAnyOfClass));
                    }
                }
                if ((schemaAllOfClasses = schema.value(OPENAPI_SCHEMA_ALL_OF)) == null) continue;
                for (Type schemaAllOfClass : schemaAllOfClasses.asClassArray()) {
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(schemaAllOfClass));
                }
            }
        }
    }

    @BuildStep
    public void build(ApplicationArchivesBuildItem archivesBuildItem, BuildProducer<FeatureBuildItem> feature, Optional<ResteasyJaxrsConfigBuildItem> resteasyJaxrsConfig, BuildProducer<GeneratedWebResourceBuildItem> resourceBuildItemBuildProducer, OpenApiFilteredIndexViewBuildItem openApiFilteredIndexViewBuildItem) throws Exception {
        FilteredIndexView index = openApiFilteredIndexViewBuildItem.getIndex();
        feature.produce((BuildItem)new FeatureBuildItem("smallrye-openapi"));
        OpenAPI staticModel = this.generateStaticModel(archivesBuildItem);
        Config config = ConfigProvider.getConfig();
        boolean scanDisable = config.getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
        OpenAPI annotationModel = resteasyJaxrsConfig.isPresent() && !scanDisable ? this.generateAnnotationModel((IndexView)index, resteasyJaxrsConfig.get()) : null;
        OpenApiDocument finalDocument = this.loadDocument(staticModel, annotationModel);
        for (OpenApiSerializer.Format format : OpenApiSerializer.Format.values()) {
            String name = "quarkus-generated-openapi-doc." + format;
            resourceBuildItemBuildProducer.produce((BuildItem)new GeneratedWebResourceBuildItem(name, OpenApiSerializer.serialize((OpenAPI)finalDocument.get(), (OpenApiSerializer.Format)format).getBytes(StandardCharsets.UTF_8)));
        }
    }

    @BuildStep
    LogCleanupFilterBuildItem logCleanup() {
        return new LogCleanupFilterBuildItem("io.smallrye.openapi.api.OpenApiDocument", new String[]{"OpenAPI document initialized:"});
    }

    /*
     * Exception decompiling
     */
    private OpenAPI generateStaticModel(ApplicationArchivesBuildItem archivesBuildItem) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OpenAPI generateAnnotationModel(IndexView indexView, ResteasyJaxrsConfigBuildItem jaxrsConfig) {
        Indexer indexer = new Indexer();
        HashSet additionalIndex = new HashSet();
        IndexingUtil.indexClass((String)Collection.class.getName(), (Indexer)indexer, (IndexView)indexView, additionalIndex, (ClassLoader)SmallRyeOpenApiProcessor.class.getClassLoader());
        IndexingUtil.indexClass((String)Map.class.getName(), (Indexer)indexer, (IndexView)indexView, additionalIndex, (ClassLoader)SmallRyeOpenApiProcessor.class.getClassLoader());
        IndexingUtil.indexClass((String)Object.class.getName(), (Indexer)indexer, (IndexView)indexView, additionalIndex, (ClassLoader)SmallRyeOpenApiProcessor.class.getClassLoader());
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{indexView, indexer.complete()});
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        return new OpenApiAnnotationScanner((OpenApiConfig)openApiConfig, (IndexView)compositeIndex, Collections.singletonList(new RESTEasyExtension(jaxrsConfig, (IndexView)compositeIndex))).scan();
    }

    private Result findStaticModel(ApplicationArchivesBuildItem archivesBuildItem) {
        OpenApiSerializer.Format format = OpenApiSerializer.Format.YAML;
        Path resourcePath = archivesBuildItem.getRootArchive().getChildPath(META_INF_OPENAPI_YAML);
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(WEB_INF_CLASSES_META_INF_OPENAPI_YAML);
        }
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(META_INF_OPENAPI_YML);
        }
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(WEB_INF_CLASSES_META_INF_OPENAPI_YML);
        }
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(META_INF_OPENAPI_JSON);
            format = OpenApiSerializer.Format.JSON;
        }
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(WEB_INF_CLASSES_META_INF_OPENAPI_JSON);
            format = OpenApiSerializer.Format.JSON;
        }
        if (resourcePath == null) {
            return null;
        }
        return new Result(format, resourcePath);
    }

    public OpenApiDocument loadDocument(OpenAPI staticModel, OpenAPI annotationModel) {
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        OpenAPIImpl readerModel = OpenApiProcessor.modelFromReader((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader());
        OpenApiDocument document = this.createDocument((OpenApiConfig)openApiConfig);
        if (annotationModel != null) {
            document.modelFromAnnotations(annotationModel);
        }
        document.modelFromReader((OpenAPI)readerModel);
        document.modelFromStaticFile(staticModel);
        document.filter(this.filter((OpenApiConfig)openApiConfig));
        document.initialize();
        return document;
    }

    private OpenApiDocument createDocument(OpenApiConfig openApiConfig) {
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        document.reset();
        document.config(openApiConfig);
        return document;
    }

    private OASFilter filter(OpenApiConfig openApiConfig) {
        return OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    static class Result {
        final OpenApiSerializer.Format format;
        final Path path;

        Result(OpenApiSerializer.Format format, Path path) {
            this.format = format;
            this.path = path;
        }
    }
}

