/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment;

import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;

public final class IgnoreDotNames {
    public static final IgnoreForReflectionPredicate IGNORE_FOR_REFLECTION_PREDICATE = new IgnoreForReflectionPredicate();
    private static final Set<DotName> TYPES_IGNORED_FOR_REFLECTION = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.json.JsonObject"), DotName.createSimple((String)"javax.json.JsonArray"), DotName.createSimple((String)"javax.json.JsonValue"), DotName.createSimple((String)"com.fasterxml.jackson.databind.JsonNode"), DotName.createSimple((String)"javax.ws.rs.core.Response"), DotName.createSimple((String)"javax.ws.rs.core.Response.StatusType"), DotName.createSimple((String)"javax.ws.rs.container.AsyncResponse"), DotName.createSimple((String)"javax.ws.rs.core.StreamingOutput"), DotName.createSimple((String)"javax.ws.rs.core.Form"), DotName.createSimple((String)"javax.ws.rs.core.MultivaluedMap"), DotName.createSimple((String)"org.jboss.resteasy.plugins.providers.multipart.MultipartInput"), DotName.createSimple((String)"org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput"), DotName.createSimple((String)"org.jboss.resteasy.plugins.providers.multipart.MultipartOutput"), DotName.createSimple((String)"org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput"), DotName.createSimple((String)"io.vertx.core.json.JsonArray"), DotName.createSimple((String)"io.vertx.core.json.JsonObject")));

    private static class IgnoreForReflectionPredicate
    implements Predicate<DotName> {
        private IgnoreForReflectionPredicate() {
        }

        @Override
        public boolean test(DotName name) {
            return TYPES_IGNORED_FOR_REFLECTION.contains(name) || ReflectiveHierarchyBuildItem.DefaultIgnorePredicate.INSTANCE.test(name);
        }
    }
}

