/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.security;

import io.quarkus.smallrye.openapi.common.deployment.SmallRyeOpenApiConfig;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.logging.Logger;

public class SecurityConfigFilter
implements OASFilter {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.smallrye.openapi");
    private final SmallRyeOpenApiConfig config;
    private final Map<String, List<String>> methodReferences;

    public SecurityConfigFilter(SmallRyeOpenApiConfig config, Map<String, List<String>> methodReferences) {
        this.config = config;
        this.methodReferences = methodReferences;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        Map<String, SecurityScheme> securitySchemes;
        if (this.config.securityScheme.isPresent()) {
            if (openAPI.getComponents() == null) {
                openAPI.setComponents(OASFactory.createComponents());
            }
            securitySchemes = new HashMap();
            if (openAPI.getComponents().getSecuritySchemes() != null && !openAPI.getComponents().getSecuritySchemes().isEmpty()) {
                securitySchemes.putAll(openAPI.getComponents().getSecuritySchemes());
            }
            SmallRyeOpenApiConfig.SecurityScheme securitySchemeOption = (SmallRyeOpenApiConfig.SecurityScheme)this.config.securityScheme.get();
            SecurityScheme securityScheme = OASFactory.createSecurityScheme();
            securityScheme.setDescription(this.config.securitySchemeDescription);
            switch (securitySchemeOption) {
                case basic: {
                    securityScheme.setType(SecurityScheme.Type.HTTP);
                    securityScheme.setScheme(this.config.basicSecuritySchemeValue);
                    break;
                }
                case jwt: {
                    securityScheme.setType(SecurityScheme.Type.HTTP);
                    securityScheme.setScheme(this.config.jwtSecuritySchemeValue);
                    securityScheme.setBearerFormat(this.config.jwtBearerFormat);
                    break;
                }
                case oidc: {
                    securityScheme.setType(SecurityScheme.Type.OPENIDCONNECT);
                    securityScheme.setOpenIdConnectUrl((String)this.config.oidcOpenIdConnectUrl.orElse(null));
                    break;
                }
                case oauth2Implicit: {
                    securityScheme.setType(SecurityScheme.Type.OAUTH2);
                    OAuthFlows oAuthFlows = OASFactory.createOAuthFlows();
                    OAuthFlow oAuthFlow = OASFactory.createOAuthFlow();
                    if (this.config.oauth2ImplicitAuthorizationUrl.isPresent()) {
                        oAuthFlow.authorizationUrl((String)this.config.oauth2ImplicitAuthorizationUrl.get());
                    }
                    if (this.config.oauth2ImplicitRefreshUrl.isPresent()) {
                        oAuthFlow.authorizationUrl((String)this.config.oauth2ImplicitRefreshUrl.get());
                    }
                    if (this.config.oauth2ImplicitTokenUrl.isPresent()) {
                        oAuthFlow.tokenUrl((String)this.config.oauth2ImplicitTokenUrl.get());
                    }
                    oAuthFlows.setImplicit(oAuthFlow);
                    securityScheme.setType(SecurityScheme.Type.OAUTH2);
                    securityScheme.setFlows(oAuthFlows);
                }
            }
            securitySchemes.put(this.config.securitySchemeName, securityScheme);
            openAPI.getComponents().setSecuritySchemes(securitySchemes);
        }
        if (openAPI.getComponents() != null && openAPI.getComponents().getSecuritySchemes() != null) {
            Map pathItems;
            Paths paths;
            securitySchemes = openAPI.getComponents().getSecuritySchemes();
            if (securitySchemes.size() > 1) {
                log.warn((Object)("Detected multiple Security Schemes, only one scheme is supported at the moment " + securitySchemes.keySet().toString()));
            }
            if (this.config.autoAddSecurityRequirement && !securitySchemes.isEmpty() && !this.methodReferences.isEmpty() && (paths = openAPI.getPaths()) != null && (pathItems = paths.getPathItems()) != null && !pathItems.isEmpty()) {
                Set pathItemsEntries = pathItems.entrySet();
                for (Map.Entry pathItem : pathItemsEntries) {
                    Map operations = ((PathItem)pathItem.getValue()).getOperations();
                    if (operations == null || operations.isEmpty()) continue;
                    for (Operation operation : operations.values()) {
                        OperationImpl operationImpl = (OperationImpl)operation;
                        if (!this.methodReferences.keySet().contains(operationImpl.getMethodRef())) continue;
                        SecurityRequirementImpl securityRequirement = new SecurityRequirementImpl();
                        List<String> roles = this.methodReferences.get(operationImpl.getMethodRef());
                        String name = (String)securitySchemes.keySet().iterator().next();
                        securityRequirement = securityRequirement.addScheme(name, roles);
                        operation = operation.addSecurityRequirement((SecurityRequirement)securityRequirement);
                    }
                }
            }
        }
    }
}

