/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.jboss.logging.Logger;

public class AutoRolesAllowedFilter
implements OASFilter {
    private static final Logger log = Logger.getLogger(AutoRolesAllowedFilter.class);
    private Map<String, List<String>> methodReferences;
    private String defaultSecuritySchemeName;

    public AutoRolesAllowedFilter() {
    }

    public AutoRolesAllowedFilter(String defaultSecuritySchemeName, Map<String, List<String>> methodReferences) {
        this.defaultSecuritySchemeName = defaultSecuritySchemeName;
        this.methodReferences = methodReferences;
    }

    public Map<String, List<String>> getMethodReferences() {
        return this.methodReferences;
    }

    public void setMethodReferences(Map<String, List<String>> methodReferences) {
        this.methodReferences = methodReferences;
    }

    public String getDefaultSecuritySchemeName() {
        return this.defaultSecuritySchemeName;
    }

    public void setDefaultSecuritySchemeName(String defaultSecuritySchemeName) {
        this.defaultSecuritySchemeName = defaultSecuritySchemeName;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        if (!this.methodReferences.isEmpty()) {
            Map pathItems;
            String securitySchemeName = this.getSecuritySchemeName(openAPI);
            Paths paths = openAPI.getPaths();
            if (paths != null && (pathItems = paths.getPathItems()) != null && !pathItems.isEmpty()) {
                Set pathItemsEntries = pathItems.entrySet();
                for (Map.Entry pathItem : pathItemsEntries) {
                    Map operations = ((PathItem)pathItem.getValue()).getOperations();
                    if (operations == null || operations.isEmpty()) continue;
                    for (Operation operation : operations.values()) {
                        OperationImpl operationImpl = (OperationImpl)operation;
                        if (!this.methodReferences.keySet().contains(operationImpl.getMethodRef())) continue;
                        SecurityRequirementImpl securityRequirement = new SecurityRequirementImpl();
                        List<String> roles = this.methodReferences.get(operationImpl.getMethodRef());
                        securityRequirement = securityRequirement.addScheme(securitySchemeName, roles);
                        operation = operation.addSecurityRequirement((SecurityRequirement)securityRequirement);
                        APIResponses responses = operation.getResponses();
                        for (APIResponseImpl response : this.getSecurityResponses()) {
                            responses.addAPIResponse(response.getResponseCode(), (APIResponse)response);
                        }
                        operation = operation.responses(responses);
                    }
                }
            }
        }
    }

    private String getSecuritySchemeName(OpenAPI openAPI) {
        if (openAPI.getComponents() != null && openAPI.getComponents().getSecuritySchemes() != null && !openAPI.getComponents().getSecuritySchemes().isEmpty()) {
            Map securitySchemes = openAPI.getComponents().getSecuritySchemes();
            return (String)securitySchemes.keySet().iterator().next();
        }
        return this.defaultSecuritySchemeName;
    }

    private List<APIResponseImpl> getSecurityResponses() {
        ArrayList<APIResponseImpl> responses = new ArrayList<APIResponseImpl>();
        APIResponseImpl notAuthorized = new APIResponseImpl();
        notAuthorized.setDescription("Not Authorized");
        notAuthorized.setResponseCode("401");
        responses.add(notAuthorized);
        APIResponseImpl forbidden = new APIResponseImpl();
        forbidden.setDescription("Not Allowed");
        forbidden.setResponseCode("403");
        responses.add(forbidden);
        return responses;
    }
}

