/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import io.smallrye.openapi.api.models.OperationImpl;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;

public class AutoTagFilter
implements OASFilter {
    private Map<String, String> classNameMap;

    public AutoTagFilter() {
    }

    public AutoTagFilter(Map<String, String> classNameMap) {
        this.classNameMap = classNameMap;
    }

    public Map<String, String> getClassNameMap() {
        return this.classNameMap;
    }

    public void setClassNameMap(Map<String, String> classNameMap) {
        this.classNameMap = classNameMap;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        Map pathItems;
        Paths paths;
        if (!this.classNameMap.isEmpty() && (paths = openAPI.getPaths()) != null && (pathItems = paths.getPathItems()) != null && !pathItems.isEmpty()) {
            Set pathItemsEntries = pathItems.entrySet();
            for (Map.Entry pathItem : pathItemsEntries) {
                Map operations = ((PathItem)pathItem.getValue()).getOperations();
                if (operations == null || operations.isEmpty()) continue;
                for (Operation operation : operations.values()) {
                    OperationImpl operationImpl;
                    String methodRef;
                    if (operation.getTags() != null && !operation.getTags().isEmpty() || !this.classNameMap.containsKey(methodRef = (operationImpl = (OperationImpl)operation).getMethodRef())) continue;
                    operation.addTag(this.splitCamelCase(this.classNameMap.get(methodRef)));
                }
            }
        }
    }

    private String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }
}

