/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BuildExclusionsBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.server.common.spi.AllowedJaxRsAnnotationPrefixBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.security.Authenticated;
import io.quarkus.security.PermissionsAllowed;
import io.quarkus.smallrye.openapi.OpenApiFilter;
import io.quarkus.smallrye.openapi.common.deployment.SmallRyeOpenApiConfig;
import io.quarkus.smallrye.openapi.deployment.CustomPathExtension;
import io.quarkus.smallrye.openapi.deployment.OpenApiFilteredIndexViewBuildItem;
import io.quarkus.smallrye.openapi.deployment.RESTEasyExtension;
import io.quarkus.smallrye.openapi.deployment.filter.AutoRolesAllowedFilter;
import io.quarkus.smallrye.openapi.deployment.filter.AutoServerFilter;
import io.quarkus.smallrye.openapi.deployment.filter.AutoTagFilter;
import io.quarkus.smallrye.openapi.deployment.filter.SecurityConfigFilter;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.quarkus.smallrye.openapi.deployment.spi.IgnoreStaticDocumentBuildItem;
import io.quarkus.smallrye.openapi.deployment.spi.OpenApiDocumentBuildItem;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentService;
import io.quarkus.smallrye.openapi.runtime.OpenApiRecorder;
import io.quarkus.smallrye.openapi.runtime.OpenApiRuntimeConfig;
import io.quarkus.smallrye.openapi.runtime.RuntimeOnlyBuilder;
import io.quarkus.smallrye.openapi.runtime.filter.AutoBasicSecurityFilter;
import io.quarkus.smallrye.openapi.runtime.filter.AutoBearerTokenSecurityFilter;
import io.quarkus.smallrye.openapi.runtime.filter.AutoSecurityFilter;
import io.quarkus.smallrye.openapi.runtime.filter.AutoUrl;
import io.quarkus.smallrye.openapi.runtime.filter.OpenIDConnectSecurityFilter;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.spi.RouteBuildItem;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.constants.SecurityConstants;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.jaxrs.JaxRsConstants;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.spring.SpringConstants;
import io.smallrye.openapi.vertx.VertxConstants;
import io.vertx.core.Handler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.spi.OASFactoryResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeOpenApiProcessor {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.smallrye.openapi");
    private static final String META_INF_OPENAPI_YAML = "META-INF/openapi.yaml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YAML = "WEB-INF/classes/META-INF/openapi.yaml";
    private static final String META_INF_OPENAPI_YML = "META-INF/openapi.yml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YML = "WEB-INF/classes/META-INF/openapi.yml";
    private static final String META_INF_OPENAPI_JSON = "META-INF/openapi.json";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_JSON = "WEB-INF/classes/META-INF/openapi.json";
    private static final DotName OPENAPI_SCHEMA = DotName.createSimple((String)Schema.class.getName());
    private static final DotName OPENAPI_RESPONSE = DotName.createSimple((String)APIResponse.class.getName());
    private static final DotName OPENAPI_RESPONSES = DotName.createSimple((String)APIResponses.class.getName());
    private static final DotName OPENAPI_SECURITY_REQUIREMENT = DotName.createSimple((String)SecurityRequirement.class.getName());
    private static final String OPENAPI_RESPONSE_CONTENT = "content";
    private static final String OPENAPI_RESPONSE_SCHEMA = "schema";
    private static final String OPENAPI_SCHEMA_NOT = "not";
    private static final String OPENAPI_SCHEMA_ONE_OF = "oneOf";
    private static final String OPENAPI_SCHEMA_ANY_OF = "anyOf";
    private static final String OPENAPI_SCHEMA_ALL_OF = "allOf";
    private static final String OPENAPI_SCHEMA_IMPLEMENTATION = "implementation";
    private static final String JAX_RS = "JAX-RS";
    private static final String SPRING = "Spring";
    private static final String VERT_X = "Vert.x";
    private static final String MANAGEMENT_ENABLED = "quarkus.smallrye-openapi.management.enabled";

    @BuildStep
    void contributeClassesToIndex(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses) {
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(new String[]{Collection.class.getName(), Map.class.getName(), Object.class.getName()}));
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)OASFactoryResolver.class.getName()));
    }

    @BuildStep
    void runtimeOnly(BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        runTimeConfigBuilder.produce((BuildItem)new RunTimeConfigBuilderBuildItem(RuntimeOnlyBuilder.class.getName()));
    }

    @BuildStep
    void configFiles(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, SmallRyeOpenApiConfig openApiConfig, LaunchModeBuildItem launchMode, OutputTargetBuildItem outputTargetBuildItem) throws IOException {
        if (launchMode.getLaunchMode().isDevOrTest() && openApiConfig.additionalDocsDirectory.isPresent()) {
            List additionalStaticDocuments = (List)openApiConfig.additionalDocsDirectory.get();
            for (Path path : additionalStaticDocuments) {
                List<String> filesInDir = this.getResourceFiles(path, outputTargetBuildItem.getOutputDirectory());
                for (String possibleFile : filesInDir) {
                    watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(possibleFile));
                }
            }
        }
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(META_INF_OPENAPI_YAML));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(WEB_INF_CLASSES_META_INF_OPENAPI_YAML));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(META_INF_OPENAPI_YML));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(WEB_INF_CLASSES_META_INF_OPENAPI_YML));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(META_INF_OPENAPI_JSON));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(WEB_INF_CLASSES_META_INF_OPENAPI_JSON));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerAutoSecurityFilter(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SmallRyeOpenApiConfig openApiConfig, OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem, List<SecurityInformationBuildItem> securityInformationBuildItems, OpenApiRecorder recorder) {
        AutoSecurityFilter autoSecurityFilter = null;
        if (openApiConfig.autoAddSecurity) {
            autoSecurityFilter = this.getAutoSecurityFilter(securityInformationBuildItems, openApiConfig).filter(securityFilter -> SmallRyeOpenApiProcessor.autoSecurityRuntimeEnabled(securityFilter, () -> this.getAutoRolesAllowedFilter(apiFilteredIndexViewBuildItem, openApiConfig))).orElse(null);
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(OASFilter.class).setRuntimeInit().supplier(recorder.autoSecurityFilterSupplier(autoSecurityFilter)).done());
    }

    static boolean autoSecurityRuntimeEnabled(AutoSecurityFilter autoSecurityFilter, Supplier<OASFilter> autoRolesAllowedFilterSource) {
        return autoSecurityFilter.runtimeRequired() || autoRolesAllowedFilterSource.get() != null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerAnnotatedUserDefinedRuntimeFilters(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem, OpenApiRecorder recorder) {
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        List<String> userDefinedRuntimeFilters = this.getUserDefinedRuntimeFilters((OpenApiConfig)openApiConfig, (IndexView)apiFilteredIndexViewBuildItem.getIndex());
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(OpenApiRecorder.UserDefinedRuntimeFilters.class).supplier(recorder.createUserDefinedRuntimeFilters(userDefinedRuntimeFilters)).done());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])userDefinedRuntimeFilters.toArray(new String[0])).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void handler(LaunchModeBuildItem launch, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, BuildProducer<RouteBuildItem> routes, BuildProducer<SystemPropertyBuildItem> systemProperties, OpenApiRecorder recorder, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, OpenApiRuntimeConfig openApiRuntimeConfig, ShutdownContextBuildItem shutdownContext, SmallRyeOpenApiConfig openApiConfig, List<FilterBuildItem> filterBuildItems, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
        if (launch.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            recorder.setupClDevMode((ShutdownContext)shutdownContext);
        }
        Handler handler = recorder.handler(openApiRuntimeConfig);
        Consumer corsFilter = null;
        if (!nonApplicationRootPathBuildItem.isAttachedToMainRouter()) {
            for (FilterBuildItem filterBuildItem : filterBuildItems) {
                if (filterBuildItem.getPriority() != 300) continue;
                corsFilter = recorder.corsFilter(filterBuildItem.toFilter());
                break;
            }
        }
        routes.produce((BuildItem)RouteBuildItem.newManagementRoute((String)openApiConfig.path, (String)MANAGEMENT_ENABLED).withRouteCustomizer(corsFilter).withRoutePathConfigKey("quarkus.smallrye-openapi.path").withRequestHandler(handler).displayOnNotFoundPage("Open API Schema document").asBlockingRoute().build());
        routes.produce((BuildItem)RouteBuildItem.newManagementRoute((String)(openApiConfig.path + ".json"), (String)MANAGEMENT_ENABLED).withRouteCustomizer(corsFilter).withRequestHandler(handler).build());
        routes.produce((BuildItem)RouteBuildItem.newManagementRoute((String)(openApiConfig.path + ".yaml"), (String)MANAGEMENT_ENABLED).withRouteCustomizer(corsFilter).withRequestHandler(handler).build());
        routes.produce((BuildItem)RouteBuildItem.newManagementRoute((String)(openApiConfig.path + ".yml"), (String)MANAGEMENT_ENABLED).withRouteCustomizer(corsFilter).withRequestHandler(handler).build());
        if (this.isManagement(managementInterfaceBuildTimeConfig, openApiConfig, launch)) {
            Config c = ConfigProvider.getConfig();
            Optional maybeCors = c.getOptionalValue("quarkus.http.cors", Boolean.class);
            if (!maybeCors.isPresent() || !((Boolean)maybeCors.get()).booleanValue()) {
                systemProperties.produce((BuildItem)new SystemPropertyBuildItem("quarkus.http.cors", "true"));
            }
            String managementUrl = this.getManagementRoot(launch, nonApplicationRootPathBuildItem, openApiConfig, managementInterfaceBuildTimeConfig);
            List origins = c.getOptionalValues("quarkus.http.cors.origins", String.class).orElse(new ArrayList());
            if (!origins.contains(managementUrl)) {
                origins.add(managementUrl);
                String originConfigValue = String.join((CharSequence)",", origins);
                systemProperties.produce((BuildItem)new SystemPropertyBuildItem("quarkus.http.cors.origins", originConfigValue));
            }
        }
    }

    private String getManagementRoot(LaunchModeBuildItem launch, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeOpenApiConfig openApiConfig, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
        String managementRoot = nonApplicationRootPathBuildItem.resolveManagementPath("/", managementInterfaceBuildTimeConfig, launch, openApiConfig.managementEnabled);
        return managementRoot.split(managementInterfaceBuildTimeConfig.rootPath)[0];
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void classLoaderHack(OpenApiRecorder recorder) {
        recorder.classLoaderHack();
    }

    @BuildStep
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(OpenApiDocumentService.class).setUnremovable().build());
    }

    @BuildStep
    OpenApiFilteredIndexViewBuildItem smallryeOpenApiIndex(CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildExclusionsBuildItem buildExclusionsBuildItem) {
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{combinedIndexBuildItem.getIndex(), beanArchiveIndexBuildItem.getIndex()});
        OpenApiConfig config = OpenApiConfig.fromConfig((Config)ConfigProvider.getConfig());
        final Set buildTimeClassExclusions = buildExclusionsBuildItem.getExcludedDeclaringClasses().stream().map(DotName::createSimple).collect(Collectors.toSet());
        FilteredIndexView indexView = new FilteredIndexView((IndexView)compositeIndex, config){

            public boolean accepts(DotName className) {
                if (super.accepts(className)) {
                    return !buildTimeClassExclusions.contains(className);
                }
                return false;
            }
        };
        return new OpenApiFilteredIndexViewBuildItem(indexView);
    }

    @BuildStep
    void addAutoFilters(BuildProducer<AddToOpenAPIDefinitionBuildItem> addToOpenAPIDefinitionProducer, List<SecurityInformationBuildItem> securityInformationBuildItems, OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem, SmallRyeOpenApiConfig config, LaunchModeBuildItem launchModeBuildItem, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
        OASFilter serverFilter;
        OASFilter autoServerFilter;
        OASFilter autoTagFilter;
        if (config.securityScheme.isPresent()) {
            addToOpenAPIDefinitionProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)new SecurityConfigFilter(config)));
        } else if (config.autoAddSecurity) {
            this.getAutoSecurityFilter(securityInformationBuildItems, config).map(AddToOpenAPIDefinitionBuildItem::new).ifPresent(arg_0 -> addToOpenAPIDefinitionProducer.produce(arg_0));
        }
        OASFilter autoRolesAllowedFilter = this.getAutoRolesAllowedFilter(apiFilteredIndexViewBuildItem, config);
        if (autoRolesAllowedFilter != null) {
            addToOpenAPIDefinitionProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem(autoRolesAllowedFilter));
        }
        if ((autoTagFilter = this.getAutoTagFilter(apiFilteredIndexViewBuildItem, config)) != null) {
            addToOpenAPIDefinitionProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem(autoTagFilter));
        }
        if ((autoServerFilter = this.getAutoServerFilter(config, false, "Auto generated value")) != null) {
            addToOpenAPIDefinitionProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem(autoServerFilter));
        } else if (this.isManagement(managementInterfaceBuildTimeConfig, config, launchModeBuildItem) && (serverFilter = this.getAutoServerFilter(config, true, "Auto-added by management interface")) != null) {
            addToOpenAPIDefinitionProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem(serverFilter));
        }
    }

    private List<String> getUserDefinedBuildtimeFilters(IndexView index) {
        return this.getUserDefinedFilters(index, OpenApiFilter.RunStage.BUILD);
    }

    private List<String> getUserDefinedRuntimeFilters(OpenApiConfig openApiConfig, IndexView index) {
        List<String> userDefinedFilters = this.getUserDefinedFilters(index, OpenApiFilter.RunStage.RUN);
        String filter = openApiConfig.filter();
        if (filter != null) {
            userDefinedFilters.add(filter);
        }
        return userDefinedFilters;
    }

    private List<String> getUserDefinedFilters(IndexView index, OpenApiFilter.RunStage stage) {
        EnumSet<OpenApiFilter.RunStage> stages = EnumSet.of(OpenApiFilter.RunStage.BOTH, stage);
        Comparator<Object> comparator = Comparator.comparing(x -> ((AnnotationInstance)x).valueWithDefault(index, "priority").asInt()).reversed();
        return index.getAnnotations(OpenApiFilter.class).stream().filter(ai -> stages.contains(OpenApiFilter.RunStage.valueOf((String)ai.value().asEnum()))).sorted(comparator).map(ai -> ai.target().asClass()).filter(c -> c.interfaceNames().contains(DotName.createSimple((String)OASFilter.class.getName()))).map(c -> c.name().toString()).collect(Collectors.toCollection(ArrayList::new));
    }

    private boolean isManagement(ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig, SmallRyeOpenApiConfig smallRyeOpenApiConfig, LaunchModeBuildItem launchModeBuildItem) {
        return managementInterfaceBuildTimeConfig.enabled && smallRyeOpenApiConfig.managementEnabled && launchModeBuildItem.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT);
    }

    private Optional<AutoSecurityFilter> getAutoSecurityFilter(List<SecurityInformationBuildItem> securityInformationBuildItems, SmallRyeOpenApiConfig config) {
        if (config.securityScheme.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(securityInformationBuildItems).map(Collection::stream).orElseGet(Stream::empty).map(securityInfo -> {
            switch (securityInfo.getSecurityModel()) {
                case jwt: {
                    return new AutoBearerTokenSecurityFilter(config.securitySchemeName, config.securitySchemeDescription, config.getValidSecuritySchemeExtentions(), config.jwtSecuritySchemeValue, config.jwtBearerFormat);
                }
                case oauth2: {
                    return new AutoBearerTokenSecurityFilter(config.securitySchemeName, config.securitySchemeDescription, config.getValidSecuritySchemeExtentions(), config.oauth2SecuritySchemeValue, config.oauth2BearerFormat);
                }
                case basic: {
                    return new AutoBasicSecurityFilter(config.securitySchemeName, config.securitySchemeDescription, config.getValidSecuritySchemeExtentions(), config.basicSecuritySchemeValue);
                }
                case oidc: {
                    return securityInfo.getOpenIDConnectInformation().map(info -> {
                        AutoUrl openIdConnectUrl = new AutoUrl((String)config.oidcOpenIdConnectUrl.orElse(null), info.getUrlConfigKey(), "/.well-known/openid-configuration");
                        return new OpenIDConnectSecurityFilter(config.securitySchemeName, config.securitySchemeDescription, config.getValidSecuritySchemeExtentions(), openIdConnectUrl);
                    }).orElse(null);
                }
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
    }

    private OASFilter getAutoRolesAllowedFilter(OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem, SmallRyeOpenApiConfig config) {
        if (config.autoAddSecurityRequirement) {
            Map<String, List<String>> rolesAllowedMethodReferences = this.getRolesAllowedMethodReferences(apiFilteredIndexViewBuildItem);
            this.getPermissionsAllowedMethodReferences(apiFilteredIndexViewBuildItem).forEach(k -> rolesAllowedMethodReferences.putIfAbsent((String)k, List.of()));
            List<String> authenticatedMethodReferences = this.getAuthenticatedMethodReferences(apiFilteredIndexViewBuildItem);
            if (!rolesAllowedMethodReferences.isEmpty() || !authenticatedMethodReferences.isEmpty()) {
                return new AutoRolesAllowedFilter(config.securitySchemeName, rolesAllowedMethodReferences, authenticatedMethodReferences);
            }
        }
        return null;
    }

    private OASFilter getAutoTagFilter(OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem, SmallRyeOpenApiConfig config) {
        Map<String, String> classNamesMethodReferences;
        if (config.autoAddTags && !(classNamesMethodReferences = this.getClassNamesMethodReferences(apiFilteredIndexViewBuildItem)).isEmpty()) {
            return new AutoTagFilter(classNamesMethodReferences);
        }
        return null;
    }

    private OASFilter getAutoServerFilter(SmallRyeOpenApiConfig config, boolean defaultFlag, String description) {
        if (config.autoAddServer.orElse(defaultFlag).booleanValue()) {
            int port;
            Config c = ConfigProvider.getConfig();
            String scheme = "http";
            String host = c.getOptionalValue("quarkus.http.host", String.class).orElse("0.0.0.0");
            String insecure = c.getOptionalValue("quarkus.http.insecure-requests", String.class).orElse("enabled");
            if (insecure.equalsIgnoreCase("enabled")) {
                port = c.getOptionalValue("quarkus.http.port", Integer.class).orElse(8080);
            } else {
                scheme = "https";
                port = c.getOptionalValue("quarkus.http.ssl-port", Integer.class).orElse(8443);
            }
            return new AutoServerFilter(scheme, host, port, description);
        }
        return null;
    }

    private Map<String, List<String>> getRolesAllowedMethodReferences(OpenApiFilteredIndexViewBuildItem indexViewBuildItem) {
        return SecurityConstants.ROLES_ALLOWED.stream().map(arg_0 -> ((FilteredIndexView)indexViewBuildItem.getIndex()).getAnnotations(arg_0)).flatMap(Collection::stream).flatMap(SmallRyeOpenApiProcessor::getMethods).collect(Collectors.toMap(e -> JandexUtil.createUniqueMethodReference((ClassInfo)((MethodInfo)e.getKey()).declaringClass(), (MethodInfo)((MethodInfo)e.getKey())), e -> List.of(((AnnotationInstance)e.getValue()).value().asStringArray()), (v1, v2) -> {
            if (!Objects.equals(v1, v2)) {
                log.warnf("Dropping duplicate annotation, but the values were different; v1: %s, v2: %s", v1, v2);
            }
            return v1;
        }));
    }

    private List<String> getPermissionsAllowedMethodReferences(OpenApiFilteredIndexViewBuildItem indexViewBuildItem) {
        return indexViewBuildItem.getIndex().getAnnotations(DotName.createSimple(PermissionsAllowed.class)).stream().flatMap(SmallRyeOpenApiProcessor::getMethods).map(e -> JandexUtil.createUniqueMethodReference((ClassInfo)((MethodInfo)e.getKey()).declaringClass(), (MethodInfo)((MethodInfo)e.getKey()))).distinct().toList();
    }

    private List<String> getAuthenticatedMethodReferences(OpenApiFilteredIndexViewBuildItem indexViewBuildItem) {
        return indexViewBuildItem.getIndex().getAnnotations(DotName.createSimple((String)Authenticated.class.getName())).stream().flatMap(SmallRyeOpenApiProcessor::getMethods).map(e -> JandexUtil.createUniqueMethodReference((ClassInfo)((MethodInfo)e.getKey()).declaringClass(), (MethodInfo)((MethodInfo)e.getKey()))).distinct().toList();
    }

    private static Stream<Map.Entry<MethodInfo, AnnotationInstance>> getMethods(AnnotationInstance annotation) {
        if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
            MethodInfo method2 = annotation.target().asMethod();
            if (SmallRyeOpenApiProcessor.isValidOpenAPIMethodForAutoAdd(method2)) {
                return Stream.of(Map.entry(method2, annotation));
            }
        } else if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
            ClassInfo classInfo = annotation.target().asClass();
            return classInfo.methods().stream().filter(method -> !method.hasDeclaredAnnotation(annotation.name())).filter(method -> SmallRyeOpenApiProcessor.isValidOpenAPIMethodForAutoAdd(method)).map(method -> Map.entry(method, annotation));
        }
        return Stream.empty();
    }

    private Map<String, String> getClassNamesMethodReferences(OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem) {
        FilteredIndexView filteredIndex = apiFilteredIndexViewBuildItem.getIndex();
        ArrayList openapiAnnotations = new ArrayList();
        Set<DotName> allOpenAPIEndpoints = SmallRyeOpenApiProcessor.getAllOpenAPIEndpoints();
        for (DotName dotName : allOpenAPIEndpoints) {
            openapiAnnotations.addAll(filteredIndex.getAnnotations(dotName));
        }
        HashMap<String, String> classNames = new HashMap<String, String>();
        for (AnnotationInstance ai : openapiAnnotations) {
            if (!ai.target().kind().equals((Object)AnnotationTarget.Kind.METHOD)) continue;
            MethodInfo method = ai.target().asMethod();
            ClassInfo declaringClass = method.declaringClass();
            Type[] params = method.parameterTypes().toArray(new Type[0]);
            if (Modifier.isInterface(declaringClass.flags())) {
                this.addMethodImplementationClassNames(method, params, filteredIndex.getAllKnownImplementors(declaringClass.name()), classNames);
                continue;
            }
            if (Modifier.isAbstract(declaringClass.flags())) {
                this.addMethodImplementationClassNames(method, params, filteredIndex.getAllKnownSubclasses(declaringClass.name()), classNames);
                continue;
            }
            String ref = JandexUtil.createUniqueMethodReference((ClassInfo)declaringClass, (MethodInfo)method);
            classNames.put(ref, declaringClass.simpleName());
        }
        return classNames;
    }

    void addMethodImplementationClassNames(MethodInfo method, Type[] params, Collection<ClassInfo> classes, Map<String, String> classNames) {
        for (ClassInfo impl : classes) {
            String simpleClassName = impl.simpleName();
            MethodInfo implMethod = impl.method(method.name(), params);
            if (implMethod != null) {
                classNames.put(JandexUtil.createUniqueMethodReference((ClassInfo)impl, (MethodInfo)implMethod), simpleClassName);
            }
            classNames.put(JandexUtil.createUniqueMethodReference((ClassInfo)impl, (MethodInfo)method), simpleClassName);
        }
    }

    private static boolean isValidOpenAPIMethodForAutoAdd(MethodInfo method) {
        return SmallRyeOpenApiProcessor.isOpenAPIEndpoint(method) && !method.hasAnnotation(OPENAPI_SECURITY_REQUIREMENT) && method.declaringClass().declaredAnnotation(OPENAPI_SECURITY_REQUIREMENT) == null;
    }

    @BuildStep
    public List<AllowedJaxRsAnnotationPrefixBuildItem> registerJaxRsSupportedAnnotation() {
        ArrayList<AllowedJaxRsAnnotationPrefixBuildItem> prefixes = new ArrayList<AllowedJaxRsAnnotationPrefixBuildItem>();
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("org.eclipse.microprofile.openapi.annotations"));
        return prefixes;
    }

    @BuildStep
    public void registerOpenApiSchemaClassesForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, OpenApiFilteredIndexViewBuildItem openApiFilteredIndexViewBuildItem, Capabilities capabilities) {
        FilteredIndexView index = openApiFilteredIndexViewBuildItem.getIndex();
        if (this.shouldScanAnnotations(capabilities, (IndexView)index)) {
            Collection schemaAnnotationInstances = index.getAnnotations(OPENAPI_SCHEMA);
            for (AnnotationInstance schemaAnnotationInstance : schemaAnnotationInstances) {
                AnnotationTarget typeTarget = schemaAnnotationInstance.target();
                if (typeTarget.kind() != AnnotationTarget.Kind.CLASS) continue;
                this.produceReflectiveHierarchy(reflectiveHierarchy, Type.create((DotName)typeTarget.asClass().name(), (Type.Kind)Type.Kind.CLASS), this.getClass().getSimpleName() + " > " + typeTarget.asClass().name());
            }
            Collection apiResponseAnnotationInstances = index.getAnnotations(OPENAPI_RESPONSE);
            this.registerReflectionForApiResponseSchemaSerialization(reflectiveClass, reflectiveHierarchy, apiResponseAnnotationInstances);
            Collection apiResponsesAnnotationInstances = index.getAnnotations(OPENAPI_RESPONSES);
            for (AnnotationInstance apiResponsesAnnotationInstance : apiResponsesAnnotationInstances) {
                AnnotationValue apiResponsesAnnotationValue = apiResponsesAnnotationInstance.value();
                if (apiResponsesAnnotationValue == null) continue;
                this.registerReflectionForApiResponseSchemaSerialization(reflectiveClass, reflectiveHierarchy, Arrays.asList(apiResponsesAnnotationValue.asNestedArray()));
            }
        }
    }

    private static boolean isOpenAPIEndpoint(MethodInfo method) {
        Set<DotName> httpAnnotations = SmallRyeOpenApiProcessor.getAllOpenAPIEndpoints();
        for (DotName httpAnnotation : httpAnnotations) {
            if (!method.hasAnnotation(httpAnnotation)) continue;
            return true;
        }
        return false;
    }

    private static Set<DotName> getAllOpenAPIEndpoints() {
        HashSet<DotName> httpAnnotations = new HashSet<DotName>();
        httpAnnotations.addAll(JaxRsConstants.HTTP_METHODS);
        httpAnnotations.addAll(SpringConstants.HTTP_METHODS);
        return httpAnnotations;
    }

    private void registerReflectionForApiResponseSchemaSerialization(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, Collection<AnnotationInstance> apiResponseAnnotationInstances) {
        for (AnnotationInstance apiResponseAnnotationInstance : apiResponseAnnotationInstances) {
            AnnotationInstance[] contents;
            AnnotationValue contentAnnotationValue = apiResponseAnnotationInstance.value(OPENAPI_RESPONSE_CONTENT);
            if (contentAnnotationValue == null) continue;
            for (AnnotationInstance content : contents = contentAnnotationValue.asNestedArray()) {
                AnnotationValue schemaNotClass;
                AnnotationValue annotationValue = content.value(OPENAPI_RESPONSE_SCHEMA);
                if (annotationValue == null) continue;
                AnnotationInstance schema = annotationValue.asNested();
                String source = this.getClass().getSimpleName() + " > " + schema.target();
                AnnotationValue schemaImplementationClass = schema.value(OPENAPI_SCHEMA_IMPLEMENTATION);
                if (schemaImplementationClass != null) {
                    this.produceReflectiveHierarchy(reflectiveHierarchy, schemaImplementationClass.asClass(), source);
                }
                if ((schemaNotClass = schema.value(OPENAPI_SCHEMA_NOT)) != null) {
                    reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{schemaNotClass.asString()}).methods().fields().build());
                }
                this.produceReflectiveHierarchy(reflectiveHierarchy, schema.value(OPENAPI_SCHEMA_ONE_OF), source);
                this.produceReflectiveHierarchy(reflectiveHierarchy, schema.value(OPENAPI_SCHEMA_ANY_OF), source);
                this.produceReflectiveHierarchy(reflectiveHierarchy, schema.value(OPENAPI_SCHEMA_ALL_OF), source);
            }
        }
    }

    @BuildStep
    public void build(BuildProducer<FeatureBuildItem> feature, BuildProducer<GeneratedResourceBuildItem> resourceBuildItemBuildProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<OpenApiDocumentBuildItem> openApiDocumentProducer, OpenApiFilteredIndexViewBuildItem openApiFilteredIndexViewBuildItem, Capabilities capabilities, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems, HttpRootPathBuildItem httpRootPathBuildItem, OutputTargetBuildItem out, SmallRyeOpenApiConfig smallRyeOpenApiConfig, OutputTargetBuildItem outputTargetBuildItem, List<IgnoreStaticDocumentBuildItem> ignoreStaticDocumentBuildItems) throws IOException {
        FilteredIndexView index = openApiFilteredIndexViewBuildItem.getIndex();
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_OPENAPI));
        ArrayList<Pattern> urlIgnorePatterns = new ArrayList<Pattern>();
        for (IgnoreStaticDocumentBuildItem isdbi : ignoreStaticDocumentBuildItems) {
            urlIgnorePatterns.add(isdbi.getUrlIgnorePattern());
        }
        OpenAPI staticModel = this.generateStaticModel(smallRyeOpenApiConfig, urlIgnorePatterns, outputTargetBuildItem.getOutputDirectory(), (OpenApiConfig)openApiConfig);
        Object annotationModel = this.shouldScanAnnotations(capabilities, (IndexView)index) ? this.generateAnnotationModel((IndexView)index, capabilities, httpRootPathBuildItem, config, (OpenApiConfig)openApiConfig) : new OpenAPIImpl();
        OpenApiDocument finalDocument = this.loadDocument(staticModel, (OpenAPI)annotationModel, openAPIBuildItems, (IndexView)index);
        for (Format format : Format.values()) {
            String name = "META-INF/quarkus-generated-openapi-doc." + format;
            byte[] schemaDocument = OpenApiSerializer.serialize((OpenAPI)finalDocument.get(), (Format)format).getBytes(StandardCharsets.UTF_8);
            resourceBuildItemBuildProducer.produce((BuildItem)new GeneratedResourceBuildItem(name, schemaDocument));
            nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{name}));
        }
        OpenApiDocument finalStoredOpenApiDocument = this.storeDocument(out, smallRyeOpenApiConfig, (IndexView)index, finalDocument.get());
        openApiDocumentProducer.produce((BuildItem)new OpenApiDocumentBuildItem(finalStoredOpenApiDocument));
    }

    @BuildStep
    LogCleanupFilterBuildItem logCleanup() {
        return new LogCleanupFilterBuildItem("io.smallrye.openapi.api.OpenApiDocument", new String[]{"OpenAPI document initialized:"});
    }

    private void produceReflectiveHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, AnnotationValue annotationValue, String source) {
        if (annotationValue != null) {
            for (Type type : annotationValue.asClassArray()) {
                this.produceReflectiveHierarchy(reflectiveHierarchy, type, source);
            }
        }
    }

    private void produceReflectiveHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, Type type, String source) {
        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(type).ignoreTypePredicate((Predicate)ResteasyDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ResteasyDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ResteasyDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
    }

    private void storeGeneratedSchema(SmallRyeOpenApiConfig openApiConfig, OutputTargetBuildItem out, byte[] schemaDocument, Format format) throws IOException {
        Path file;
        Path directory = (Path)openApiConfig.storeSchemaDirectory.get();
        Path outputDirectory = out.getOutputDirectory();
        if (!directory.isAbsolute() && outputDirectory != null) {
            directory = Paths.get(outputDirectory.getParent().toString(), directory.toString());
        }
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        if (!Files.exists(file = Paths.get(directory.toString(), "openapi." + format.toString().toLowerCase()), new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        Files.write(file, schemaDocument, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        log.info((Object)("OpenAPI " + format.toString() + " saved: " + file.toString()));
    }

    private boolean shouldScanAnnotations(Capabilities capabilities, IndexView index) {
        Config config = ConfigProvider.getConfig();
        boolean scanDisable = config.getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
        if (scanDisable) {
            return false;
        }
        boolean isRestEasy = capabilities.isPresent("io.quarkus.resteasy");
        boolean isQuarkusRest = capabilities.isPresent("io.quarkus.resteasy.reactive");
        boolean isSpring = capabilities.isPresent("io.quarkus.spring.web");
        boolean isVertx = this.isUsingVertxRoute(index);
        return isRestEasy || isQuarkusRest || isSpring || isVertx;
    }

    private boolean isUsingVertxRoute(IndexView index) {
        return !index.getAnnotations(VertxConstants.ROUTE).isEmpty() || !index.getAnnotations(VertxConstants.ROUTE_BASE).isEmpty();
    }

    private OpenAPI generateStaticModel(SmallRyeOpenApiConfig smallRyeOpenApiConfig, List<Pattern> ignorePatterns, Path target, OpenApiConfig openApiConfig) throws IOException {
        if (smallRyeOpenApiConfig.ignoreStaticDocument) {
            return null;
        }
        List<Result> results = this.findStaticModels(smallRyeOpenApiConfig, ignorePatterns, target);
        if (!results.isEmpty()) {
            OpenAPIImpl mergedStaticModel = new OpenAPIImpl();
            for (Result result : results) {
                InputStream is = result.inputStream;
                try (OpenApiStaticFile staticFile = new OpenApiStaticFile(is, result.format);){
                    OpenAPI staticFileModel = OpenApiProcessor.modelFromStaticFile((OpenApiConfig)openApiConfig, (OpenApiStaticFile)staticFile);
                    mergedStaticModel = (OpenAPI)MergeUtil.mergeObjects((Object)mergedStaticModel, (Object)staticFileModel);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            return mergedStaticModel;
        }
        return null;
    }

    private OpenAPI generateAnnotationModel(IndexView indexView, Capabilities capabilities, HttpRootPathBuildItem httpRootPathBuildItem, Config config, OpenApiConfig openApiConfig) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        String rootPath = httpRootPathBuildItem.getRootPath();
        String appPath = "";
        if (capabilities.isPresent("io.quarkus.resteasy")) {
            extensions.add(new RESTEasyExtension(indexView));
            appPath = config.getOptionalValue("quarkus.resteasy.path", String.class).orElse("");
        } else if (capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            extensions.add(new RESTEasyExtension(indexView));
            openApiConfig.doAllowNakedPathParameter();
            appPath = config.getOptionalValue("quarkus.rest.path", String.class).orElse("");
        }
        extensions.add(new CustomPathExtension(rootPath, appPath));
        OpenApiAnnotationScanner openApiAnnotationScanner = new OpenApiAnnotationScanner(openApiConfig, indexView, extensions);
        return openApiAnnotationScanner.scan(this.getScanners(capabilities, indexView));
    }

    private String[] getScanners(Capabilities capabilities, IndexView index) {
        ArrayList<String> scanners = new ArrayList<String>();
        if (capabilities.isPresent("io.quarkus.resteasy") || capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            scanners.add(JAX_RS);
        }
        if (capabilities.isPresent("io.quarkus.spring.web")) {
            scanners.add(SPRING);
        }
        if (this.isUsingVertxRoute(index)) {
            scanners.add(VERT_X);
        }
        return scanners.toArray(new String[0]);
    }

    private List<Result> findStaticModels(SmallRyeOpenApiConfig openApiConfig, List<Pattern> ignorePatterns, Path target) {
        ArrayList<Result> results = new ArrayList<Result>();
        this.addStaticModelIfExist(results, ignorePatterns, Format.YAML, META_INF_OPENAPI_YAML);
        this.addStaticModelIfExist(results, ignorePatterns, Format.YAML, WEB_INF_CLASSES_META_INF_OPENAPI_YAML);
        this.addStaticModelIfExist(results, ignorePatterns, Format.YAML, META_INF_OPENAPI_YML);
        this.addStaticModelIfExist(results, ignorePatterns, Format.YAML, WEB_INF_CLASSES_META_INF_OPENAPI_YML);
        this.addStaticModelIfExist(results, ignorePatterns, Format.JSON, META_INF_OPENAPI_JSON);
        this.addStaticModelIfExist(results, ignorePatterns, Format.JSON, WEB_INF_CLASSES_META_INF_OPENAPI_JSON);
        if (openApiConfig.additionalDocsDirectory.isPresent()) {
            List additionalStaticDocuments = (List)openApiConfig.additionalDocsDirectory.get();
            for (Path path : additionalStaticDocuments) {
                try {
                    List<String> filesInDir = this.getResourceFiles(path, target);
                    for (String possibleModelFile : filesInDir) {
                        this.addStaticModelIfExist(results, ignorePatterns, possibleModelFile);
                    }
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException("An error occurred while processing " + path, ioe);
                }
            }
        }
        return results;
    }

    private void addStaticModelIfExist(List<Result> results, List<Pattern> ignorePatterns, String path) {
        if (path.endsWith(".json")) {
            this.addStaticModelIfExist(results, ignorePatterns, Format.JSON, path);
        } else if (path.endsWith(".yaml") || path.endsWith(".yml")) {
            this.addStaticModelIfExist(results, ignorePatterns, Format.YAML, path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addStaticModelIfExist(List<Result> results, List<Pattern> ignorePatterns, Format format, String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> urls = cl.getResources(path);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String urlAsString = url.toString();
                if (this.shouldIgnore(ignorePatterns, urlAsString)) continue;
                URLConnection con = url.openConnection();
                con.setUseCaches(false);
                try {
                    InputStream inputStream = con.getInputStream();
                    try {
                        if (inputStream == null) continue;
                        byte[] contents = IoUtil.readBytes((InputStream)inputStream);
                        results.add(new Result(format, new ByteArrayInputStream(contents)));
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException("An error occurred while processing " + urlAsString + " for " + path, ex);
                    return;
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private boolean shouldIgnore(List<Pattern> ignorePatterns, String url) {
        for (Pattern ignorePattern : ignorePatterns) {
            Matcher matcher = ignorePattern.matcher(url);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private List<String> getResourceFiles(Path resourcePath, Path target) throws IOException {
        ArrayList<String> filenames;
        block19: {
            Path targetResourceDir;
            String resourceName = ClassPathUtils.toResourceName((Path)resourcePath);
            filenames = new ArrayList<String>();
            Path path = targetResourceDir = target == null ? null : target.resolve("classes").resolve(resourcePath);
            if (targetResourceDir != null && Files.exists(targetResourceDir, new LinkOption[0])) {
                try (Stream<Path> paths = Files.list(targetResourceDir);){
                    List<String> list = paths.map(t -> resourceName + "/" + t.getFileName().toString()).toList();
                    return list;
                }
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try (InputStream inputStream = cl.getResourceAsStream(resourceName);){
                if (inputStream == null) break block19;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                    String resource;
                    while ((resource = br.readLine()) != null) {
                        filenames.add(resourceName + "/" + resource);
                    }
                }
            }
        }
        return filenames;
    }

    private OpenApiDocument loadDocument(OpenAPI staticModel, OpenAPI annotationModel, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems, IndexView index) {
        OpenApiDocument document = this.prepareOpenApiDocument(staticModel, annotationModel, openAPIBuildItems, index, true);
        Config c = ConfigProvider.getConfig();
        String title = c.getOptionalValue("quarkus.application.name", String.class).orElse("Generated");
        String version = c.getOptionalValue("quarkus.application.version", String.class).orElse("1.0");
        document.archiveName(title);
        document.version(version);
        document.initialize();
        return document;
    }

    private OpenApiDocument storeDocument(OutputTargetBuildItem out, SmallRyeOpenApiConfig smallRyeOpenApiConfig, IndexView index, OpenAPI loadedModel) throws IOException {
        return this.storeDocument(out, smallRyeOpenApiConfig, index, loadedModel, true);
    }

    private OpenApiDocument storeDocument(OutputTargetBuildItem out, SmallRyeOpenApiConfig smallRyeOpenApiConfig, IndexView index, OpenAPI loadedModel, boolean includeRuntimeFilters) throws IOException {
        OASFilter autoServerFilter;
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        OpenApiDocument document = this.prepareOpenApiDocument(loadedModel, null, Collections.emptyList(), index, false);
        if (includeRuntimeFilters) {
            List<String> userDefinedRuntimeFilters = this.getUserDefinedRuntimeFilters((OpenApiConfig)openApiConfig, index);
            for (String s : userDefinedRuntimeFilters) {
                document.filter(this.filter(s, index));
            }
        }
        if ((autoServerFilter = this.getAutoServerFilter(smallRyeOpenApiConfig, true, "Auto generated value")) != null) {
            document.filter(autoServerFilter);
        }
        try {
            document.initialize();
        }
        catch (RuntimeException re) {
            if (includeRuntimeFilters) {
                return this.storeDocument(out, smallRyeOpenApiConfig, index, loadedModel, false);
            }
            throw re;
        }
        boolean shouldStore = smallRyeOpenApiConfig.storeSchemaDirectory.isPresent();
        if (shouldStore) {
            for (Format format : Format.values()) {
                byte[] schemaDocument = OpenApiSerializer.serialize((OpenAPI)document.get(), (Format)format).getBytes(StandardCharsets.UTF_8);
                this.storeGeneratedSchema(smallRyeOpenApiConfig, out, schemaDocument, format);
            }
        }
        return document;
    }

    private OpenApiDocument prepareOpenApiDocument(OpenAPI staticModel, OpenAPI annotationModel, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems, IndexView index, boolean executeBuildFilters) {
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        OpenAPI readerModel = OpenApiProcessor.modelFromReader((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader(), (IndexView)index);
        OpenApiDocument document = this.createDocument((OpenApiConfig)openApiConfig);
        if (annotationModel != null) {
            document.modelFromAnnotations(annotationModel);
        }
        document.modelFromReader(readerModel);
        document.modelFromStaticFile(staticModel);
        for (AddToOpenAPIDefinitionBuildItem openAPIBuildItem : openAPIBuildItems) {
            OASFilter otherExtensionFilter = openAPIBuildItem.getOASFilter();
            document.filter(otherExtensionFilter);
        }
        if (executeBuildFilters) {
            List<String> userDefinedFilters = this.getUserDefinedBuildtimeFilters(index);
            for (String filter : userDefinedFilters) {
                document.filter(this.filter(filter, index));
            }
        }
        return document;
    }

    private OpenApiDocument createDocument(OpenApiConfig openApiConfig) {
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        document.reset();
        document.config(openApiConfig);
        return document;
    }

    private OASFilter filter(String className, IndexView index) {
        return OpenApiProcessor.getFilter((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader(), (IndexView)index);
    }

    static {
        System.setProperty("mp.openapi.extensions.smallrye.defaultStreamingProduces", "application/octet-stream");
        System.setProperty("mp.openapi.extensions.smallrye.defaultStreamingConsumes", "application/octet-stream");
        System.setProperty("mp.openapi.extensions.smallrye.defaultProduces", "application/json");
        System.setProperty("mp.openapi.extensions.smallrye.defaultConsumes", "application/json");
        System.setProperty("mp.openapi.extensions.smallrye.defaultPrimitivesProduces", "text/plain");
        System.setProperty("mp.openapi.extensions.smallrye.defaultPrimitivesConsumes", "text/plain");
    }

    static class Result {
        final Format format;
        final InputStream inputStream;

        Result(Format format, InputStream inputStream) {
            this.format = format;
            this.inputStream = inputStream;
        }
    }
}

