/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@WebServlet
public class OpenApiServlet
extends HttpServlet {
    private static final String ALLOWED_METHODS = "GET, HEAD, OPTIONS";
    private static final String QUERY_PARAM_FORMAT = "format";
    @Inject
    OpenApiDocument openApiDocument;
    private final Map<OpenApiSerializer.Format, String> cachedModels = new ConcurrentHashMap<OpenApiSerializer.Format, String>();

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        OpenApiServlet.addCorsResponseHeaders(resp);
        resp.addHeader("Allow", ALLOWED_METHODS);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String accept = req.getHeader("Accept");
        String formatParam = req.getParameter(QUERY_PARAM_FORMAT);
        OpenApiSerializer.Format format = OpenApiSerializer.Format.YAML;
        if (accept != null && accept.contains(OpenApiSerializer.Format.JSON.getMimeType()) || OpenApiSerializer.Format.JSON.getMimeType().equalsIgnoreCase(formatParam)) {
            format = OpenApiSerializer.Format.JSON;
        }
        String oai = this.getCachedOaiString(format);
        OpenApiServlet.addCorsResponseHeaders(resp);
        resp.addHeader("Content-Type", format.getMimeType());
        resp.getOutputStream().print(oai);
    }

    void setOpenApiDocument(OpenApiDocument document) {
        this.openApiDocument = document;
    }

    private String getCachedOaiString(OpenApiSerializer.Format format) {
        return this.cachedModels.computeIfAbsent(format, this::getModel);
    }

    private String getModel(OpenApiSerializer.Format format) {
        try {
            return OpenApiSerializer.serialize((OpenAPI)this.openApiDocument.get(), (OpenApiSerializer.Format)format);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to serialize OpenAPI in " + format, ioe);
        }
    }

    private static void addCorsResponseHeaders(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", ALLOWED_METHODS);
        response.setHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        response.setHeader("Access-Control-Max-Age", "86400");
    }
}

