/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet
public class OpenApiServlet
extends HttpServlet {
    private static final String ALLOWED_METHODS = "GET, HEAD, OPTIONS";
    private static final String QUERY_PARAM_FORMAT = "format";
    public static final String GENERATED_DOC_BASE = "quarkus-generated-openapi-doc.";
    public static final String BASE_NAME = "META-INF/resources/quarkus-generated-openapi-doc.";

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        OpenApiServlet.addCorsResponseHeaders(resp);
        resp.addHeader("Allow", ALLOWED_METHODS);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String accept = req.getHeader("Accept");
        String formatParam = req.getParameter(QUERY_PARAM_FORMAT);
        OpenApiSerializer.Format format = OpenApiSerializer.Format.YAML;
        if (accept != null && accept.contains(OpenApiSerializer.Format.JSON.getMimeType()) || "JSON".equalsIgnoreCase(formatParam)) {
            format = OpenApiSerializer.Format.JSON;
        }
        OpenApiServlet.addCorsResponseHeaders(resp);
        resp.setHeader("Content-Type", format.getMimeType());
        resp.setCharacterEncoding("UTF-8");
        req.getRequestDispatcher("/quarkus-generated-openapi-doc." + format).include((ServletRequest)req, (ServletResponse)resp);
    }

    private static void addCorsResponseHeaders(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", ALLOWED_METHODS);
        response.setHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        response.setHeader("Access-Control-Max-Age", "86400");
    }
}

