/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.smallrye.openapi.runtime.io.Format;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class OpenApiHandler
implements Handler<RoutingContext> {
    public static volatile ClassLoader classLoader;
    private static final String ALLOWED_METHODS = "GET, HEAD, OPTIONS";
    private static final String QUERY_PARAM_FORMAT = "format";
    public static final String GENERATED_DOC_BASE = "quarkus-generated-openapi-doc.";
    public static final String BASE_NAME = "META-INF/quarkus-generated-openapi-doc.";

    private static void addCorsResponseHeaders(HttpServerResponse response) {
        response.headers().set("Access-Control-Allow-Origin", "*");
        response.headers().set("Access-Control-Allow-Credentials", "true");
        response.headers().set("Access-Control-Allow-Methods", ALLOWED_METHODS);
        response.headers().set("Access-Control-Allow-Headers", "Content-Type, Authorization");
        response.headers().set("Access-Control-Max-Age", "86400");
    }

    public void handle(RoutingContext event) {
        if (event.request().method().equals((Object)HttpMethod.OPTIONS)) {
            OpenApiHandler.addCorsResponseHeaders(event.response());
            event.response().headers().set("Allow", ALLOWED_METHODS);
            event.next();
        } else {
            HttpServerRequest req = event.request();
            HttpServerResponse resp = event.response();
            String accept = req.headers().get("Accept");
            List formatParams = event.queryParam(QUERY_PARAM_FORMAT);
            String formatParam = formatParams.isEmpty() ? null : (String)formatParams.get(0);
            Format format = Format.YAML;
            if (accept != null && accept.contains(Format.JSON.getMimeType()) || "JSON".equalsIgnoreCase(formatParam)) {
                format = Format.JSON;
            }
            OpenApiHandler.addCorsResponseHeaders(resp);
            resp.headers().set("Content-Type", format.getMimeType() + ";charset=UTF-8");
            ClassLoader cl = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
            try (InputStream in = cl.getResourceAsStream(BASE_NAME + format);){
                int r;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((r = in.read(buf)) > 0) {
                    out.write(buf, 0, r);
                }
                resp.end(Buffer.buffer((byte[])out.toByteArray()));
            }
            catch (IOException e) {
                event.fail((Throwable)e);
            }
        }
    }
}

