/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentService;
import io.smallrye.openapi.runtime.io.Format;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.microprofile.openapi.OASFilter;

public class OpenApiHandler
implements Handler<RoutingContext> {
    private volatile OpenApiDocumentService openApiDocumentService;
    private static final String ALLOWED_METHODS = "GET, HEAD, OPTIONS";
    private static final String QUERY_PARAM_FORMAT = "format";
    private static final MultiMap RESPONSE_HEADERS = new HeadersMultiMap();
    final boolean corsEnabled;
    final OASFilter autoSecurityFilter;

    public OpenApiHandler(boolean corsEnabled, OASFilter autoSecurityFilter) {
        this.corsEnabled = corsEnabled;
        this.autoSecurityFilter = autoSecurityFilter;
    }

    public void handle(RoutingContext event) {
        HttpServerRequest req = event.request();
        HttpServerResponse resp = event.response();
        if (req.method().equals((Object)HttpMethod.OPTIONS)) {
            if (!this.corsEnabled) {
                resp.headers().setAll(RESPONSE_HEADERS);
            }
            resp.headers().set("Allow", ALLOWED_METHODS);
            event.next();
        } else {
            String accept = req.headers().get("Accept");
            List formatParams = event.queryParam(QUERY_PARAM_FORMAT);
            String formatParam = formatParams.isEmpty() ? null : (String)formatParams.get(0);
            Format format = Format.YAML;
            if (accept != null && accept.contains(Format.JSON.getMimeType()) || "JSON".equalsIgnoreCase(formatParam)) {
                format = Format.JSON;
            }
            if (!this.corsEnabled) {
                resp.headers().setAll(RESPONSE_HEADERS);
            }
            resp.headers().set("Content-Type", format.getMimeType() + ";charset=UTF-8");
            byte[] schemaDocument = this.getOpenApiDocumentService().getDocument(format);
            resp.end(Buffer.buffer((byte[])schemaDocument));
        }
    }

    private OpenApiDocumentService getOpenApiDocumentService() {
        if (this.openApiDocumentService == null) {
            this.openApiDocumentService = (OpenApiDocumentService)Arc.container().instance(OpenApiDocumentService.class, new Annotation[0]).get();
            this.openApiDocumentService.init(this.autoSecurityFilter);
        }
        return this.openApiDocumentService;
    }

    static {
        RESPONSE_HEADERS.add("access-control-allow-origin", "*");
        RESPONSE_HEADERS.add("access-control-allow-credentials", "true");
        RESPONSE_HEADERS.add("access-control-allow-methods", ALLOWED_METHODS);
        RESPONSE_HEADERS.add("access-control-allow-headers", "Content-Type, Authorization");
        RESPONSE_HEADERS.add("access-control-max-age", "86400");
    }
}

