/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime.filter;

import io.quarkus.smallrye.openapi.runtime.filter.AutoSecurityFilter;
import io.quarkus.smallrye.openapi.runtime.filter.AutoUrl;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

public class OpenIDConnectSecurityFilter
extends AutoSecurityFilter {
    private AutoUrl openIdConnectUrl;

    public OpenIDConnectSecurityFilter() {
    }

    public OpenIDConnectSecurityFilter(String securitySchemeName, String securitySchemeDescription, AutoUrl openIdConnectUrl) {
        super(securitySchemeName, securitySchemeDescription);
        this.openIdConnectUrl = openIdConnectUrl;
    }

    public AutoUrl getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    public void setOpenIdConnectUrl(AutoUrl openIdConnectUrl) {
        this.openIdConnectUrl = openIdConnectUrl;
    }

    @Override
    protected SecurityScheme getSecurityScheme() {
        SecurityScheme securityScheme = OASFactory.createSecurityScheme();
        securityScheme.setType(SecurityScheme.Type.OPENIDCONNECT);
        securityScheme.setOpenIdConnectUrl(this.openIdConnectUrl.getFinalUrlValue());
        return securityScheme;
    }
}

