/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.opentracing.deployment;

import io.opentracing.contrib.interceptors.OpenTracingInterceptor;
import io.opentracing.contrib.jaxrs2.server.SpanFinishingFilter;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.smallrye.opentracing.runtime.QuarkusSmallRyeTracingDynamicFeature;
import io.quarkus.smallrye.opentracing.runtime.TracerProducer;
import io.quarkus.undertow.deployment.FilterBuildItem;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.servlet.DispatcherType;

public class SmallRyeOpenTracingProcessor {
    @BuildStep
    AdditionalBeanBuildItem registerBeans() {
        return new AdditionalBeanBuildItem(new Class[]{OpenTracingInterceptor.class, TracerProducer.class});
    }

    @BuildStep
    ReflectiveMethodBuildItem registerMethod() throws Exception {
        Method isAsync = ObserverMethod.class.getMethod("isAsync", new Class[0]);
        return new ReflectiveMethodBuildItem(isAsync);
    }

    @BuildStep
    void setupFilter(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, BuildProducer<FilterBuildItem> filterProducer, BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem("smallrye-opentracing"));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QuarkusSmallRyeTracingDynamicFeature.class.getName()));
        FilterBuildItem filterInfo = FilterBuildItem.builder((String)"tracingFilter", (String)SpanFinishingFilter.class.getName()).setAsyncSupported(true).addFilterUrlMapping("*", DispatcherType.FORWARD).addFilterUrlMapping("*", DispatcherType.INCLUDE).addFilterUrlMapping("*", DispatcherType.REQUEST).addFilterUrlMapping("*", DispatcherType.ASYNC).addFilterUrlMapping("*", DispatcherType.ERROR).build();
        filterProducer.produce((BuildItem)filterInfo);
    }
}

