/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.opentracing.runtime;

import io.opentracing.tag.Tags;
import io.quarkus.smallrye.opentracing.runtime.FilterUtil;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class QuarkusSmallRyeTracingStandaloneVertxDynamicFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        context.register(StandaloneFilter.class);
    }

    public static class StandaloneFilter
    implements ContainerRequestFilter {
        volatile CurrentVertxRequest currentVertxRequest;

        CurrentVertxRequest request() {
            if (this.currentVertxRequest == null) {
                this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
            }
            return this.currentVertxRequest;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            final RoutingContext routingContext = this.request().getCurrent();
            routingContext.addHeadersEndHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    SpanWrapper wrapper = (SpanWrapper)routingContext.get(SpanWrapper.PROPERTY_NAME);
                    if (wrapper != null) {
                        wrapper.getScope().close();
                        Tags.HTTP_STATUS.set(wrapper.get(), Integer.valueOf(routingContext.response().getStatusCode()));
                        if (routingContext.failure() != null) {
                            FilterUtil.addExceptionLogs(wrapper.get(), routingContext.failure());
                        }
                        wrapper.finish();
                    }
                }
            });
        }
    }
}

