/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.opentracing.runtime;

import io.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.opentracing.tag.Tags;
import io.quarkus.smallrye.opentracing.runtime.FilterUtil;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;

@Provider
@Priority(value=0)
public class QuarkusSmallRyeTracingStandaloneContainerResponseFilter
implements WriterInterceptor {
    @ServerResponseFilter(priority=2999)
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext, Throwable t) {
        Object wrapperObj = requestContext.getProperty(SpanWrapper.PROPERTY_NAME);
        if (!(wrapperObj instanceof SpanWrapper)) {
            return;
        }
        SpanWrapper wrapper = (SpanWrapper)wrapperObj;
        Tags.HTTP_STATUS.set(wrapper.get(), Integer.valueOf(responseContext.getStatus()));
        if (t != null) {
            FilterUtil.addExceptionLogs(wrapper.get(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext wic) throws IOException {
        try {
            wic.proceed();
        }
        finally {
            Object wrapperObj = wic.getProperty(SpanWrapper.PROPERTY_NAME);
            if (wrapperObj instanceof SpanWrapper) {
                SpanWrapper wrapper = (SpanWrapper)wrapperObj;
                wrapper.getScope().close();
                wrapper.finish();
            }
        }
    }
}

