/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.amqp.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesConfigResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.smallrye.reactivemessaging.amqp.deployment.AmqpBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.amqp.deployment.AmqpDevServicesBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.amqp.deployment.DevServicesAmqpBrokerBuildItem;
import java.io.Closeable;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class AmqpDevServicesProcessor {
    private static final Logger log = Logger.getLogger(AmqpDevServicesProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-amqp";
    private static final int AMQP_PORT = 5672;
    private static final ContainerLocator amqpContainerLocator = new ContainerLocator("quarkus-dev-service-amqp", 5672);
    private static final String AMQP_HOST_PROP = "amqp-host";
    private static final String AMQP_PORT_PROP = "amqp-port";
    private static final String AMQP_USER_PROP = "amqp-user";
    private static final String AMQP_PASSWORD_PROP = "amqp-password";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "admin";
    static volatile Closeable closeable;
    static volatile AmqpDevServiceCfg cfg;
    static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesAmqpBrokerBuildItem startAmqpDevService(LaunchModeBuildItem launchMode, AmqpBuildTimeConfig amqpClientBuildTimeConfig, BuildProducer<DevServicesConfigResultBuildItem> devServicePropertiesProducer, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        AmqpDevServiceCfg configuration = this.getConfiguration(amqpClientBuildTimeConfig);
        if (closeable != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return null;
            }
            this.shutdownBroker();
            cfg = null;
        }
        DevServicesAmqpBrokerBuildItem artemis = null;
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "AMQP Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            AmqpBroker broker = this.startAmqpBroker(configuration, launchMode, devServicesConfig.timeout);
            if (broker != null) {
                closeable = broker.getCloseable();
                devServicePropertiesProducer.produce((BuildItem)new DevServicesConfigResultBuildItem(AMQP_HOST_PROP, broker.host));
                devServicePropertiesProducer.produce((BuildItem)new DevServicesConfigResultBuildItem(AMQP_PORT_PROP, Integer.toString(broker.port)));
                devServicePropertiesProducer.produce((BuildItem)new DevServicesConfigResultBuildItem(AMQP_USER_PROP, broker.user));
                devServicePropertiesProducer.produce((BuildItem)new DevServicesConfigResultBuildItem(AMQP_PASSWORD_PROP, broker.password));
                artemis = new DevServicesAmqpBrokerBuildItem(broker.host, broker.port, broker.user, broker.password);
                if (broker.isOwner()) {
                    log.info((Object)"Dev Services for AMQP started.");
                    log.infof("Other Quarkus applications in dev mode will find the broker automatically. For Quarkus applications in production mode, you can connect to this by starting your application with -Damqp.host=%s -Damqp.port=%d -Damqp.user=%s -Damqp.password=%s", new Object[]{broker.host, broker.port, broker.user, broker.password});
                }
            }
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (closeable != null) {
                    this.shutdownBroker();
                    log.info((Object)"Dev Services for AMQP shut down.");
                }
                first = true;
                closeable = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        return artemis;
    }

    private void shutdownBroker() {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the AMQP broker", e);
            }
            finally {
                closeable = null;
            }
        }
    }

    private AmqpBroker startAmqpBroker(AmqpDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting Dev Services for AMQP, as it has been disabled in the config.");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)AMQP_HOST_PROP) || ConfigUtils.isPropertyPresent((String)AMQP_PORT_PROP)) {
            log.debug((Object)"Not starting Dev Services for AMQP, the amqp.host and/or amqp.port are configured.");
            return null;
        }
        if (!this.hasAmqpChannelWithoutHostAndPort()) {
            log.debug((Object)"Not starting Dev Services for AMQP, all the channels are configured.");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            log.warn((Object)"Docker isn't working, please configure the AMQP broker location.");
            return null;
        }
        Supplier<AmqpBroker> defaultAmqpBrokerSupplier = () -> {
            ArtemisContainer container = new ArtemisContainer(DockerImageName.parse((String)config.imageName), config.extra, config.fixedExposedPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null);
            timeout.ifPresent(arg_0 -> ((ArtemisContainer)container).withStartupTimeout(arg_0));
            container.start();
            return new AmqpBroker(container.getHost(), container.getPort(), "admin", "admin", () -> ((ArtemisContainer)container).close());
        };
        return amqpContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> new AmqpBroker(containerAddress.getHost(), containerAddress.getPort(), "admin", "admin", null)).orElseGet(defaultAmqpBrokerSupplier);
    }

    private boolean hasAmqpChannelWithoutHostAndPort() {
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            boolean isIncoming = name.startsWith("mp.messaging.incoming.");
            boolean isOutgoing = name.startsWith("mp.messaging.outgoing.");
            boolean isConnector = name.endsWith(".connector");
            boolean isConfigured = false;
            if ((isIncoming || isOutgoing) && isConnector) {
                String connectorValue = (String)config.getValue(name, String.class);
                boolean isAmqp = connectorValue.equalsIgnoreCase("smallrye-amqp");
                boolean hasHost = ConfigUtils.isPropertyPresent((String)name.replace(".connector", ".host"));
                boolean hasPort = ConfigUtils.isPropertyPresent((String)name.replace(".connector", ".port"));
                boolean bl = isConfigured = isAmqp && (hasHost || hasPort);
            }
            if (isConfigured) continue;
            return true;
        }
        return false;
    }

    private AmqpDevServiceCfg getConfiguration(AmqpBuildTimeConfig cfg) {
        AmqpDevServicesBuildTimeConfig devServicesConfig = cfg.devservices;
        return new AmqpDevServiceCfg(devServicesConfig);
    }

    static {
        first = true;
    }

    private static final class ArtemisContainer
    extends GenericContainer<ArtemisContainer> {
        private final int port;

        private ArtemisContainer(DockerImageName dockerImageName, String extra, int fixedExposedPort, String serviceName) {
            super(dockerImageName);
            this.port = fixedExposedPort;
            this.withNetwork(Network.SHARED);
            this.withExposedPorts(new Integer[]{5672});
            this.withEnv("AMQ_USER", "admin");
            this.withEnv("AMQ_PASSWORD", "admin");
            this.withEnv("AMQ_EXTRA_ARGS", extra);
            if (serviceName != null) {
                this.withLabel(AmqpDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            if (!dockerImageName.getRepository().equals("artemiscloud/activemq-artemis-broker")) {
                throw new IllegalArgumentException("Only artemiscloud/activemq-artemis-broker images are supported");
            }
            this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*AMQ241004.*", (int)1));
        }

        protected void configure() {
            super.configure();
            if (this.port > 0) {
                this.addFixedExposedPort(this.port, 5672);
            }
        }

        public int getPort() {
            return this.getMappedPort(5672);
        }
    }

    private static final class AmqpDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final String extra;
        private final boolean shared;
        private final String serviceName;

        public AmqpDevServiceCfg(AmqpDevServicesBuildTimeConfig devServicesConfig) {
            this.devServicesEnabled = devServicesConfig.enabled.orElse(true);
            this.imageName = devServicesConfig.imageName;
            this.fixedExposedPort = devServicesConfig.port.orElse(0);
            this.extra = devServicesConfig.extraArgs;
            this.shared = devServicesConfig.shared;
            this.serviceName = devServicesConfig.serviceName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AmqpDevServiceCfg that = (AmqpDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort);
        }
    }

    private static class AmqpBroker {
        private final Closeable closeable;
        private final String host;
        private final int port;
        private final String user;
        private final String password;

        public AmqpBroker(String host, int port, String user, String password, Closeable closeable) {
            this.host = host;
            this.port = port;
            this.user = user;
            this.password = password;
            this.closeable = closeable;
        }

        public boolean isOwner() {
            return this.closeable != null;
        }

        public Closeable getCloseable() {
            return this.closeable;
        }
    }
}

