/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.DeploymentClassLoaderBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.smallrye.reactivemessaging.deployment.DotNames;
import io.quarkus.smallrye.reactivemessaging.deployment.EmitterBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.MediatorBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.QuarkusMediatorConfigurationUtil;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusMediatorConfiguration;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingLifecycle;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingRecorder;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.annotations.Stream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeReactiveMessagingProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"io.quarkus.smallrye-reactive-messaging.deployment.processor");
    static final String INVOKER_SUFFIX = "_SmallryeMessagingInvoker";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("smallrye-reactive-messaging");
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return new AdditionalBeanBuildItem(new Class[]{SmallRyeReactiveMessagingLifecycle.class, Connector.class, Stream.class});
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformBeanScope(BeanArchiveIndexBuildItem index) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (ctx.isClass()) {
                    if (BuiltinScope.isDeclaredOn((ClassInfo)ctx.getTarget().asClass())) {
                        return;
                    }
                    ClassInfo clazz = ctx.getTarget().asClass();
                    Map annotations = clazz.annotations();
                    if (annotations.containsKey(DotNames.INCOMING) || annotations.containsKey(DotNames.OUTGOING)) {
                        LOGGER.debugf("Found reactive messaging annotations on a class %s with no scope defined - adding @Dependent", (Object)ctx.getTarget());
                        ctx.transform().add(Dependent.class, new AnnotationValue[0]).done();
                    }
                }
            }
        });
    }

    @BuildStep
    void validateBeanDeployment(ValidationPhaseBuildItem validationPhase, BuildProducer<MediatorBuildItem> mediatorMethods, BuildProducer<EmitterBuildItem> emitters, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : (List)validationPhase.getContext().get(BuildExtension.Key.BEANS)) {
            if (!bean.isClassBean()) continue;
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                AnnotationInstance incoming = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.INCOMING);
                AnnotationInstance outgoing = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.OUTGOING);
                if (incoming == null && outgoing == null) continue;
                if (incoming != null && incoming.value().asString().isEmpty()) {
                    validationPhase.getContext().addDeploymentProblem((Throwable)new DeploymentException("Empty @Incoming annotation on method " + method));
                }
                if (outgoing != null && outgoing.value().asString().isEmpty()) {
                    validationPhase.getContext().addDeploymentProblem((Throwable)new DeploymentException("Empty @Outgoing annotation on method " + method));
                }
                mediatorMethods.produce((BuildItem)new MediatorBuildItem(bean, method));
                LOGGER.debugf("Found mediator business method %s declared on %s", (Object)method, (Object)bean);
            }
        }
        for (InjectionPointInfo injectionPoint : (List)validationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            if (!injectionPoint.getRequiredType().name().equals((Object)DotNames.EMITTER)) continue;
            AnnotationInstance instance = injectionPoint.getRequiredQualifier(DotNames.CHANNEL);
            if (instance == null) {
                instance = injectionPoint.getRequiredQualifier(DotNames.STREAM);
            }
            if (instance == null) continue;
            String name = instance.value().asString();
            Optional<AnnotationInstance> maybeOverflow = annotationStore.getAnnotations(injectionPoint.getTarget()).stream().filter(ai -> DotNames.ON_OVERFLOW.equals((Object)ai.name())).filter(ai -> {
                if (ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER && injectionPoint.isParam()) {
                    return ai.target().asMethodParameter().position() == injectionPoint.getPosition();
                }
                return true;
            }).findAny();
            LOGGER.debugf("Emitter injection point '%s' detected, stream name: '%s'", (Object)injectionPoint.getTargetInfo(), (Object)name);
            if (maybeOverflow.isPresent()) {
                AnnotationInstance annotation = maybeOverflow.get();
                AnnotationValue maybeBufferSize = annotation.value("bufferSize");
                int bufferSize = maybeBufferSize != null ? maybeBufferSize.asInt() : 0;
                emitters.produce((BuildItem)EmitterBuildItem.of(name, annotation.value().asString(), bufferSize));
                continue;
            }
            emitters.produce((BuildItem)EmitterBuildItem.of(name));
        }
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> removalExclusions() {
        return Arrays.asList(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(DotNames.INCOMING)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(DotNames.OUTGOING)));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(SmallRyeReactiveMessagingRecorder recorder, RecorderContext recorderContext, BeanContainerBuildItem beanContainer, List<MediatorBuildItem> mediatorMethods, List<EmitterBuildItem> emitterFields, final BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, DeploymentClassLoaderBuildItem deploymentClassLoaderBuildItem) {
        ArrayList<QuarkusMediatorConfiguration> configurations = new ArrayList<QuarkusMediatorConfiguration>(mediatorMethods.size());
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, name, data));
            }
        };
        for (MediatorBuildItem mediatorMethod : mediatorMethods) {
            MethodInfo methodInfo = mediatorMethod.getMethod();
            BeanInfo bean = mediatorMethod.getBean();
            String generatedInvokerName = this.generateInvoker(bean, methodInfo, classOutput);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{generatedInvokerName}));
            try {
                QuarkusMediatorConfiguration mediatorConfiguration = QuarkusMediatorConfigurationUtil.create(methodInfo, bean, generatedInvokerName, recorderContext, deploymentClassLoaderBuildItem.getClassLoader());
                configurations.add(mediatorConfiguration);
            }
            catch (IllegalArgumentException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        recorder.registerMediators(configurations, beanContainer.getValue());
        for (EmitterBuildItem it : emitterFields) {
            int defaultBufferSize = ConfigProviderResolver.instance().getConfig().getOptionalValue("smallrye.messaging.emitter.default-buffer-size", Integer.class).orElse(127);
            if (it.getOverflow() != null) {
                recorder.configureEmitter(beanContainer.getValue(), it.getName(), it.getOverflow(), it.getBufferSize(), defaultBufferSize);
                continue;
            }
            recorder.configureEmitter(beanContainer.getValue(), it.getName(), null, 0, defaultBufferSize);
        }
    }

    private String generateInvoker(BeanInfo bean, MethodInfo method, ClassOutput classOutput) {
        String baseName = bean.getImplClazz().enclosingClass() != null ? io.quarkus.arc.processor.DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + io.quarkus.arc.processor.DotNames.simpleName((DotName)bean.getImplClazz().name()) : io.quarkus.arc.processor.DotNames.simpleName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String targetPackage = io.quarkus.arc.processor.DotNames.packageName((DotName)bean.getImplClazz().name());
        String generatedName = targetPackage.replace('.', '/') + "/" + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        try (ClassCreator invoker = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{Invoker.class}).build();){
            FieldDescriptor beanInstanceField = invoker.getFieldCreator("beanInstance", Object.class).getFieldDescriptor();
            try (MethodCreator ctor = invoker.getMethodCreator("<init>", Void.TYPE, new Class[]{Object.class});){
                ctor.setModifiers(1);
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                ResultHandle self = ctor.getThis();
                ResultHandle config = ctor.getMethodParam(0);
                ctor.writeInstanceField(beanInstanceField, self, config);
                ctor.returnValue(null);
            }
            var12_14 = null;
            try (MethodCreator invoke = invoker.getMethodCreator(MethodDescriptor.ofMethod((Object)generatedName, (String)"invoke", Object.class, (Object[])new Object[]{Object[].class}));){
                int parametersCount = method.parameters().size();
                String[] argTypes = new String[parametersCount];
                ResultHandle[] args = new ResultHandle[parametersCount];
                for (int i = 0; i < parametersCount; ++i) {
                    args[i] = invoke.readArrayValue(invoke.getMethodParam(0), i);
                    argTypes[i] = ((Type)method.parameters().get(i)).name().toString();
                }
                ResultHandle result = invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((String)method.declaringClass().name().toString(), (String)method.name(), (String)method.returnType().name().toString(), (String[])argTypes), invoke.readInstanceField(beanInstanceField, invoke.getThis()), args);
                if (DotNames.VOID.equals((Object)method.returnType().name())) {
                    invoke.returnValue(invoke.loadNull());
                } else {
                    invoke.returnValue(result);
                }
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
        }
        return generatedName.replace('/', '.');
    }
}

