/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusMediatorConfiguration;
import io.smallrye.reactive.messaging.MediatorConfigurationSupport;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Merge;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class QuarkusMediatorConfigurationUtil {
    private QuarkusMediatorConfigurationUtil() {
    }

    static QuarkusMediatorConfiguration create(MethodInfo methodInfo, BeanInfo bean, String generatedInvokerName, RecorderContext recorderContext, ClassLoader cl) {
        Class<?> returnTypeClass = QuarkusMediatorConfigurationUtil.load(methodInfo.returnType().name().toString(), cl);
        Class[] parameterTypeClasses = new Class[methodInfo.parameters().size()];
        for (int i = 0; i < methodInfo.parameters().size(); ++i) {
            parameterTypeClasses[i] = QuarkusMediatorConfigurationUtil.load(((Type)methodInfo.parameters().get(i)).name().toString(), cl);
        }
        QuarkusMediatorConfiguration configuration = new QuarkusMediatorConfiguration();
        MediatorConfigurationSupport mediatorConfigurationSupport = new MediatorConfigurationSupport(QuarkusMediatorConfigurationUtil.fullMethodName(methodInfo), returnTypeClass, parameterTypeClasses, (MediatorConfigurationSupport.GenericTypeAssignable)new ReturnTypeGenericTypeAssignable(methodInfo, cl), (MediatorConfigurationSupport.GenericTypeAssignable)(methodInfo.parameters().isEmpty() ? new AlwaysInvalidIndexGenericTypeAssignable() : new MethodParamGenericTypeAssignable(methodInfo, 0, cl)));
        configuration.setBeanId(bean.getIdentifier());
        configuration.setMethodName(methodInfo.name());
        configuration.setInvokerClass(recorderContext.classProxy(generatedInvokerName));
        String returnTypeName = methodInfo.returnType().name().toString();
        configuration.setReturnType(recorderContext.classProxy(returnTypeName));
        Class[] parameterTypes = new Class[methodInfo.parameters().size()];
        for (int i = 0; i < methodInfo.parameters().size(); ++i) {
            parameterTypes[i] = recorderContext.classProxy(((Type)methodInfo.parameters().get(i)).name().toString());
        }
        configuration.setParameterTypes(parameterTypes);
        List<String> incomingValues = QuarkusMediatorConfigurationUtil.getValues(methodInfo, ReactiveMessagingDotNames.INCOMING);
        configuration.setIncomings(incomingValues);
        String outgoingValue = QuarkusMediatorConfigurationUtil.getValue(methodInfo, ReactiveMessagingDotNames.OUTGOING);
        configuration.setOutgoing(outgoingValue);
        Shape shape = mediatorConfigurationSupport.determineShape(incomingValues, (Object)outgoingValue);
        configuration.setShape(shape);
        Acknowledgment.Strategy acknowledgment = mediatorConfigurationSupport.processSuppliedAcknowledgement(incomingValues, () -> {
            AnnotationInstance instance = methodInfo.annotation(ReactiveMessagingDotNames.ACKNOWLEDGMENT);
            if (instance != null) {
                return Acknowledgment.Strategy.valueOf((String)instance.value().asEnum());
            }
            return null;
        });
        configuration.setAcknowledgment(acknowledgment);
        MediatorConfigurationSupport.ValidationOutput validationOutput = mediatorConfigurationSupport.validate(shape, acknowledgment);
        configuration.setProduction(validationOutput.getProduction());
        configuration.setConsumption(validationOutput.getConsumption());
        if (validationOutput.getUseBuilderTypes() != null) {
            configuration.setUseBuilderTypes(validationOutput.getUseBuilderTypes().booleanValue());
        } else {
            configuration.setUseBuilderTypes(false);
        }
        if (acknowledgment == null) {
            acknowledgment = mediatorConfigurationSupport.processDefaultAcknowledgement(shape, validationOutput.getConsumption());
            configuration.setAcknowledgment(acknowledgment);
        }
        configuration.setMerge(mediatorConfigurationSupport.processMerge(incomingValues, () -> {
            AnnotationInstance instance = methodInfo.annotation(ReactiveMessagingDotNames.MERGE);
            if (instance != null) {
                AnnotationValue value = instance.value();
                if (value == null) {
                    return Merge.Mode.MERGE;
                }
                return Merge.Mode.valueOf((String)value.asEnum());
            }
            return null;
        }));
        configuration.setBroadcastValue(mediatorConfigurationSupport.processBroadcast((Object)outgoingValue, () -> {
            AnnotationInstance instance = methodInfo.annotation(ReactiveMessagingDotNames.BROADCAST);
            if (instance != null) {
                AnnotationValue value = instance.value();
                if (value == null) {
                    return 0;
                }
                return value.asInt();
            }
            return null;
        }));
        AnnotationInstance blockingAnnotation = methodInfo.annotation(ReactiveMessagingDotNames.BLOCKING);
        if (blockingAnnotation != null) {
            String poolName;
            mediatorConfigurationSupport.validateBlocking(validationOutput);
            configuration.setBlocking(true);
            AnnotationValue ordered = blockingAnnotation.value("ordered");
            configuration.setBlockingExecutionOrdered(ordered == null || ordered.asBoolean());
            if (blockingAnnotation.value() != null && !(poolName = blockingAnnotation.value().asString()).equals("<no-value>")) {
                configuration.setWorkerPoolName(poolName);
            }
        }
        return configuration;
    }

    private static Class<?> load(String className, ClassLoader cl) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        try {
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getValue(MethodInfo methodInfo, DotName dotName) {
        AnnotationInstance annotationInstance = methodInfo.annotation(dotName);
        String value = null;
        if (annotationInstance != null) {
            if (annotationInstance.value() != null) {
                value = annotationInstance.value().asString();
            }
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException("@" + dotName.withoutPackagePrefix() + " value cannot be blank. Offending method is: " + QuarkusMediatorConfigurationUtil.fullMethodName(methodInfo));
            }
        }
        return value;
    }

    private static List<String> getValues(MethodInfo methodInfo, DotName dotName) {
        return methodInfo.annotations().stream().filter(ai -> ai.name().equals((Object)dotName)).map(ai -> ai.value().asString()).collect(Collectors.toList());
    }

    private static String fullMethodName(MethodInfo methodInfo) {
        return methodInfo.declaringClass() + "#" + methodInfo.name();
    }

    private static class MethodParamGenericTypeAssignable
    extends JandexGenericTypeAssignable {
        public MethodParamGenericTypeAssignable(MethodInfo method, int paramIndex, ClassLoader classLoader) {
            super(MethodParamGenericTypeAssignable.getGenericParameterType(method, paramIndex), classLoader);
        }

        private static Type getGenericParameterType(MethodInfo method, int paramIndex) {
            List parameters = method.parameters();
            if (parameters.size() < paramIndex + 1) {
                throw new IllegalArgumentException("Method " + method + " only has " + parameters.size() + " so parameter with index " + paramIndex + " cannot be retrieved");
            }
            return (Type)parameters.get(paramIndex);
        }
    }

    private static class AlwaysInvalidIndexGenericTypeAssignable
    implements MediatorConfigurationSupport.GenericTypeAssignable {
        private AlwaysInvalidIndexGenericTypeAssignable() {
        }

        public MediatorConfigurationSupport.GenericTypeAssignable.Result check(Class<?> target, int index) {
            return MediatorConfigurationSupport.GenericTypeAssignable.Result.InvalidIndex;
        }
    }

    private static class JandexGenericTypeAssignable
    implements MediatorConfigurationSupport.GenericTypeAssignable {
        private final ClassLoader classLoader;
        private final Type type;

        public JandexGenericTypeAssignable(Type type, ClassLoader classLoader) {
            this.classLoader = classLoader;
            this.type = type;
        }

        public MediatorConfigurationSupport.GenericTypeAssignable.Result check(Class<?> target, int index) {
            if (this.type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                return MediatorConfigurationSupport.GenericTypeAssignable.Result.NotGeneric;
            }
            List arguments = this.type.asParameterizedType().arguments();
            if (arguments.size() >= index + 1) {
                Class argumentClass = QuarkusMediatorConfigurationUtil.load(((Type)arguments.get(index)).name().toString(), this.classLoader);
                return target.isAssignableFrom(argumentClass) ? MediatorConfigurationSupport.GenericTypeAssignable.Result.Assignable : MediatorConfigurationSupport.GenericTypeAssignable.Result.NotAssignable;
            }
            return MediatorConfigurationSupport.GenericTypeAssignable.Result.InvalidIndex;
        }
    }

    private static class ReturnTypeGenericTypeAssignable
    extends JandexGenericTypeAssignable {
        public ReturnTypeGenericTypeAssignable(MethodInfo method, ClassLoader classLoader) {
            super(method.returnType(), classLoader);
        }
    }
}

