/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment;

import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.ConnectorAttributeLiteral;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ChannelDirection;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ConnectorBuildItem;
import io.smallrye.reactive.messaging.annotations.ConnectorAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class WiringHelper {
    private WiringHelper() {
    }

    static String getConnectorName(BeanInfo bi) {
        return ((AnnotationInstance)bi.getQualifier(ReactiveMessagingDotNames.CONNECTOR).orElseThrow(() -> new NoSuchElementException("Expecting a @Connector"))).value().asString();
    }

    static void produceIncomingChannel(BuildProducer<ChannelBuildItem> producer, String name) {
        Optional<String> managingConnector = WiringHelper.getManagingConnector(ChannelDirection.INCOMING, name);
        if (managingConnector.isPresent()) {
            if (WiringHelper.isChannelEnabled(ChannelDirection.INCOMING, name)) {
                producer.produce((BuildItem)ChannelBuildItem.incoming(name, managingConnector.get()));
            }
        } else {
            producer.produce((BuildItem)ChannelBuildItem.incoming(name, null));
        }
    }

    static void produceOutgoingChannel(BuildProducer<ChannelBuildItem> producer, String name) {
        Optional<String> managingConnector = WiringHelper.getManagingConnector(ChannelDirection.OUTGOING, name);
        if (managingConnector.isPresent()) {
            if (WiringHelper.isChannelEnabled(ChannelDirection.OUTGOING, name)) {
                producer.produce((BuildItem)ChannelBuildItem.outgoing(name, managingConnector.get()));
            }
        } else {
            producer.produce((BuildItem)ChannelBuildItem.outgoing(name, null));
        }
    }

    static Optional<String> getManagingConnector(ChannelDirection direction, String channel) {
        return ConfigProvider.getConfig().getOptionalValue("mp.messaging." + direction.name().toLowerCase() + "." + channel + ".connector", String.class);
    }

    static boolean isChannelEnabled(ChannelDirection direction, String channel) {
        return ConfigProvider.getConfig().getOptionalValue("mp.messaging." + direction.name().toLowerCase() + "." + channel + ".enabled", Boolean.class).orElse(true);
    }

    static boolean isInboundConnector(ClassInfo ci) {
        return ci.interfaceNames().contains(ReactiveMessagingDotNames.INCOMING_CONNECTOR_FACTORY);
    }

    static boolean isOutboundConnector(ClassInfo ci) {
        return ci.interfaceNames().contains(ReactiveMessagingDotNames.OUTGOING_CONNECTOR_FACTORY);
    }

    static List<ConnectorAttribute> getConnectorAttributes(BeanInfo bi, CombinedIndexBuildItem index, ConnectorAttribute.Direction ... directions) {
        AnnotationInstance attribute;
        List<Object> attributes = bi.getImplClazz().classAnnotationsWithRepeatable(ReactiveMessagingDotNames.CONNECTOR_ATTRIBUTES, index.getIndex()).stream().flatMap(ai -> Arrays.stream(ai.value().asNestedArray())).collect(Collectors.toList());
        if (attributes.isEmpty() && (attribute = bi.getImplClazz().classAnnotation(ReactiveMessagingDotNames.CONNECTOR_ATTRIBUTE)) != null) {
            attributes = Collections.singletonList(attribute);
        }
        ArrayList<ConnectorAttribute> att = new ArrayList<ConnectorAttribute>();
        for (AnnotationInstance instance : attributes) {
            ConnectorAttribute.Direction direction = ConnectorAttribute.Direction.valueOf((String)instance.value("direction").asString().toUpperCase());
            if (!Arrays.asList(directions).contains(direction)) continue;
            ConnectorAttribute literal = WiringHelper.createConnectorAttribute(instance, direction);
            att.add(literal);
        }
        return att;
    }

    private static ConnectorAttribute createConnectorAttribute(AnnotationInstance instance, ConnectorAttribute.Direction direction) {
        String name = instance.value("name").asString();
        String type = instance.value("type").asString();
        String description = instance.value("description").asString();
        boolean hidden = WiringHelper.getBooleanValueOrDefault(instance, "hidden");
        boolean mandatory = WiringHelper.getBooleanValueOrDefault(instance, "hidden");
        boolean deprecated = WiringHelper.getBooleanValueOrDefault(instance, "deprecated");
        String defaultValue = WiringHelper.getStringValueOrDefault(instance, "defaultValue");
        String alias = WiringHelper.getStringValueOrDefault(instance, "alias");
        return ConnectorAttributeLiteral.create(name, description, hidden, mandatory, direction, defaultValue, deprecated, alias, type);
    }

    private static String getStringValueOrDefault(AnnotationInstance instance, String attribute) {
        AnnotationValue value = instance.value(attribute);
        if (value != null) {
            return value.asString();
        }
        return "<no-value>";
    }

    private static boolean getBooleanValueOrDefault(AnnotationInstance instance, String attribute) {
        AnnotationValue value = instance.value(attribute);
        if (value != null) {
            return value.asBoolean();
        }
        return false;
    }

    static ConnectorBuildItem find(List<ConnectorBuildItem> connectors, String name, ChannelDirection direction) {
        for (ConnectorBuildItem connector : connectors) {
            if (connector.getDirection() != direction || !connector.getName().equalsIgnoreCase(name)) continue;
            return connector;
        }
        return null;
    }

    static boolean hasConnector(List<ConnectorBuildItem> connectors, ChannelDirection direction, String name) {
        return connectors.stream().anyMatch(c -> c.getName().equalsIgnoreCase(name) && c.getDirection() == direction);
    }

    static Class<?> toType(String type) throws ClassNotFoundException {
        if (type.equalsIgnoreCase("string")) {
            return String.class;
        }
        if (type.equalsIgnoreCase("int")) {
            return Integer.class;
        }
        if (type.equalsIgnoreCase("long")) {
            return Long.class;
        }
        if (type.equalsIgnoreCase("boolean")) {
            return Boolean.class;
        }
        return WiringHelper.class.getClassLoader().loadClass(type);
    }

    static boolean isSynthetic(MethodInfo method) {
        short flag = method.flags();
        return (flag & 0x1000) != 0;
    }

    static Optional<AnnotationInstance> getAnnotation(TransformedAnnotationsBuildItem transformedAnnotations, InjectionPointInfo injectionPoint, DotName annotationName) {
        Collection annotations = transformedAnnotations.getAnnotations(injectionPoint.getTarget());
        for (AnnotationInstance annotation : annotations) {
            if (!annotationName.equals((Object)annotation.name())) continue;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER && injectionPoint.isParam() && annotation.target().asMethodParameter().position() == injectionPoint.getPosition()) {
                return Optional.of(annotation);
            }
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }
}

