/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.kafka.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.DefaultSerdeDiscoveryState;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.DotNames;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.ReactiveMessagingKafkaBuildTimeConfig;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.consumer.impl.KafkaReadStreamImpl;
import io.vertx.kafka.client.serialization.BufferDeserializer;
import io.vertx.kafka.client.serialization.BufferSerializer;
import io.vertx.kafka.client.serialization.JsonArrayDeserializer;
import io.vertx.kafka.client.serialization.JsonArraySerializer;
import io.vertx.kafka.client.serialization.JsonObjectDeserializer;
import io.vertx.kafka.client.serialization.JsonObjectSerializer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.ByteBufferSerializer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.FloatDeserializer;
import org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.ShortDeserializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.serialization.UUIDDeserializer;
import org.apache.kafka.common.serialization.UUIDSerializer;
import org.apache.kafka.common.serialization.VoidDeserializer;
import org.apache.kafka.common.serialization.VoidSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class SmallRyeReactiveMessagingKafkaProcessor {
    private static final Map<DotName, String> KNOWN_DESERIALIZERS = Map.ofEntries(Map.entry(DotName.createSimple((String)"short"), ShortDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"int"), IntegerDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"long"), LongDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"float"), FloatDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"double"), DoubleDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Short.class.getName()), ShortDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Integer.class.getName()), IntegerDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Long.class.getName()), LongDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Float.class.getName()), FloatDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Double.class.getName()), DoubleDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"[B"), ByteArrayDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Void.class.getName()), VoidDeserializer.class.getName()), Map.entry(DotName.createSimple((String)String.class.getName()), StringDeserializer.class.getName()), Map.entry(DotName.createSimple((String)UUID.class.getName()), UUIDDeserializer.class.getName()), Map.entry(DotName.createSimple((String)ByteBuffer.class.getName()), ByteBufferDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Bytes.class.getName()), BytesDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Buffer.class.getName()), BufferDeserializer.class.getName()), Map.entry(DotName.createSimple((String)JsonObject.class.getName()), JsonObjectDeserializer.class.getName()), Map.entry(DotName.createSimple((String)JsonArray.class.getName()), JsonArrayDeserializer.class.getName()));
    private static final Map<DotName, String> KNOWN_SERIALIZERS = Map.ofEntries(Map.entry(DotName.createSimple((String)"short"), ShortSerializer.class.getName()), Map.entry(DotName.createSimple((String)"int"), IntegerSerializer.class.getName()), Map.entry(DotName.createSimple((String)"long"), LongSerializer.class.getName()), Map.entry(DotName.createSimple((String)"float"), FloatSerializer.class.getName()), Map.entry(DotName.createSimple((String)"double"), DoubleSerializer.class.getName()), Map.entry(DotName.createSimple((String)Short.class.getName()), ShortSerializer.class.getName()), Map.entry(DotName.createSimple((String)Integer.class.getName()), IntegerSerializer.class.getName()), Map.entry(DotName.createSimple((String)Long.class.getName()), LongSerializer.class.getName()), Map.entry(DotName.createSimple((String)Float.class.getName()), FloatSerializer.class.getName()), Map.entry(DotName.createSimple((String)Double.class.getName()), DoubleSerializer.class.getName()), Map.entry(DotName.createSimple((String)"[B"), ByteArraySerializer.class.getName()), Map.entry(DotName.createSimple((String)Void.class.getName()), VoidSerializer.class.getName()), Map.entry(DotName.createSimple((String)String.class.getName()), StringSerializer.class.getName()), Map.entry(DotName.createSimple((String)UUID.class.getName()), UUIDSerializer.class.getName()), Map.entry(DotName.createSimple((String)ByteBuffer.class.getName()), ByteBufferSerializer.class.getName()), Map.entry(DotName.createSimple((String)Bytes.class.getName()), BytesSerializer.class.getName()), Map.entry(DotName.createSimple((String)Buffer.class.getName()), BufferSerializer.class.getName()), Map.entry(DotName.createSimple((String)JsonObject.class.getName()), JsonObjectSerializer.class.getName()), Map.entry(DotName.createSimple((String)JsonArray.class.getName()), JsonArraySerializer.class.getName()));

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SMALLRYE_REACTIVE_MESSAGING_KAFKA);
    }

    @BuildStep
    public void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{KafkaReadStreamImpl.class}).fields(true).methods(true).constructors(true).finalFieldsWritable(true).build());
    }

    @BuildStep
    public void defaultSerdeConfig(ReactiveMessagingKafkaBuildTimeConfig buildTimeConfig, CombinedIndexBuildItem combinedIndex, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigProducer) {
        if (!buildTimeConfig.serializerAutodetectionEnabled) {
            return;
        }
        DefaultSerdeDiscoveryState discoveryState = new DefaultSerdeDiscoveryState(combinedIndex.getIndex());
        this.discoverDefaultSerdeConfig(discoveryState, defaultConfigProducer);
    }

    void discoverDefaultSerdeConfig(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config) {
        MethodInfo method;
        String channelName;
        for (AnnotationInstance annotation : discovery.findAnnotationsOnMethods(DotNames.INCOMING)) {
            channelName = annotation.value().asString();
            if (!discovery.isKafkaConnector(true, channelName)) continue;
            method = annotation.target().asMethod();
            this.processIncomingMethod(discovery, method, (keyDeserializer, valueDeserializer) -> {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.incoming." + channelName + ".key.deserializer", (String)keyDeserializer);
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.incoming." + channelName + ".value.deserializer", (String)valueDeserializer);
            });
        }
        for (AnnotationInstance annotation : discovery.findAnnotationsOnMethods(DotNames.OUTGOING)) {
            channelName = annotation.value().asString();
            if (!discovery.isKafkaConnector(false, channelName)) continue;
            method = annotation.target().asMethod();
            this.processOutgoingMethod(discovery, method, (keySerializer, valueSerializer) -> {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.outgoing." + channelName + ".key.serializer", (String)keySerializer);
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.outgoing." + channelName + ".value.serializer", (String)valueSerializer);
            });
        }
        block6: for (AnnotationInstance annotation : discovery.findAnnotationsOnInjectionPoints(DotNames.CHANNEL)) {
            Type injectionPointType;
            channelName = annotation.value().asString();
            if (!discovery.isKafkaConnector(false, channelName) && !discovery.isKafkaConnector(true, channelName)) continue;
            switch (annotation.target().kind()) {
                case FIELD: {
                    injectionPointType = annotation.target().asField().type();
                    break;
                }
                case METHOD_PARAMETER: {
                    MethodParameterInfo parameter = annotation.target().asMethodParameter();
                    injectionPointType = (Type)parameter.method().parameters().get(parameter.position());
                    break;
                }
                default: {
                    continue block6;
                }
            }
            this.processIncomingChannelInjectionPoint(discovery, injectionPointType, (keyDeserializer, valueDeserializer) -> {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.incoming." + channelName + ".key.deserializer", (String)keyDeserializer);
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.incoming." + channelName + ".value.deserializer", (String)valueDeserializer);
            });
            this.processOutgoingChannelInjectionPoint(discovery, injectionPointType, (keySerializer, valueSerializer) -> {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.outgoing." + channelName + ".key.serializer", (String)keySerializer);
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.outgoing." + channelName + ".value.serializer", (String)valueSerializer);
            });
        }
    }

    void produceRuntimeConfigurationDefaultBuildItem(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, String key, String value) {
        discovery.runIfConfigIsAbsent(key, value, () -> config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(key, value)));
    }

    private void processIncomingMethod(DefaultSerdeDiscoveryState discovery, MethodInfo method, BiConsumer<String, String> deserializerAcceptor) {
        List parameterTypes = method.parameters();
        int parametersCount = parameterTypes.size();
        Type returnType = method.returnType();
        Type incomingType = null;
        if (SmallRyeReactiveMessagingKafkaProcessor.isVoid(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount == 1) {
            incomingType = (Type)parameterTypes.get(0);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isSubscriber(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isSubscriberBuilder(returnType) && parametersCount == 0) {
            incomingType = (Type)returnType.asParameterizedType().arguments().get(0);
        }
        if (method.hasAnnotation(DotNames.OUTGOING)) {
            if (SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisher(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isMulti(returnType) && parametersCount == 1) {
                incomingType = (Type)parameterTypes.get(0);
            } else if (SmallRyeReactiveMessagingKafkaProcessor.isProcessor(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isProcessorBuilder(returnType) && parametersCount == 0) {
                incomingType = (Type)returnType.asParameterizedType().arguments().get(0);
            } else if (parametersCount == 1) {
                incomingType = (Type)parameterTypes.get(0);
            }
            if (incomingType != null && (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(incomingType) || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(incomingType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(incomingType))) {
                incomingType = (Type)incomingType.asParameterizedType().arguments().get(0);
            }
        }
        this.processIncomingType(discovery, incomingType, deserializerAcceptor);
    }

    private void processIncomingChannelInjectionPoint(DefaultSerdeDiscoveryState discovery, Type injectionPointType, BiConsumer<String, String> deserializerAcceptor) {
        Type incomingType = null;
        if (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(injectionPointType)) {
            incomingType = (Type)injectionPointType.asParameterizedType().arguments().get(0);
        }
        this.processIncomingType(discovery, incomingType, deserializerAcceptor);
    }

    private void processIncomingType(DefaultSerdeDiscoveryState discovery, Type incomingType, BiConsumer<String, String> deserializerAcceptor) {
        if (incomingType == null) {
            return;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isMessage(incomingType)) {
            List typeArguments = incomingType.asParameterizedType().arguments();
            String deserializer = this.deserializerFor(discovery, (Type)typeArguments.get(0));
            deserializerAcceptor.accept(null, deserializer);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isKafkaRecord(incomingType) || SmallRyeReactiveMessagingKafkaProcessor.isRecord(incomingType) || SmallRyeReactiveMessagingKafkaProcessor.isConsumerRecord(incomingType)) {
            List typeArguments = incomingType.asParameterizedType().arguments();
            String keyDeserializer = this.deserializerFor(discovery, (Type)typeArguments.get(0));
            String valueDeserializer = this.deserializerFor(discovery, (Type)typeArguments.get(1));
            deserializerAcceptor.accept(keyDeserializer, valueDeserializer);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isRawMessage(incomingType)) {
            String deserializer = this.deserializerFor(discovery, incomingType);
            deserializerAcceptor.accept(null, deserializer);
        }
    }

    private void processOutgoingMethod(DefaultSerdeDiscoveryState discovery, MethodInfo method, BiConsumer<String, String> serializerAcceptor) {
        List parameterTypes = method.parameters();
        int parametersCount = parameterTypes.size();
        Type returnType = method.returnType();
        Type outgoingType = null;
        if (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isMulti(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount == 0) {
            outgoingType = (Type)returnType.asParameterizedType().arguments().get(0);
        } else if (parametersCount == 0) {
            outgoingType = returnType;
        }
        if (method.hasAnnotation(DotNames.INCOMING)) {
            if (SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisher(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isMulti(returnType) && parametersCount == 1) {
                outgoingType = (Type)returnType.asParameterizedType().arguments().get(0);
            } else if (SmallRyeReactiveMessagingKafkaProcessor.isProcessor(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isProcessorBuilder(returnType) && parametersCount == 0) {
                outgoingType = (Type)returnType.asParameterizedType().arguments().get(1);
            } else if (parametersCount == 1) {
                outgoingType = returnType;
            }
            if (outgoingType != null && (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(outgoingType) || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(outgoingType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(outgoingType))) {
                outgoingType = (Type)outgoingType.asParameterizedType().arguments().get(0);
            }
        }
        this.processOutgoingType(discovery, outgoingType, serializerAcceptor);
    }

    private void processOutgoingChannelInjectionPoint(DefaultSerdeDiscoveryState discovery, Type injectionPointType, BiConsumer<String, String> serializerAcceptor) {
        Type outgoingType = null;
        if (SmallRyeReactiveMessagingKafkaProcessor.isEmitter(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isMutinyEmitter(injectionPointType)) {
            outgoingType = (Type)injectionPointType.asParameterizedType().arguments().get(0);
        }
        this.processOutgoingType(discovery, outgoingType, serializerAcceptor);
    }

    private void processOutgoingType(DefaultSerdeDiscoveryState discovery, Type outgoingType, BiConsumer<String, String> serializerAcceptor) {
        if (outgoingType == null) {
            return;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isMessage(outgoingType)) {
            List typeArguments = outgoingType.asParameterizedType().arguments();
            String serializer = this.serializerFor(discovery, (Type)typeArguments.get(0));
            serializerAcceptor.accept(null, serializer);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isKafkaRecord(outgoingType) || SmallRyeReactiveMessagingKafkaProcessor.isRecord(outgoingType) || SmallRyeReactiveMessagingKafkaProcessor.isProducerRecord(outgoingType)) {
            List typeArguments = outgoingType.asParameterizedType().arguments();
            String keySerializer = this.serializerFor(discovery, (Type)typeArguments.get(0));
            String valueSerializer = this.serializerFor(discovery, (Type)typeArguments.get(1));
            serializerAcceptor.accept(keySerializer, valueSerializer);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isRawMessage(outgoingType)) {
            String serializer = this.serializerFor(discovery, outgoingType);
            serializerAcceptor.accept(null, serializer);
        }
    }

    private static boolean isVoid(Type type) {
        return type.kind() == Type.Kind.VOID;
    }

    private static boolean isCompletionStage(Type type) {
        return DotNames.COMPLETION_STAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isUni(Type type) {
        return DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMulti(Type type) {
        return DotNames.MULTI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isSubscriber(Type type) {
        return DotNames.SUBSCRIBER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isSubscriberBuilder(Type type) {
        return DotNames.SUBSCRIBER_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isPublisher(Type type) {
        return DotNames.PUBLISHER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isPublisherBuilder(Type type) {
        return DotNames.PUBLISHER_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isProcessor(Type type) {
        return DotNames.PROCESSOR.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isProcessorBuilder(Type type) {
        return DotNames.PROCESSOR_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isEmitter(Type type) {
        return DotNames.EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMutinyEmitter(Type type) {
        return DotNames.MUTINY_EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMessage(Type type) {
        return DotNames.MESSAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isKafkaRecord(Type type) {
        return DotNames.KAFKA_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isRecord(Type type) {
        return DotNames.RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isConsumerRecord(Type type) {
        return DotNames.CONSUMER_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isProducerRecord(Type type) {
        return DotNames.PRODUCER_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isRawMessage(Type type) {
        switch (type.kind()) {
            case PRIMITIVE: 
            case CLASS: 
            case ARRAY: {
                return true;
            }
        }
        return false;
    }

    private String deserializerFor(DefaultSerdeDiscoveryState discovery, Type type) {
        return this.serializerDeserializerFor(discovery, type, false);
    }

    private String serializerFor(DefaultSerdeDiscoveryState discovery, Type type) {
        return this.serializerDeserializerFor(discovery, type, true);
    }

    private String serializerDeserializerFor(DefaultSerdeDiscoveryState discovery, Type type, boolean serializer) {
        ClassInfo subclass;
        Map<DotName, String> map;
        DotName typeName = type.name();
        Map<DotName, String> map2 = map = serializer ? KNOWN_SERIALIZERS : KNOWN_DESERIALIZERS;
        if (map.containsKey(typeName)) {
            return map.get(typeName);
        }
        if (discovery.isAvroGenerated(typeName)) {
            if (discovery.hasConfluent()) {
                return serializer ? "io.confluent.kafka.serializers.KafkaAvroSerializer" : "io.confluent.kafka.serializers.KafkaAvroDeserializer";
            }
            if (discovery.hasApicurio1()) {
                return serializer ? "io.apicurio.registry.utils.serde.AvroKafkaSerializer" : "io.apicurio.registry.utils.serde.AvroKafkaDeserializer";
            }
            if (discovery.hasApicurio2()) {
                return serializer ? "io.apicurio.registry.serde.avro.AvroKafkaSerializer" : "io.apicurio.registry.serde.avro.AvroKafkaDeserializer";
            }
        }
        if ((subclass = discovery.getSubclassOfWithTypeArgument(serializer ? DotNames.OBJECT_MAPPER_SERIALIZER : DotNames.OBJECT_MAPPER_DESERIALIZER, typeName)) != null) {
            return subclass.name().toString();
        }
        if (discovery.hasJsonb() && (subclass = discovery.getSubclassOfWithTypeArgument(serializer ? DotNames.JSONB_SERIALIZER : DotNames.JSONB_DESERIALIZER, typeName)) != null) {
            return subclass.name().toString();
        }
        return null;
    }
}

