/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.kafka.deployment;

import io.quarkus.smallrye.reactivemessaging.deployment.items.ChannelDirection;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ConnectorManagedChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.DotNames;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

class DefaultSerdeDiscoveryState {
    private final IndexView index;
    private final Map<String, Boolean> isKafkaConnector = new HashMap<String, Boolean>();
    private final Set<String> alreadyConfigured = new HashSet<String>();
    private Boolean connectorHasKeySerializer;
    private Boolean connectorHasValueSerializer;
    private Boolean connectorHasKeyDeserializer;
    private Boolean connectorHasValueDeserializer;
    private Boolean hasConfluent;
    private Boolean hasApicurio1;
    private Boolean hasApicurio2;
    private Boolean hasJsonb;

    DefaultSerdeDiscoveryState(IndexView index) {
        this.index = index;
    }

    Config getConfig() {
        return ConfigProvider.getConfig();
    }

    boolean isKafkaConnector(List<ConnectorManagedChannelBuildItem> channelsManagedByConnectors, boolean incoming, String channelName) {
        Optional<ConnectorManagedChannelBuildItem> match = channelsManagedByConnectors.stream().filter(cn -> cn.getDirection() == (incoming ? ChannelDirection.INCOMING : ChannelDirection.OUTGOING) && cn.getName().equalsIgnoreCase(channelName)).findFirst();
        if (match.isPresent()) {
            return true;
        }
        String channelType = incoming ? "incoming" : "outgoing";
        return this.isKafkaConnector.computeIfAbsent(channelType + "|" + channelName, ignored -> {
            String connectorKey = "mp.messaging." + channelType + "." + channelName + ".connector";
            String connector = this.getConfig().getOptionalValue(connectorKey, String.class).orElse("ignored");
            return "smallrye-kafka".equals(connector);
        });
    }

    boolean shouldNotConfigure(String key) {
        if (key.startsWith("mp.messaging.outgoing.") && key.endsWith(".key.serializer")) {
            if (this.connectorHasKeySerializer == null) {
                this.connectorHasKeySerializer = this.getConfig().getOptionalValue("mp.messaging.connector.smallrye-kafka.key.serializer", String.class).isPresent();
            }
            return this.connectorHasKeySerializer;
        }
        if (key.startsWith("mp.messaging.outgoing.") && key.endsWith(".value.serializer")) {
            if (this.connectorHasValueSerializer == null) {
                this.connectorHasValueSerializer = this.getConfig().getOptionalValue("mp.messaging.connector.smallrye-kafka.value.serializer", String.class).isPresent();
            }
            return this.connectorHasValueSerializer;
        }
        if (key.startsWith("mp.messaging.incoming.") && key.endsWith(".key.deserializer")) {
            if (this.connectorHasKeyDeserializer == null) {
                this.connectorHasKeyDeserializer = this.getConfig().getOptionalValue("mp.messaging.connector.smallrye-kafka.key.deserializer", String.class).isPresent();
            }
            return this.connectorHasKeyDeserializer;
        }
        if (key.startsWith("mp.messaging.incoming.") && key.endsWith(".value.deserializer")) {
            if (this.connectorHasValueDeserializer == null) {
                this.connectorHasValueDeserializer = this.getConfig().getOptionalValue("mp.messaging.connector.smallrye-kafka.value.deserializer", String.class).isPresent();
            }
            return this.connectorHasValueDeserializer;
        }
        return false;
    }

    void ifNotYetConfigured(String key, Runnable runnable) {
        if (!this.alreadyConfigured.contains(key)) {
            this.alreadyConfigured.add(key);
            runnable.run();
        }
    }

    boolean isAvroGenerated(DotName className) {
        ClassInfo clazz = this.index.getClassByName(className);
        return clazz != null && clazz.declaredAnnotation(DotNames.AVRO_GENERATED) != null;
    }

    boolean hasConfluent() {
        if (this.hasConfluent == null) {
            try {
                Class.forName("io.confluent.kafka.serializers.KafkaAvroDeserializer", false, Thread.currentThread().getContextClassLoader());
                this.hasConfluent = true;
            }
            catch (ClassNotFoundException e) {
                this.hasConfluent = false;
            }
        }
        return this.hasConfluent;
    }

    boolean hasApicurio1() {
        if (this.hasApicurio1 == null) {
            try {
                Class.forName("io.apicurio.registry.utils.serde.AvroKafkaDeserializer", false, Thread.currentThread().getContextClassLoader());
                this.hasApicurio1 = true;
            }
            catch (ClassNotFoundException e) {
                this.hasApicurio1 = false;
            }
        }
        return this.hasApicurio1;
    }

    boolean hasApicurio2() {
        if (this.hasApicurio2 == null) {
            try {
                Class.forName("io.apicurio.registry.serde.avro.AvroKafkaDeserializer", false, Thread.currentThread().getContextClassLoader());
                this.hasApicurio2 = true;
            }
            catch (ClassNotFoundException e) {
                this.hasApicurio2 = false;
            }
        }
        return this.hasApicurio2;
    }

    boolean hasJsonb() {
        if (this.hasJsonb == null) {
            try {
                Class.forName("javax.json.bind.Jsonb", false, Thread.currentThread().getContextClassLoader());
                this.hasJsonb = true;
            }
            catch (ClassNotFoundException e) {
                this.hasJsonb = false;
            }
        }
        return this.hasJsonb;
    }

    ClassInfo getSubclassOfWithTypeArgument(DotName superclass, DotName expectedTypeArgument) {
        return this.index.getKnownDirectSubclasses(superclass).stream().filter(it -> it.superClassType().kind() == Type.Kind.PARAMETERIZED_TYPE && it.superClassType().asParameterizedType().arguments().size() == 1 && ((Type)it.superClassType().asParameterizedType().arguments().get(0)).name().equals((Object)expectedTypeArgument)).findAny().orElse(null);
    }

    ClassInfo getImplementorOfWithTypeArgument(DotName implementedInterface, DotName expectedTypeArgument) {
        return this.index.getKnownDirectImplementors(implementedInterface).stream().filter(ci -> ci.interfaceTypes().stream().anyMatch(it -> it.name().equals((Object)implementedInterface) && it.kind() == Type.Kind.PARAMETERIZED_TYPE && it.asParameterizedType().arguments().size() == 1 && ((Type)it.asParameterizedType().arguments().get(0)).name().equals((Object)expectedTypeArgument))).findAny().orElse(null);
    }

    List<AnnotationInstance> findAnnotationsOnMethods(DotName annotation) {
        return this.index.getAnnotations(annotation).stream().filter(it -> it.target().kind() == AnnotationTarget.Kind.METHOD).collect(Collectors.toList());
    }

    List<AnnotationInstance> findAnnotationsOnInjectionPoints(DotName annotation) {
        return this.index.getAnnotations(annotation).stream().filter(it -> it.target().kind() == AnnotationTarget.Kind.FIELD || it.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.toList());
    }
}

