/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.kafka.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.smallrye.reactivemessaging.kafka.ReactiveMessagingKafkaConfig;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.DefaultSerdeDiscoveryState;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.DotNames;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.ReactiveMessagingKafkaBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.Result;
import io.smallrye.mutiny.tuples.Functions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.consumer.impl.KafkaReadStreamImpl;
import io.vertx.kafka.client.serialization.BufferDeserializer;
import io.vertx.kafka.client.serialization.BufferSerializer;
import io.vertx.kafka.client.serialization.JsonArrayDeserializer;
import io.vertx.kafka.client.serialization.JsonArraySerializer;
import io.vertx.kafka.client.serialization.JsonObjectDeserializer;
import io.vertx.kafka.client.serialization.JsonObjectSerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.ByteBufferSerializer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.FloatDeserializer;
import org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.ShortDeserializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.serialization.UUIDDeserializer;
import org.apache.kafka.common.serialization.UUIDSerializer;
import org.apache.kafka.common.serialization.VoidDeserializer;
import org.apache.kafka.common.serialization.VoidSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class SmallRyeReactiveMessagingKafkaProcessor {
    private static final Map<DotName, String> KNOWN_DESERIALIZERS = Map.ofEntries(Map.entry(DotName.createSimple((String)"short"), ShortDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"int"), IntegerDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"long"), LongDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"float"), FloatDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"double"), DoubleDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Short.class.getName()), ShortDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Integer.class.getName()), IntegerDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Long.class.getName()), LongDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Float.class.getName()), FloatDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Double.class.getName()), DoubleDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"[B"), ByteArrayDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Void.class.getName()), VoidDeserializer.class.getName()), Map.entry(DotName.createSimple((String)String.class.getName()), StringDeserializer.class.getName()), Map.entry(DotName.createSimple((String)UUID.class.getName()), UUIDDeserializer.class.getName()), Map.entry(DotName.createSimple((String)ByteBuffer.class.getName()), ByteBufferDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Bytes.class.getName()), BytesDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Buffer.class.getName()), BufferDeserializer.class.getName()), Map.entry(DotName.createSimple((String)JsonObject.class.getName()), JsonObjectDeserializer.class.getName()), Map.entry(DotName.createSimple((String)JsonArray.class.getName()), JsonArrayDeserializer.class.getName()));
    private static final Map<DotName, String> KNOWN_SERIALIZERS = Map.ofEntries(Map.entry(DotName.createSimple((String)"short"), ShortSerializer.class.getName()), Map.entry(DotName.createSimple((String)"int"), IntegerSerializer.class.getName()), Map.entry(DotName.createSimple((String)"long"), LongSerializer.class.getName()), Map.entry(DotName.createSimple((String)"float"), FloatSerializer.class.getName()), Map.entry(DotName.createSimple((String)"double"), DoubleSerializer.class.getName()), Map.entry(DotName.createSimple((String)Short.class.getName()), ShortSerializer.class.getName()), Map.entry(DotName.createSimple((String)Integer.class.getName()), IntegerSerializer.class.getName()), Map.entry(DotName.createSimple((String)Long.class.getName()), LongSerializer.class.getName()), Map.entry(DotName.createSimple((String)Float.class.getName()), FloatSerializer.class.getName()), Map.entry(DotName.createSimple((String)Double.class.getName()), DoubleSerializer.class.getName()), Map.entry(DotName.createSimple((String)"[B"), ByteArraySerializer.class.getName()), Map.entry(DotName.createSimple((String)Void.class.getName()), VoidSerializer.class.getName()), Map.entry(DotName.createSimple((String)String.class.getName()), StringSerializer.class.getName()), Map.entry(DotName.createSimple((String)UUID.class.getName()), UUIDSerializer.class.getName()), Map.entry(DotName.createSimple((String)ByteBuffer.class.getName()), ByteBufferSerializer.class.getName()), Map.entry(DotName.createSimple((String)Bytes.class.getName()), BytesSerializer.class.getName()), Map.entry(DotName.createSimple((String)Buffer.class.getName()), BufferSerializer.class.getName()), Map.entry(DotName.createSimple((String)JsonObject.class.getName()), JsonObjectSerializer.class.getName()), Map.entry(DotName.createSimple((String)JsonArray.class.getName()), JsonArraySerializer.class.getName()));

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SMALLRYE_REACTIVE_MESSAGING_KAFKA);
    }

    @BuildStep
    public void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{KafkaReadStreamImpl.class}).fields(true).methods(true).constructors(true).finalFieldsWritable(true).build());
    }

    @BuildStep
    public void ignoreDuplicateJmxRegistrationInDevAndTestModes(LaunchModeBuildItem launchMode, BuildProducer<LogCleanupFilterBuildItem> log) {
        if (launchMode.getLaunchMode().isDevOrTest()) {
            log.produce((BuildItem)new LogCleanupFilterBuildItem("org.apache.kafka.common.utils.AppInfoParser", new String[]{"Error registering AppInfo mbean"}));
        }
    }

    @BuildStep
    public void defaultChannelConfiguration(LaunchModeBuildItem launchMode, ReactiveMessagingKafkaBuildTimeConfig buildTimeConfig, ReactiveMessagingKafkaConfig runtimeConfig, CombinedIndexBuildItem combinedIndex, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigProducer) {
        DefaultSerdeDiscoveryState discoveryState = new DefaultSerdeDiscoveryState(combinedIndex.getIndex());
        if (buildTimeConfig.serializerAutodetectionEnabled) {
            this.discoverDefaultSerdeConfig(discoveryState, defaultConfigProducer);
        }
        if (launchMode.getLaunchMode().isDevOrTest() && !runtimeConfig.enableGracefulShutdownInDevAndTestMode) {
            List<AnnotationInstance> incomings = discoveryState.findAnnotationsOnMethods(DotNames.INCOMING);
            List<AnnotationInstance> channels = discoveryState.findAnnotationsOnInjectionPoints(DotNames.CHANNEL);
            ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>();
            annotations.addAll(incomings);
            annotations.addAll(channels);
            for (AnnotationInstance annotation : annotations) {
                String channelName = annotation.value().asString();
                if (!discoveryState.isKafkaConnector(true, channelName)) continue;
                String key = "mp.messaging.incoming." + channelName + ".graceful-shutdown";
                discoveryState.ifNotYetConfigured(key, () -> defaultConfigProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(key, "false")));
            }
        }
    }

    void discoverDefaultSerdeConfig(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config) {
        Type incomingType;
        MethodInfo method;
        String channelName;
        for (AnnotationInstance annotation : discovery.findAnnotationsOnMethods(DotNames.INCOMING)) {
            channelName = annotation.value().asString();
            if (!discovery.isKafkaConnector(true, channelName)) continue;
            method = annotation.target().asMethod();
            incomingType = this.getIncomingTypeFromMethod(method);
            this.processIncomingType(discovery, config, incomingType, channelName);
        }
        for (AnnotationInstance annotation : discovery.findAnnotationsOnMethods(DotNames.OUTGOING)) {
            channelName = annotation.value().asString();
            if (!discovery.isKafkaConnector(false, channelName)) continue;
            method = annotation.target().asMethod();
            Type outgoingType = this.getOutgoingTypeFromMethod(method);
            this.processOutgoingType(discovery, outgoingType, (keySerializer, valueSerializer) -> {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.outgoing." + channelName + ".key.serializer", (Result)keySerializer);
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.outgoing." + channelName + ".value.serializer", (Result)valueSerializer);
                this.handleAdditionalProperties("mp.messaging.outgoing." + channelName + ".", discovery, config, (Result)keySerializer, (Result)valueSerializer);
            });
        }
        for (AnnotationInstance annotation : discovery.findAnnotationsOnInjectionPoints(DotNames.CHANNEL)) {
            Type injectionPointType;
            channelName = annotation.value().asString();
            if (!discovery.isKafkaConnector(false, channelName) && !discovery.isKafkaConnector(true, channelName) || (injectionPointType = this.getInjectionPointType(annotation)) == null) continue;
            incomingType = this.getIncomingTypeFromChannelInjectionPoint(injectionPointType);
            this.processIncomingType(discovery, config, incomingType, channelName);
            Type outgoingType = this.getOutgoingTypeFromChannelInjectionPoint(injectionPointType);
            this.processOutgoingType(discovery, outgoingType, (keySerializer, valueSerializer) -> {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.outgoing." + channelName + ".key.serializer", (Result)keySerializer);
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.outgoing." + channelName + ".value.serializer", (Result)valueSerializer);
                this.handleAdditionalProperties("mp.messaging.outgoing." + channelName + ".", discovery, config, (Result)keySerializer, (Result)valueSerializer);
            });
        }
    }

    private void processIncomingType(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, Type incomingType, String channelName) {
        this.extractKeyValueType(incomingType, (Functions.TriConsumer<Type, Type, Boolean>)((Functions.TriConsumer)(key, value, isBatchType) -> {
            Result keyDeserializer = this.deserializerFor(discovery, (Type)key);
            Result valueDeserializer = this.deserializerFor(discovery, (Type)value);
            this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.incoming." + channelName + ".key.deserializer", keyDeserializer);
            this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.incoming." + channelName + ".value.deserializer", valueDeserializer);
            if (Boolean.TRUE.equals(isBatchType)) {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, "mp.messaging.incoming." + channelName + ".batch", "true");
            }
            this.handleAdditionalProperties("mp.messaging.incoming." + channelName + ".", discovery, config, keyDeserializer, valueDeserializer);
        }));
    }

    private Type getInjectionPointType(AnnotationInstance annotation) {
        switch (annotation.target().kind()) {
            case FIELD: {
                return annotation.target().asField().type();
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = annotation.target().asMethodParameter();
                return (Type)parameter.method().parameters().get(parameter.position());
            }
        }
        return null;
    }

    private void handleAdditionalProperties(String configPropertyBase, DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, Result ... results) {
        for (Result result : results) {
            if (result == null) continue;
            result.additionalProperties.forEach((key, value) -> this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, configPropertyBase + key, (String)value));
        }
    }

    private void produceRuntimeConfigurationDefaultBuildItem(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, String key, Result result) {
        if (result == null) {
            return;
        }
        this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, key, result.value);
    }

    private void produceRuntimeConfigurationDefaultBuildItem(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, String key, String value) {
        if (value == null) {
            return;
        }
        discovery.ifNotYetConfigured(key, () -> config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(key, value)));
    }

    private Type getIncomingTypeFromMethod(MethodInfo method) {
        List parameterTypes = method.parameters();
        int parametersCount = parameterTypes.size();
        Type returnType = method.returnType();
        Type incomingType = null;
        if (SmallRyeReactiveMessagingKafkaProcessor.isVoid(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount == 1) {
            incomingType = (Type)parameterTypes.get(0);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isSubscriber(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isSubscriberBuilder(returnType) && parametersCount == 0) {
            incomingType = (Type)returnType.asParameterizedType().arguments().get(0);
        }
        if (method.hasAnnotation(DotNames.OUTGOING)) {
            if (SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisher(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isMulti(returnType) && parametersCount == 1) {
                incomingType = (Type)parameterTypes.get(0);
            } else if (SmallRyeReactiveMessagingKafkaProcessor.isProcessor(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isProcessorBuilder(returnType) && parametersCount == 0) {
                incomingType = (Type)returnType.asParameterizedType().arguments().get(0);
            } else if (parametersCount == 1) {
                incomingType = (Type)parameterTypes.get(0);
            }
            if (incomingType != null && (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(incomingType) || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(incomingType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(incomingType))) {
                incomingType = (Type)incomingType.asParameterizedType().arguments().get(0);
            }
        }
        return incomingType;
    }

    private Type getIncomingTypeFromChannelInjectionPoint(Type injectionPointType) {
        if (injectionPointType == null) {
            return null;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(injectionPointType)) {
            return (Type)injectionPointType.asParameterizedType().arguments().get(0);
        }
        return null;
    }

    private Type getOutgoingTypeFromMethod(MethodInfo method) {
        List parameterTypes = method.parameters();
        int parametersCount = parameterTypes.size();
        Type returnType = method.returnType();
        Type outgoingType = null;
        if (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isMulti(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount == 0) {
            outgoingType = (Type)returnType.asParameterizedType().arguments().get(0);
        } else if (parametersCount == 0) {
            outgoingType = returnType;
        }
        if (method.hasAnnotation(DotNames.INCOMING)) {
            if (SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisher(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isMulti(returnType) && parametersCount == 1) {
                outgoingType = (Type)returnType.asParameterizedType().arguments().get(0);
            } else if (SmallRyeReactiveMessagingKafkaProcessor.isProcessor(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isProcessorBuilder(returnType) && parametersCount == 0) {
                outgoingType = (Type)returnType.asParameterizedType().arguments().get(1);
            } else if (parametersCount == 1) {
                outgoingType = returnType;
            }
            if (outgoingType != null && (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(outgoingType) || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(outgoingType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(outgoingType))) {
                outgoingType = (Type)outgoingType.asParameterizedType().arguments().get(0);
            }
        }
        return outgoingType;
    }

    private Type getOutgoingTypeFromChannelInjectionPoint(Type injectionPointType) {
        if (injectionPointType == null) {
            return null;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isEmitter(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isMutinyEmitter(injectionPointType)) {
            return (Type)injectionPointType.asParameterizedType().arguments().get(0);
        }
        return null;
    }

    private void processOutgoingType(DefaultSerdeDiscoveryState discovery, Type outgoingType, BiConsumer<Result, Result> serializerAcceptor) {
        this.extractKeyValueType(outgoingType, (Functions.TriConsumer<Type, Type, Boolean>)((Functions.TriConsumer)(key, value, isBatch) -> {
            Result keySerializer = this.serializerFor(discovery, (Type)key);
            Result valueSerializer = this.serializerFor(discovery, (Type)value);
            serializerAcceptor.accept(keySerializer, valueSerializer);
        }));
    }

    private void extractKeyValueType(Type type, Functions.TriConsumer<Type, Type, Boolean> keyValueTypeAcceptor) {
        if (type == null) {
            return;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isMessage(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            Type messageTypeParameter = (Type)typeArguments.get(0);
            if (SmallRyeReactiveMessagingKafkaProcessor.isList(messageTypeParameter)) {
                List messageListTypeArguments = messageTypeParameter.asParameterizedType().arguments();
                keyValueTypeAcceptor.accept(null, (Object)((Type)messageListTypeArguments.get(0)), (Object)true);
            } else {
                keyValueTypeAcceptor.accept(null, (Object)messageTypeParameter, (Object)false);
            }
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isList(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            keyValueTypeAcceptor.accept(null, (Object)((Type)typeArguments.get(0)), (Object)true);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isKafkaRecord(type) || SmallRyeReactiveMessagingKafkaProcessor.isRecord(type) || SmallRyeReactiveMessagingKafkaProcessor.isProducerRecord(type) || SmallRyeReactiveMessagingKafkaProcessor.isConsumerRecord(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            keyValueTypeAcceptor.accept((Object)((Type)typeArguments.get(0)), (Object)((Type)typeArguments.get(1)), (Object)false);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isConsumerRecords(type) || SmallRyeReactiveMessagingKafkaProcessor.isKafkaBatchRecord(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            keyValueTypeAcceptor.accept((Object)((Type)typeArguments.get(0)), (Object)((Type)typeArguments.get(1)), (Object)true);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isRawMessage(type)) {
            keyValueTypeAcceptor.accept(null, (Object)type, (Object)false);
        }
    }

    private static boolean isVoid(Type type) {
        return type.kind() == Type.Kind.VOID;
    }

    private static boolean isCompletionStage(Type type) {
        return DotNames.COMPLETION_STAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isUni(Type type) {
        return DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMulti(Type type) {
        return DotNames.MULTI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isSubscriber(Type type) {
        return DotNames.SUBSCRIBER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isSubscriberBuilder(Type type) {
        return DotNames.SUBSCRIBER_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isPublisher(Type type) {
        return DotNames.PUBLISHER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isPublisherBuilder(Type type) {
        return DotNames.PUBLISHER_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isProcessor(Type type) {
        return DotNames.PROCESSOR.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isProcessorBuilder(Type type) {
        return DotNames.PROCESSOR_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isEmitter(Type type) {
        return DotNames.EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMutinyEmitter(Type type) {
        return DotNames.MUTINY_EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMessage(Type type) {
        return DotNames.MESSAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isKafkaRecord(Type type) {
        return DotNames.KAFKA_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isRecord(Type type) {
        return DotNames.RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isConsumerRecord(Type type) {
        return DotNames.CONSUMER_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isProducerRecord(Type type) {
        return DotNames.PRODUCER_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isList(Type type) {
        return DotNames.LIST.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isKafkaBatchRecord(Type type) {
        return DotNames.KAFKA_BATCH_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isConsumerRecords(Type type) {
        return DotNames.CONSUMER_RECORDS.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isRawMessage(Type type) {
        switch (type.kind()) {
            case PRIMITIVE: 
            case CLASS: 
            case ARRAY: {
                return true;
            }
        }
        return false;
    }

    private Result deserializerFor(DefaultSerdeDiscoveryState discovery, Type type) {
        return this.serializerDeserializerFor(discovery, type, false);
    }

    private Result serializerFor(DefaultSerdeDiscoveryState discovery, Type type) {
        return this.serializerDeserializerFor(discovery, type, true);
    }

    private Result serializerDeserializerFor(DefaultSerdeDiscoveryState discovery, Type type, boolean serializer) {
        ClassInfo subclass;
        Map<DotName, String> map;
        if (type == null) {
            return null;
        }
        DotName typeName = type.name();
        Map<DotName, String> map2 = map = serializer ? KNOWN_SERIALIZERS : KNOWN_DESERIALIZERS;
        if (map.containsKey(typeName)) {
            return Result.of(map.get(typeName));
        }
        boolean isAvroGenerated = discovery.isAvroGenerated(typeName);
        if (isAvroGenerated || DotNames.AVRO_GENERIC_RECORD.equals((Object)typeName)) {
            if (discovery.hasConfluent()) {
                return serializer ? Result.of("io.confluent.kafka.serializers.KafkaAvroSerializer") : Result.of("io.confluent.kafka.serializers.KafkaAvroDeserializer").with(isAvroGenerated, "specific.avro.reader", "true");
            }
            if (discovery.hasApicurio1()) {
                return serializer ? Result.of("io.apicurio.registry.utils.serde.AvroKafkaSerializer") : Result.of("io.apicurio.registry.utils.serde.AvroKafkaDeserializer").with(isAvroGenerated, "apicurio.registry.use-specific-avro-reader", "true");
            }
            if (discovery.hasApicurio2()) {
                return serializer ? Result.of("io.apicurio.registry.serde.avro.AvroKafkaSerializer") : Result.of("io.apicurio.registry.serde.avro.AvroKafkaDeserializer").with(isAvroGenerated, "apicurio.registry.use-specific-avro-reader", "true");
            }
        }
        if ((subclass = discovery.getSubclassOfWithTypeArgument(serializer ? DotNames.OBJECT_MAPPER_SERIALIZER : DotNames.OBJECT_MAPPER_DESERIALIZER, typeName)) != null) {
            return Result.of(subclass.name().toString());
        }
        if (discovery.hasJsonb() && (subclass = discovery.getSubclassOfWithTypeArgument(serializer ? DotNames.JSONB_SERIALIZER : DotNames.JSONB_DESERIALIZER, typeName)) != null) {
            return Result.of(subclass.name().toString());
        }
        return null;
    }

    @BuildStep
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    public void reflectiveValueSerializerPayload(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndex.getIndex();
        Config config = ConfigProvider.getConfig();
        this.processOutgoingForReflectiveClassPayload(index, config, (annotation, payloadType) -> this.produceReflectiveClass(reflectiveClass, (Type)payloadType));
        this.processOutgoingChannelForReflectiveClassPayload(index, config, (annotation, payloadType) -> this.produceReflectiveClass(reflectiveClass, (Type)payloadType));
        this.processIncomingForReflectiveClassPayload(index, config, (annotation, payloadType) -> this.produceReflectiveClass(reflectiveClass, (Type)payloadType));
        this.processIncomingChannelForReflectiveClassPayload(index, config, (annotation, payloadType) -> this.produceReflectiveClass(reflectiveClass, (Type)payloadType));
    }

    void produceReflectiveClass(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Type type) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{type.name().toString()}));
    }

    void processOutgoingForReflectiveClassPayload(IndexView index, Config config, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        this.processAnnotationsForReflectiveClassPayload(index, config, DotNames.OUTGOING, true, annotation -> this.getOutgoingTypeFromMethod(annotation.target().asMethod()), annotationAcceptor);
    }

    void processOutgoingChannelForReflectiveClassPayload(IndexView index, Config config, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        this.processAnnotationsForReflectiveClassPayload(index, config, DotNames.CHANNEL, true, annotation -> this.getOutgoingTypeFromChannelInjectionPoint(this.getInjectionPointType((AnnotationInstance)annotation)), annotationAcceptor);
    }

    void processIncomingForReflectiveClassPayload(IndexView index, Config config, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        this.processAnnotationsForReflectiveClassPayload(index, config, DotNames.INCOMING, false, annotation -> this.getIncomingTypeFromMethod(annotation.target().asMethod()), annotationAcceptor);
    }

    void processIncomingChannelForReflectiveClassPayload(IndexView index, Config config, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        this.processAnnotationsForReflectiveClassPayload(index, config, DotNames.CHANNEL, false, annotation -> this.getIncomingTypeFromChannelInjectionPoint(this.getInjectionPointType((AnnotationInstance)annotation)), annotationAcceptor);
    }

    private void processAnnotationsForReflectiveClassPayload(IndexView index, Config config, DotName annotationType, boolean serializer, Function<AnnotationInstance, Type> typeExtractor, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        for (AnnotationInstance annotation : index.getAnnotations(annotationType)) {
            String channelName = annotation.value().asString();
            Type type = typeExtractor.apply(annotation);
            this.extractKeyValueType(type, (Functions.TriConsumer<Type, Type, Boolean>)((Functions.TriConsumer)(key, value, isBatch) -> {
                if (key != null && this.isSerdeJson(index, config, channelName, serializer, true)) {
                    annotationAcceptor.accept(annotation, (Type)key);
                }
                if (value != null && this.isSerdeJson(index, config, channelName, serializer, false)) {
                    annotationAcceptor.accept(annotation, (Type)value);
                }
            }));
        }
    }

    private boolean isSerdeJson(IndexView index, Config config, String channelName, boolean serializer, boolean isKey) {
        ConfigValue configValue = config.getConfigValue(this.getConfigName(channelName, serializer, isKey));
        if (configValue.getValue() != null) {
            DotName serdeName = DotName.createSimple((String)configValue.getValue());
            return serializer ? this.isSubclassOfJsonSerializer(index, serdeName) : this.isSubclassOfJsonDeserializer(index, serdeName);
        }
        return false;
    }

    String getConfigName(String channelName, boolean serializer, boolean isKey) {
        return "mp.messaging." + (serializer ? "outgoing" : "incoming") + "." + channelName + "." + (isKey ? "key" : "value") + "." + (serializer ? "serializer" : "deserializer");
    }

    private boolean isSubclassOfJsonSerializer(IndexView index, DotName serializerName) {
        return this.isSubclassOf(index, DotNames.OBJECT_MAPPER_SERIALIZER, serializerName) || this.isSubclassOf(index, DotNames.JSONB_SERIALIZER, serializerName);
    }

    private boolean isSubclassOfJsonDeserializer(IndexView index, DotName serializerName) {
        return this.isSubclassOf(index, DotNames.OBJECT_MAPPER_DESERIALIZER, serializerName) || this.isSubclassOf(index, DotNames.JSONB_DESERIALIZER, serializerName);
    }

    private boolean isSubclassOf(IndexView index, DotName superclass, DotName expectedType) {
        if (superclass.equals((Object)expectedType)) {
            return true;
        }
        return index.getKnownDirectSubclasses(superclass).stream().anyMatch(ci -> ci.name().equals((Object)expectedType));
    }
}

