/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.kafka.deployment;

import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.kafka.client.serialization.ObjectMapperDeserializer;
import io.quarkus.kafka.client.serialization.ObjectMapperSerializer;
import io.quarkus.runtime.util.HashUtil;
import java.util.UUID;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class JacksonSerdeGenerator {
    private JacksonSerdeGenerator() {
    }

    public static String generateSerializer(BuildProducer<GeneratedClassBuildItem> generatedClass, Type type) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        String baseName = type.name().withoutPackagePrefix();
        String targetPackage = DotNames.internalPackageNameWithTrailingSlash((DotName)type.name());
        String out = baseName + "_Serializer_" + HashUtil.sha1((String)UUID.randomUUID().toString());
        String generatedName = targetPackage + out;
        ClassCreator creator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).superClass(ObjectMapperSerializer.class).build();
        creator.close();
        return type.name().packagePrefix() + "." + out;
    }

    public static String generateDeserializer(BuildProducer<GeneratedClassBuildItem> generatedClass, Type type) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        String baseName = type.name().withoutPackagePrefix();
        String targetPackage = DotNames.internalPackageNameWithTrailingSlash((DotName)type.name());
        String out = baseName + "_Deserializer_" + HashUtil.sha1((String)Long.toString(UUID.randomUUID().getMostSignificantBits()));
        String generatedName = targetPackage + out;
        ClassCreator creator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).superClass(ObjectMapperDeserializer.class).build();
        MethodCreator constructor = creator.getMethodCreator("<init>", Void.TYPE, new Class[0]);
        MethodDescriptor superConstructor = MethodDescriptor.ofConstructor(ObjectMapperDeserializer.class, (Class[])new Class[]{Class.class});
        constructor.invokeSpecialMethod(superConstructor, constructor.getThis(), new ResultHandle[]{constructor.loadClass(type.name().toString())});
        constructor.returnValue(null);
        constructor.close();
        creator.close();
        return type.name().packagePrefix() + "." + out;
    }
}

