/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.kafka;

import io.quarkus.smallrye.reactivemessaging.kafka.CheckpointEntityId;
import io.smallrye.reactive.messaging.kafka.commit.ProcessingState;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.MappedSuperclass;
import org.apache.kafka.common.TopicPartition;

@MappedSuperclass
public class CheckpointEntity {
    @EmbeddedId
    CheckpointEntityId id;
    @Column(name="record_offset")
    public Long offset;

    public static <S extends CheckpointEntity> S from(ProcessingState<S> state, CheckpointEntityId entityId) {
        CheckpointEntity stateState = (CheckpointEntity)state.getState();
        stateState.setOffset(state.getOffset());
        if (stateState.getId() == null) {
            stateState.setId(entityId);
        }
        return (S)stateState;
    }

    public static TopicPartition topicPartition(CheckpointEntity entity) {
        if (entity == null) {
            return null;
        }
        CheckpointEntityId id = entity.getId();
        if (id == null) {
            return null;
        }
        return new TopicPartition(id.getTopic(), id.getPartition());
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public CheckpointEntityId getId() {
        return this.id;
    }

    public void setId(CheckpointEntityId id) {
        this.id = id;
    }
}

