/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.rabbitmq.deployment;

import com.rabbitmq.client.impl.CredentialsProvider;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.smallrye.reactivemessaging.rabbitmq.deployment.RabbitMQBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.rabbitmq.runtime.CredentialsProviderLink;
import io.quarkus.smallrye.reactivemessaging.rabbitmq.runtime.RabbitMQRecorder;
import io.smallrye.common.annotation.Identifier;
import javax.enterprise.context.ApplicationScoped;

public class SmallRyeReactiveMessagingRabbitMQProcessor {
    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SMALLRYE_REACTIVE_MESSAGING_RABBITMQ);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void dynamicCredentials(RabbitMQRecorder recorder, RabbitMQBuildTimeConfig rabbitMQBuildTimeConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<RunTimeConfigurationDefaultBuildItem> configDefaults) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(Identifier.class).build());
        if (rabbitMQBuildTimeConfig.credentialsProvider.isPresent()) {
            String credentialsProvider = rabbitMQBuildTimeConfig.credentialsProvider.get();
            RuntimeValue credentialsProviderLink = recorder.configureOptions(credentialsProvider, rabbitMQBuildTimeConfig.credentialsProviderName);
            String identifier = "credentials-provider-link-" + credentialsProvider;
            SyntheticBeanBuildItem.ExtendedBeanConfigurator rabbitMQOptionsConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(CredentialsProviderLink.class).defaultBean()).addType(CredentialsProvider.class)).addQualifier().annotation(Identifier.class).addValue("value", (Object)identifier).done()).scope(ApplicationScoped.class)).runtimeValue(credentialsProviderLink).unremovable()).setRuntimeInit();
            configDefaults.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("rabbitmq-credentials-provider-name", identifier));
            syntheticBeans.produce((BuildItem)rabbitMQOptionsConfigurator.done());
        }
    }
}

