/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.Bean;

@Recorder
public class SmallRyeReactiveMessagingRecorder {
    public void registerMediators(Map<String, String> beanClassToBeanId, BeanContainer container, List<String> emitters) {
        MediatorManager mediatorManager = (MediatorManager)container.instance(MediatorManager.class, new Annotation[0]);
        mediatorManager.initializeEmitters(emitters);
        for (Map.Entry<String, String> entry : beanClassToBeanId.entrySet()) {
            try {
                Class<?> beanClass = Thread.currentThread().getContextClassLoader().loadClass(entry.getKey());
                mediatorManager.analyze(beanClass, (Bean)Arc.container().bean(entry.getValue()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

