/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.stork.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.stork.SmallRyeStorkRecorder;
import io.smallrye.stork.microprofile.MicroProfileConfigProvider;
import io.smallrye.stork.spi.config.ConfigProvider;
import io.smallrye.stork.spi.internal.LoadBalancerLoader;
import io.smallrye.stork.spi.internal.ServiceDiscoveryLoader;
import java.util.Arrays;

public class SmallRyeStorkProcessor {
    @BuildStep
    void registerServiceProviders(BuildProducer<ServiceProviderBuildItem> services) {
        services.produce((BuildItem)new ServiceProviderBuildItem(ConfigProvider.class.getName(), new String[]{MicroProfileConfigProvider.class.getName()}));
        for (Class providerClass : Arrays.asList(LoadBalancerLoader.class, ServiceDiscoveryLoader.class)) {
            services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)providerClass.getName()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    void initializeStork(SmallRyeStorkRecorder storkRecorder, ShutdownContextBuildItem shutdown) {
        storkRecorder.initialize((ShutdownContext)shutdown);
    }
}

