/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.stork;

import io.quarkus.stork.ServiceConfiguration;
import io.quarkus.stork.StorkConfiguration;
import io.smallrye.stork.api.config.LoadBalancerConfig;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.api.config.ServiceDiscoveryConfig;
import io.smallrye.stork.spi.config.SimpleServiceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class StorkConfigUtil {
    public static List<ServiceConfig> toStorkServiceConfig(StorkConfiguration storkConfiguration) {
        ArrayList<ServiceConfig> storkServicesConfigs = new ArrayList<ServiceConfig>();
        Set<String> servicesConfigs = storkConfiguration.serviceConfiguration.keySet();
        SimpleServiceConfig.Builder builder = new SimpleServiceConfig.Builder();
        for (String serviceName : servicesConfigs) {
            builder.setServiceName(serviceName);
            ServiceConfiguration serviceConfiguration = storkConfiguration.serviceConfiguration.get(serviceName);
            SimpleServiceConfig.SimpleServiceDiscoveryConfig storkServiceDiscoveryConfig = new SimpleServiceConfig.SimpleServiceDiscoveryConfig(serviceConfiguration.serviceDiscovery.type, serviceConfiguration.serviceDiscovery.params);
            builder.setServiceDiscovery((ServiceDiscoveryConfig)storkServiceDiscoveryConfig);
            SimpleServiceConfig.SimpleLoadBalancerConfig loadBalancerConfig = new SimpleServiceConfig.SimpleLoadBalancerConfig(serviceConfiguration.loadBalancer.type, serviceConfiguration.loadBalancer.parameters);
            builder.setLoadBalancer((LoadBalancerConfig)loadBalancerConfig);
            storkServicesConfigs.add((ServiceConfig)builder.build());
        }
        return storkServicesConfigs;
    }
}

