/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.boot.properties.deployment;

import io.quarkus.arc.config.ConfigProperties;
import io.quarkus.arc.deployment.configproperties.ConfigPropertiesMetadataBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.springframework.boot.context.properties.ConfigurationProperties;

public class ConfigurationPropertiesProcessor {
    private static final DotName CONFIGURATION_PROPERTIES_ANNOTATION = DotName.createSimple((String)ConfigurationProperties.class.getName());

    @BuildStep
    public FeatureBuildItem registerFeature() {
        return new FeatureBuildItem("spring-boot-properties");
    }

    @BuildStep
    public void produceConfigPropertiesMetadata(CombinedIndexBuildItem combinedIndex, BuildProducer<ConfigPropertiesMetadataBuildItem> configPropertiesMetadataProducer) {
        combinedIndex.getIndex().getAnnotations(CONFIGURATION_PROPERTIES_ANNOTATION).stream().map(annotation -> this.createConfigPropertiesMetadata((AnnotationInstance)annotation, combinedIndex.getIndex())).forEach(arg_0 -> configPropertiesMetadataProducer.produce(arg_0));
    }

    private ConfigPropertiesMetadataBuildItem createConfigPropertiesMetadata(AnnotationInstance annotation, IndexView index) {
        switch (annotation.target().kind()) {
            case CLASS: {
                return this.createConfigPropertiesMetadataFromClass(annotation);
            }
            case METHOD: {
                return this.createConfigPropertiesMetadataFromMethod(annotation, index);
            }
        }
        throw new IllegalArgumentException("Unsupported annotation target kind " + annotation.target().kind().name());
    }

    private ConfigPropertiesMetadataBuildItem createConfigPropertiesMetadataFromClass(AnnotationInstance annotation) {
        return new ConfigPropertiesMetadataBuildItem(annotation.target().asClass(), this.getPrefix(annotation), ConfigProperties.NamingStrategy.VERBATIM, true, false);
    }

    private ConfigPropertiesMetadataBuildItem createConfigPropertiesMetadataFromMethod(AnnotationInstance annotation, IndexView index) {
        return new ConfigPropertiesMetadataBuildItem(index.getClassByName(annotation.target().asMethod().returnType().name()), this.getPrefix(annotation), ConfigProperties.NamingStrategy.VERBATIM, true, false);
    }

    private String getPrefix(AnnotationInstance annotation) {
        if (annotation.value() != null) {
            return annotation.value().asString();
        }
        if (annotation.value("prefix") != null) {
            return annotation.value("prefix").asString();
        }
        return null;
    }
}

