/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.boot.properties.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.config.ConfigProperties;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.configproperties.ConfigPropertiesMetadataBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.spring.boot.properties.runtime.SpringBootConfigProperties;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.springframework.boot.context.properties.ConfigurationProperties;

public class ConfigurationPropertiesProcessor {
    private static final DotName CONFIGURATION_PROPERTIES = DotName.createSimple((String)ConfigurationProperties.class.getName());
    private static final DotName SPRING_BOOT_CONFIG_PROPERTIES = DotName.createSimple((String)SpringBootConfigProperties.class.getName());

    @BuildStep
    public FeatureBuildItem registerFeature() {
        return new FeatureBuildItem(Feature.SPRING_BOOT_PROPERTIES);
    }

    @BuildStep
    public void produceConfigPropertiesMetadata(CombinedIndexBuildItem combinedIndex, ArcConfig arcConfig, BuildProducer<ConfigPropertiesMetadataBuildItem> configPropertiesMetadataProducer, BuildProducer<AnnotationsTransformerBuildItem> transformerProducer) {
        IndexView index = combinedIndex.getIndex();
        ConfigProperties.NamingStrategy namingStrategy = arcConfig.configPropertiesDefaultNamingStrategy;
        final ArrayList<MethodInfo> onMethodInstances = new ArrayList<MethodInfo>();
        ArrayList<ConfigPropertiesMetadataBuildItem> metadata = new ArrayList<ConfigPropertiesMetadataBuildItem>();
        block4: for (AnnotationInstance annotation : combinedIndex.getIndex().getAnnotations(CONFIGURATION_PROPERTIES)) {
            boolean ignoreMismatching = true;
            AnnotationValue ignoreUnknownFieldsValue = annotation.value("ignoreUnknownFields");
            if (ignoreUnknownFieldsValue != null) {
                ignoreMismatching = ignoreUnknownFieldsValue.asBoolean();
            }
            switch (annotation.target().kind()) {
                case CLASS: {
                    metadata.add(new ConfigPropertiesMetadataBuildItem(annotation.target().asClass(), this.getPrefix(annotation), namingStrategy, !ignoreMismatching, false));
                    continue block4;
                }
                case METHOD: {
                    onMethodInstances.add(annotation.target().asMethod());
                    metadata.add(new ConfigPropertiesMetadataBuildItem(index.getClassByName(annotation.target().asMethod().returnType().name()), this.getPrefix(annotation), namingStrategy, !ignoreMismatching, false, (ConfigPropertiesMetadataBuildItem.InstanceFactory)ArcInstanceFactory.INSTANCE));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported annotation target kind " + annotation.target().kind().name());
        }
        if (!onMethodInstances.isEmpty()) {
            transformerProducer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return kind == AnnotationTarget.Kind.METHOD;
                }

                public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                    Collection instances = transformationContext.getAnnotations();
                    boolean matches = false;
                    block0: for (AnnotationInstance instance : instances) {
                        if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                        MethodInfo methodInfo = instance.target().asMethod();
                        for (MethodInfo onMethodInstance : onMethodInstances) {
                            if (!onMethodInstance.equals((Object)methodInfo)) continue;
                            matches = true;
                            continue block0;
                        }
                    }
                    if (!matches) {
                        return;
                    }
                    ((Transformation)transformationContext.transform().add(SPRING_BOOT_CONFIG_PROPERTIES, new AnnotationValue[0])).done();
                }
            }));
        }
        for (ConfigPropertiesMetadataBuildItem bi : metadata) {
            configPropertiesMetadataProducer.produce((BuildItem)bi);
        }
    }

    private ConfigPropertiesMetadataBuildItem createConfigPropertiesMetadataFromMethod(AnnotationInstance annotation, IndexView index, ConfigProperties.NamingStrategy namingStrategy) {
        return new ConfigPropertiesMetadataBuildItem(index.getClassByName(annotation.target().asMethod().returnType().name()), this.getPrefix(annotation), namingStrategy, true, false);
    }

    private String getPrefix(AnnotationInstance annotation) {
        if (annotation.value() != null) {
            return annotation.value().asString();
        }
        if (annotation.value("prefix") != null) {
            return annotation.value("prefix").asString();
        }
        return null;
    }

    private static class ArcInstanceFactory
    implements ConfigPropertiesMetadataBuildItem.InstanceFactory {
        static final ArcInstanceFactory INSTANCE = new ArcInstanceFactory();

        private ArcInstanceFactory() {
        }

        public ResultHandle apply(MethodCreator methodCreator, String configObjectClassName) {
            ResultHandle containerHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle qualifiersHandle = methodCreator.newArray(Annotation.class, 1);
            ResultHandle qualifierInstanceHandle = methodCreator.readStaticField(FieldDescriptor.of(SpringBootConfigProperties.Literal.class, (String)"INSTANCE", SpringBootConfigProperties.Literal.class));
            methodCreator.writeArrayValue(qualifiersHandle, 0, qualifierInstanceHandle);
            ResultHandle instanceHandle = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), containerHandle, new ResultHandle[]{methodCreator.loadClassFromTCCL(configObjectClassName), qualifiersHandle});
            return methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        }
    }
}

