/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.boot.properties.deployment;

import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.spring.boot.properties.deployment.ClassConfigurationPropertiesUtil;
import io.quarkus.spring.boot.properties.deployment.ConfigurationPropertiesMetadataBuildItem;
import io.quarkus.spring.boot.properties.deployment.InterfaceConfigurationPropertiesUtil;
import io.quarkus.spring.boot.properties.deployment.YamlListObjectHandler;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class ConfigurationPropertiesBuildStep {
    @BuildStep
    void setup(CombinedIndexBuildItem combinedIndex, List<ConfigurationPropertiesMetadataBuildItem> configPropertiesMetadataList, Capabilities capabilities, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigValues, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigPropertyBuildItem> configProperties) {
        if (configPropertiesMetadataList.isEmpty()) {
            return;
        }
        GeneratedBeanGizmoAdaptor beansClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        GeneratedClassGizmoAdaptor nonBeansClassOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        ClassCreator producerClassCreator = ClassCreator.builder().classOutput((ClassOutput)beansClassOutput).className("io.quarkus.spring.boot.properties.runtime.config.ConfigPropertiesProducer").build();
        producerClassCreator.addAnnotation(Singleton.class);
        HashSet<DotName> configClassesThatNeedValidation = new HashSet<DotName>(configPropertiesMetadataList.size());
        IndexView index = combinedIndex.getIndex();
        YamlListObjectHandler yamlListObjectHandler = new YamlListObjectHandler((ClassOutput)nonBeansClassOutput, index, reflectiveClasses);
        ClassConfigurationPropertiesUtil classConfigPropertiesUtil = new ClassConfigurationPropertiesUtil(index, yamlListObjectHandler, producerClassCreator, capabilities, reflectiveClasses, reflectiveMethods, configProperties);
        InterfaceConfigurationPropertiesUtil interfaceConfigPropertiesUtil = new InterfaceConfigurationPropertiesUtil(index, yamlListObjectHandler, (ClassOutput)nonBeansClassOutput, producerClassCreator, capabilities, defaultConfigValues, configProperties, reflectiveClasses);
        for (ConfigurationPropertiesMetadataBuildItem configPropertiesMetadata : configPropertiesMetadataList) {
            ClassInfo classInfo = configPropertiesMetadata.getClassInfo();
            if (Modifier.isInterface(classInfo.flags())) {
                HashMap<DotName, InterfaceConfigurationPropertiesUtil.GeneratedClass> interfaceToGeneratedClass = new HashMap<DotName, InterfaceConfigurationPropertiesUtil.GeneratedClass>();
                interfaceConfigPropertiesUtil.generateImplementationForInterfaceConfigProperties(classInfo, configPropertiesMetadata.getPrefix(), configPropertiesMetadata.getNamingStrategy(), interfaceToGeneratedClass);
                for (Map.Entry entry : interfaceToGeneratedClass.entrySet()) {
                    interfaceConfigPropertiesUtil.addProducerMethodForInterfaceConfigProperties((DotName)entry.getKey(), configPropertiesMetadata.getPrefix(), (InterfaceConfigurationPropertiesUtil.GeneratedClass)entry.getValue());
                }
                continue;
            }
            boolean needsValidation = classConfigPropertiesUtil.addProducerMethodForClassConfigProperties(Thread.currentThread().getContextClassLoader(), classInfo, configPropertiesMetadata.getPrefix(), configPropertiesMetadata.getNamingStrategy(), configPropertiesMetadata.isFailOnMismatchingMember(), configPropertiesMetadata.getInstanceFactory());
            if (!needsValidation) continue;
            configClassesThatNeedValidation.add(classInfo.name());
        }
        producerClassCreator.close();
        if (!configClassesThatNeedValidation.isEmpty()) {
            ClassConfigurationPropertiesUtil.generateStartupObserverThatInjectsConfigClass((ClassOutput)beansClassOutput, configClassesThatNeedValidation);
        }
    }
}

