/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.boot.properties.deployment;

import io.quarkus.spring.boot.properties.deployment.ConfigPropertyBuildItemCandidate;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ConfigPropertyBuildItemCandidateUtil {
    private static final Logger LOGGER = Logger.getLogger(ConfigPropertyBuildItemCandidateUtil.class);

    public static void removePropertiesWithDefaultValue(ClassLoader classLoader, String configClass, List<ConfigPropertyBuildItemCandidate> candidates) {
        try (InputStream is = classLoader.getResourceAsStream(configClass.replace('.', '/') + ".class");){
            ClassReader configClassReader = new ClassReader(is);
            configClassReader.accept((ClassVisitor)new ConfigClassVisitor(candidates, configClass), 0);
        }
        catch (IOException e) {
            throw new UncheckedIOException(configClass + " class reading failed", e);
        }
    }

    private static class ConfigClassConstructorVisitor
    extends MethodVisitor {
        private List<ConfigPropertyBuildItemCandidate> candidates;

        private ConfigClassConstructorVisitor(MethodVisitor superMethodVisitor, List<ConfigPropertyBuildItemCandidate> candidates) {
            super(589824, superMethodVisitor);
            this.candidates = candidates;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            if (opcode == 181) {
                this.candidates.removeIf(candidate -> candidate.getFieldName().equals(name));
            }
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }
    }

    private static class ConfigClassVisitor
    extends ClassVisitor {
        private final List<ConfigPropertyBuildItemCandidate> candidates;
        private final String configClass;

        private ConfigClassVisitor(List<ConfigPropertyBuildItemCandidate> candidates, String configClass) {
            super(589824);
            this.candidates = candidates;
            this.configClass = configClass;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor superMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("<init>") && descriptor.equals("()V")) {
                if (access != 1) {
                    LOGGER.warn((Object)("Class '" + this.configClass + "' which is meant to hold configuration properties does not have a public constructor and therefore may not function correctly"));
                }
                return new ConfigClassConstructorVisitor(superMethodVisitor, this.candidates);
            }
            return superMethodVisitor;
        }
    }
}

