/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cloud.config.client.runtime;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.spring.cloud.config.client.runtime.Response;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientConfig;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientGateway;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

class DefaultSpringCloudConfigClientGateway
implements SpringCloudConfigClientGateway {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final SpringCloudConfigClientConfig springCloudConfigClientConfig;
    private final SSLConnectionSocketFactory sslSocketFactory;
    private final URI baseURI;

    public DefaultSpringCloudConfigClientGateway(SpringCloudConfigClientConfig springCloudConfigClientConfig) {
        this.springCloudConfigClientConfig = springCloudConfigClientConfig;
        try {
            this.baseURI = this.determineBaseUri(springCloudConfigClientConfig);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Value: '" + springCloudConfigClientConfig.url + "' of property 'quarkus.spring-cloud-config.url' is invalid", e);
        }
        this.sslSocketFactory = springCloudConfigClientConfig.trustStore.isPresent() || springCloudConfigClientConfig.keyStore.isPresent() || springCloudConfigClientConfig.trustCerts ? this.createFactoryFromAgentConfig(springCloudConfigClientConfig) : null;
    }

    private URI determineBaseUri(SpringCloudConfigClientConfig springCloudConfigClientConfig) throws URISyntaxException {
        String url = springCloudConfigClientConfig.url;
        if (null == url || url.isEmpty()) {
            throw new IllegalArgumentException("The 'quarkus.spring-cloud-config.url' property cannot be empty");
        }
        if (url.endsWith("/")) {
            return new URI(url.substring(0, url.length() - 1));
        }
        return new URI(url);
    }

    private SSLConnectionSocketFactory createFactoryFromAgentConfig(SpringCloudConfigClientConfig springCloudConfigClientConfig) {
        try {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (springCloudConfigClientConfig.trustStore.isPresent()) {
                sslContextBuilder = sslContextBuilder.loadTrustMaterial(DefaultSpringCloudConfigClientGateway.readStore(springCloudConfigClientConfig.trustStore.get(), springCloudConfigClientConfig.trustStorePassword), null);
            } else if (springCloudConfigClientConfig.trustCerts) {
                sslContextBuilder = sslContextBuilder.loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE);
            }
            if (springCloudConfigClientConfig.keyStore.isPresent()) {
                String keyPassword = springCloudConfigClientConfig.keyPassword.orElse(springCloudConfigClientConfig.keyStorePassword.orElse(""));
                sslContextBuilder = sslContextBuilder.loadKeyMaterial(DefaultSpringCloudConfigClientGateway.readStore(springCloudConfigClientConfig.keyStore.get(), springCloudConfigClientConfig.keyStorePassword), keyPassword.toCharArray());
            }
            return new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static String findKeystoreFileType(Path keyStorePath) {
        String pathName = keyStorePath.toString().toLowerCase();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return "PKS12";
        }
        return "JKS";
    }

    private static KeyStore readStore(Path keyStorePath, Optional<String> keyStorePassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        String keyStoreType = DefaultSpringCloudConfigClientGateway.findKeystoreFileType(keyStorePath);
        InputStream classPathResource = Thread.currentThread().getContextClassLoader().getResourceAsStream(keyStorePath.toString());
        if (classPathResource != null) {
            try (InputStream is = classPathResource;){
                KeyStore keyStore = DefaultSpringCloudConfigClientGateway.doReadStore(is, keyStoreType, keyStorePassword);
                return keyStore;
            }
        }
        try (InputStream is = Files.newInputStream(keyStorePath, new OpenOption[0]);){
            KeyStore keyStore = DefaultSpringCloudConfigClientGateway.doReadStore(is, keyStoreType, keyStorePassword);
            return keyStore;
        }
    }

    private static KeyStore doReadStore(InputStream keyStoreStream, String keyStoreType, Optional<String> keyStorePassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(keyStoreStream, keyStorePassword.isPresent() ? keyStorePassword.get().toCharArray() : null);
        return keyStore;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Response exchange(String applicationName, String profile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URI finalURI(String applicationName, String profile) throws URISyntaxException {
        URIBuilder result = new URIBuilder(this.baseURI);
        if (result.getPort() == -1) {
            result.setPort(result.getScheme().equalsIgnoreCase("http") ? 80 : 443);
        }
        ArrayList<String> finalPathSegments = new ArrayList<String>(result.getPathSegments());
        finalPathSegments.add(applicationName);
        finalPathSegments.add(profile);
        if (this.springCloudConfigClientConfig.label.isPresent()) {
            finalPathSegments.add(this.springCloudConfigClientConfig.label.get());
        }
        result.setPathSegments(finalPathSegments);
        return result.build();
    }

    private HttpClientContext setupContext(URI finalURI) {
        HttpClientContext context = HttpClientContext.create();
        if (this.baseURI.getUserInfo() != null || this.springCloudConfigClientConfig.usernameAndPasswordSet()) {
            InMemoryAuthCache authCache = InMemoryAuthCache.INSTANCE;
            authCache.put(new HttpHost(finalURI.getHost(), finalURI.getPort(), finalURI.getScheme()), (AuthScheme)new BasicScheme());
            context.setAuthCache((AuthCache)authCache);
            if (this.springCloudConfigClientConfig.usernameAndPasswordSet()) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.springCloudConfigClientConfig.username.get(), this.springCloudConfigClientConfig.password.get());
                provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                context.setCredentialsProvider((CredentialsProvider)provider);
            }
        }
        return context;
    }

    private static class InMemoryAuthCache
    implements AuthCache {
        static final InMemoryAuthCache INSTANCE = new InMemoryAuthCache();
        private final Map<HttpHost, AuthScheme> map = new ConcurrentHashMap<HttpHost, AuthScheme>();

        private InMemoryAuthCache() {
        }

        public void put(HttpHost host, AuthScheme authScheme) {
            this.map.put(host, authScheme);
        }

        public AuthScheme get(HttpHost host) {
            return this.map.get(host);
        }

        public void remove(HttpHost host) {
            this.map.remove(host);
        }

        public void clear() {
            this.map.clear();
        }
    }
}

